/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.SlowOperations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001aE\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018\u00a2\u0006\u0002\u0010\u0019\u001a,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a9\u0010\u001e\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011H\u0002\u001a1\u0010!\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a1\u0010$\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a\u0010\u0010&\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a1\u0010'\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002\u001a.\u0010*\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010\u00010\u00010\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0007\u001a1\u0010,\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a\u0010\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015*\u00020/\u001a\f\u00100\u001a\u0004\u0018\u00010\u0001*\u00020/\u001a(\u00101\u001a\u00020\u0001*\u00020/2\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107\u001a\u0014\u00108\u001a\u0004\u0018\u00010\u0001*\u00020/2\u0006\u00109\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000*\"\u0010:\"\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a8\u0006;"}, d2={"ANDROID_THEME", "", "ANDROID_THEME_PREFIX", "MAX_RECENTLY_USED_THEMES", "", "PROJECT_THEME", "PROJECT_THEME_PREFIX", "RECENTLY_USED_THEMES_PROPERTY", "addRecentlyUsedTheme", "", "project", "Lcom/intellij/openapi/project/Project;", "theme", "createFilter", "Lkotlin/Function1;", "Lcom/android/tools/idea/editors/theme/datamodels/ConfiguredThemeEditorStyle;", "", "Lcom/android/tools/idea/configurations/ThemeStyleFilter;", "resolver", "Lcom/android/tools/idea/editors/theme/ThemeResolver;", "excludedNames", "", "baseThemes", "", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "(Lcom/android/tools/idea/editors/theme/ThemeResolver;Ljava/util/Set;[Lcom/android/ide/common/rendering/api/StyleResourceValue;)Lkotlin/jvm/functions/Function1;", "getFilteredByPrefixSortedByName", "", "themes", "excludedPrefixes", "getFilteredNames", "Lorg/jetbrains/annotations/NotNull;", "filter", "getFrameworkThemeNames", "themeResolver", "getFrameworkThemes", "getLibraryThemeNames", "getLibraryThemes", "getPreferredThemeName", "getProjectThemeNames", "getProjectThemes", "getPublicThemes", "getRecentlyUsedThemes", "kotlin.jvm.PlatformType", "getRecommendedThemeNames", "getRecommendedThemes", "getAllActivityThemeNames", "Lcom/intellij/openapi/module/Module;", "getAppThemeName", "getDefaultTheme", "renderingTarget", "Lcom/android/sdklib/IAndroidTarget;", "screenSize", "Lcom/android/resources/ScreenSize;", "device", "Lcom/android/sdklib/devices/Device;", "getThemeNameForActivity", "activityFqcn", "ThemeStyleFilter", "intellij.android.core"})
@JvmName(name="ThemeUtils")
public final class ThemeUtils {
    @NotNull
    private static final String ANDROID_THEME = "android:Theme";
    @NotNull
    private static final String ANDROID_THEME_PREFIX = "android:Theme.";
    @NotNull
    private static final String PROJECT_THEME_PREFIX = "Theme.";
    @NotNull
    private static final String PROJECT_THEME = "Theme";
    @NotNull
    private static final String RECENTLY_USED_THEMES_PROPERTY = "android.recentlyUsedThemes";
    private static final int MAX_RECENTLY_USED_THEMES = 5;

    @NotNull
    public static final String getPreferredThemeName(@NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (Intrinsics.areEqual((Object)theme, (Object)ANDROID_THEME) || Intrinsics.areEqual((Object)theme, (Object)PROJECT_THEME)) {
            return PROJECT_THEME;
        }
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)theme, (CharSequence)ANDROID_THEME_PREFIX), (CharSequence)PROJECT_THEME_PREFIX), (CharSequence)"@style/");
    }

    @NotNull
    public static final Function1<ConfiguredThemeEditorStyle, Boolean> createFilter(@NotNull ThemeResolver resolver, @NotNull Set<String> excludedNames, StyleResourceValue ... baseThemes) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        Intrinsics.checkNotNullParameter((Object)baseThemes, (String)"baseThemes");
        if (baseThemes.length == 0) {
            return (Function1)new Function1<ConfiguredThemeEditorStyle, Boolean>(excludedNames){
                final /* synthetic */ Set<String> $excludedNames;
                {
                    this.$excludedNames = $excludedNames;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ConfiguredThemeEditorStyle style) {
                    Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                    return !this.$excludedNames.contains(style.getQualifiedName());
                }
            };
        }
        return (Function1)new Function1<ConfiguredThemeEditorStyle, Boolean>(excludedNames, resolver, baseThemes){
            final /* synthetic */ Set<String> $excludedNames;
            final /* synthetic */ ThemeResolver $resolver;
            final /* synthetic */ StyleResourceValue[] $baseThemes;
            {
                this.$excludedNames = $excludedNames;
                this.$resolver = $resolver;
                this.$baseThemes = $baseThemes;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ConfiguredThemeEditorStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                return !this.$excludedNames.contains(style.getQualifiedName()) && this.$resolver.themeIsChildOfAny((StyleResourceValue)style.getStyleResourceValue(), Arrays.copyOf(this.$baseThemes, this.$baseThemes.length));
            }
        };
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getFrameworkThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getFrameworkThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.frameworkThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getFrameworkThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getFrameworkThemes(themeResolver), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getProjectThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getLocalThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.localThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getProjectThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getProjectThemes(themeResolver), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getLibraryThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.externalLibraryThemes");
        Object[] objectArray = new String[]{"Base.", "Platform."};
        return ThemeUtils.getFilteredByPrefixSortedByName(ThemeUtils.getPublicThemes((List)immutableList), SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public static final List<String> getLibraryThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.externalLibraryThemes");
        return ThemeUtils.getFilteredNames(ThemeUtils.getPublicThemes((List)immutableList), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getRecommendedThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        List<ResourceReference> list2 = themeResolver.getRecommendedThemes();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"themeResolver.recommendedThemes");
        List<ResourceReference> recommendedThemes = list2;
        Object[] objectArray = new List[]{ThemeUtils.getLibraryThemes(themeResolver), ThemeUtils.getFrameworkThemes(themeResolver)};
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (Function1)((Function1)new Function1<ConfiguredThemeEditorStyle, Boolean>(recommendedThemes){
            final /* synthetic */ List<ResourceReference> $recommendedThemes;
            {
                this.$recommendedThemes = $recommendedThemes;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ConfiguredThemeEditorStyle it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$recommendedThemes.contains(it.getStyleReference());
            }
        })));
    }

    @NotNull
    public static final List<String> getRecommendedThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getRecommendedThemes(themeResolver), filter2);
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project, @NotNull Set<String> excludedNames) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        List list3 = PropertiesComponent.getInstance((Project)project).getList(RECENTLY_USED_THEMES_PROPERTY);
        return list3 != null && (list2 = CollectionsKt.minus((Iterable)list3, (Iterable)excludedNames)) != null ? list2 : CollectionsKt.emptyList();
    }

    public static /* synthetic */ List getRecentlyUsedThemes$default(Project project, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getRecentlyUsedThemes(project, set);
    }

    public static final void addRecentlyUsedTheme(@NotNull Project project, @NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Collection collection2 = PropertiesComponent.getInstance((Project)project).getList(RECENTLY_USED_THEMES_PROPERTY);
        if (collection2 == null || (collection2 = CollectionsKt.toSet((Iterable)collection2)) == null) {
            collection2 = SetsKt.emptySet();
        }
        Collection old2 = collection2;
        List list2 = CollectionsKt.take((Iterable)SetsKt.plus((Set)SetsKt.setOf((Object)theme), (Iterable)old2), (int)5);
        PropertiesComponent.getInstance((Project)project).setList(RECENTLY_USED_THEMES_PROPERTY, (Collection)list2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getPublicThemes(List<? extends ConfiguredThemeEditorStyle> themes) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)element$iv$iv;
            boolean bl = false;
            if (!it.isPublic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getFilteredByPrefixSortedByName(List<? extends ConfiguredThemeEditorStyle> themes, Set<String> excludedPrefixes) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                ConfiguredThemeEditorStyle theme = (ConfiguredThemeEditorStyle)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = excludedPrefixes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String prefix = (String)element$iv;
                        boolean bl3 = false;
                        String string = theme.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"theme.name");
                        if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getQualifiedName());
                it = (ConfiguredThemeEditorStyle)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getQualifiedName())));
            }
        });
    }

    static /* synthetic */ List getFilteredByPrefixSortedByName$default(List list2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getFilteredByPrefixSortedByName(list2, set);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getFilteredNames(List<? extends ConfiguredThemeEditorStyle> themes, Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConfiguredThemeEditorStyle configuredThemeEditorStyle = (ConfiguredThemeEditorStyle)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getQualifiedName());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final String getAppThemeName(@NotNull Module $this$getAppThemeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppThemeName, (String)"<this>");
        try {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)$this$getAppThemeName);
            if (facet2 != null) {
                return (String)DumbService.getInstance((Project)$this$getAppThemeName.getProject()).runReadActionInSmartMode(new Computable(facet2){
                    final /* synthetic */ AndroidFacet $facet;
                    {
                        this.$facet = $facet;
                    }

                    @Nullable
                    public final String compute() {
                        return (String)SlowOperations.allowSlowOperations((ThrowableComputable)new ThrowableComputable(this.$facet){
                            final /* synthetic */ AndroidFacet $facet;
                            {
                                this.$facet = $facet;
                            }

                            @Nullable
                            public final String compute() {
                                return AndroidManifestIndexQueryUtils.queryApplicationThemeFromManifestIndex(this.$facet);
                            }
                        });
                    }
                });
            }
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
        }
        return MergedManifestManager.Companion.getFreshSnapshot($this$getAppThemeName).getManifestTheme();
    }

    @NotNull
    public static final Set<String> getAllActivityThemeNames(@NotNull Module $this$getAllActivityThemeNames) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllActivityThemeNames, (String)"<this>");
        try {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)$this$getAllActivityThemeNames);
            if (facet2 != null) {
                Object object = DumbService.getInstance((Project)$this$getAllActivityThemeNames.getProject()).runReadActionInSmartMode(new Computable(facet2){
                    final /* synthetic */ AndroidFacet $facet;
                    {
                        this.$facet = $facet;
                    }

                    public final Set<String> compute() {
                        List activities2 = (List)SlowOperations.allowSlowOperations((ThrowableComputable)new ThrowableComputable(this.$facet){
                            final /* synthetic */ AndroidFacet $facet;
                            {
                                this.$facet = $facet;
                            }

                            public final List<DefaultActivityLocator.ActivityWrapper> compute() {
                                return AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(this.$facet).getActivities();
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)activities2, (String)"activities");
                        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)activities2), (Function1)getAllActivityThemeNames.1.INSTANCE));
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"val facet = AndroidFacet\u2026        .toSet()\n      })");
                return (Set)object;
            }
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
        }
        MergedManifestSnapshot manifest = MergedManifestManager.Companion.getSnapshot($this$getAllActivityThemeNames);
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)manifest.getActivityAttributesMap().values()), (Function1)getAllActivityThemeNames.2.INSTANCE));
    }

    @Nullable
    public static final String getThemeNameForActivity(@NotNull Module $this$getThemeNameForActivity, @NotNull String activityFqcn) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getThemeNameForActivity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)activityFqcn, (String)"activityFqcn");
        try {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)$this$getThemeNameForActivity);
            if (facet2 != null) {
                return (String)DumbService.getInstance((Project)$this$getThemeNameForActivity.getProject()).runReadActionInSmartMode(new Computable(facet2, activityFqcn){
                    final /* synthetic */ AndroidFacet $facet;
                    final /* synthetic */ String $activityFqcn;
                    {
                        this.$facet = $facet;
                        this.$activityFqcn = $activityFqcn;
                    }

                    @Nullable
                    public final String compute() {
                        List activities2 = (List)SlowOperations.allowSlowOperations((ThrowableComputable)new ThrowableComputable(this.$facet){
                            final /* synthetic */ AndroidFacet $facet;
                            {
                                this.$facet = $facet;
                            }

                            public final List<DefaultActivityLocator.ActivityWrapper> compute() {
                                return AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(this.$facet).getActivities();
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)activities2, (String)"activities");
                        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)activities2), (Function1)((Function1)new Function1<DefaultActivityLocator.ActivityWrapper, Boolean>(this.$activityFqcn){
                            final /* synthetic */ String $activityFqcn;
                            {
                                this.$activityFqcn = $activityFqcn;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull DefaultActivityLocator.ActivityWrapper it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.$activityFqcn);
                            }
                        })), (Function1)getThemeNameForActivity.2.INSTANCE), (Function1)getThemeNameForActivity.3.INSTANCE));
                    }
                });
            }
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
        }
        MergedManifestSnapshot manifest = MergedManifestManager.Companion.getSnapshot($this$getThemeNameForActivity);
        ActivityAttributesSnapshot activityAttributesSnapshot = manifest.getActivityAttributes(activityFqcn);
        if (activityAttributesSnapshot != null && (string2 = activityAttributesSnapshot.getTheme()) != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = StringsKt.startsWith$default((String)it, (String)"@", (boolean)false, (int)2, null) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String getDefaultTheme(@NotNull Module $this$getDefaultTheme, @Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device2) {
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultTheme, (String)"<this>");
        if (device2 != null) {
            if (HardwareConfigHelper.isWear((Device)device2)) {
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device2)) {
                return "@style/Theme.Leanback";
            }
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)$this$getDefaultTheme);
        if (androidFacet == null) {
            return "@android:style/Theme.Material.Light";
        }
        AndroidFacet facet2 = androidFacet;
        int targetSdk = AndroidModuleInfo.getInstance(facet2).getTargetSdkVersion().getApiLevel();
        IAndroidTarget iAndroidTarget = renderingTarget;
        int renderingTargetSdk = iAndroidTarget != null && (iAndroidTarget = iAndroidTarget.getVersion()) != null ? iAndroidTarget.getApiLevel() : targetSdk;
        int apiLevel = RangesKt.coerceAtMost((int)targetSdk, (int)renderingTargetSdk);
        return "@android:style/" + (apiLevel >= 21 ? "Theme.Material.Light" : (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE ? "Theme.Holo" : PROJECT_THEME));
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ThemeUtils.getRecentlyUsedThemes$default(project, null, 2, null);
    }
}

