/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;

    public ThemeMenuAction(@NotNull ConfigurationHolder renderContext) {
        super("Theme for Preview", "Theme for Preview", StudioIcons.LayoutEditor.Toolbar.THEME_BUTTON);
        this.myRenderContext = renderContext;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @NotNull
    public static String getThemeLabel(@Nullable String theme, boolean brief) {
        int index2;
        if (theme == null) {
            return "";
        }
        theme = IdeResourcesUtil.styleToTheme(theme);
        if (brief && (index2 = theme.lastIndexOf(46)) < theme.length() - 1) {
            return theme.substring(index2 + 1);
        }
        return theme;
    }

    protected boolean updateActions(@NotNull DataContext context2) {
        this.removeAll();
        this.addThemeActions();
        this.add((AnAction)new MoreThemesAction());
        return true;
    }

    private void addThemeActions() {
        Configuration conf = this.myRenderContext.getConfiguration();
        if (conf == null) {
            return;
        }
        ThemeResolver themeResolver = new ThemeResolver(this.myRenderContext.getConfiguration());
        StyleResourceValue[] baseThemes = themeResolver.requiredBaseThemes();
        String currentThemeName = this.getCurrentTheme();
        String defaultTheme = this.getDefaultTheme();
        if (defaultTheme != null) {
            String themeName = ThemeUtils.getPreferredThemeName(defaultTheme);
            this.add(new SetThemeAction(this.myRenderContext, themeName, themeName + " [default]", ThemeMenuAction.isSameTheme(defaultTheme, currentThemeName)));
            this.addSeparator();
        }
        ImmutableSet excludedThemes = defaultTheme != null ? ImmutableSet.of((Object)defaultTheme) : ImmutableSet.of();
        Function1<ConfiguredThemeEditorStyle, Boolean> filter2 = ThemeUtils.createFilter(themeResolver, (Set<String>)excludedThemes, baseThemes);
        List<String> projectThemeWithoutDefaultTheme = ThemeUtils.getProjectThemeNames(themeResolver, filter2);
        this.addThemes(projectThemeWithoutDefaultTheme, currentThemeName, false);
        List<String> recommendedThemes = ThemeUtils.getRecommendedThemeNames(themeResolver, filter2);
        this.addThemes(recommendedThemes, currentThemeName, true);
        Configuration config2 = this.myRenderContext.getConfiguration();
        if (config2 != null) {
            Project project = config2.getModule().getProject();
            HashSet<String> existingThemes = new HashSet<String>();
            existingThemes.addAll((Collection<String>)excludedThemes);
            existingThemes.addAll(projectThemeWithoutDefaultTheme);
            existingThemes.addAll(recommendedThemes);
            List<String> recentUsedThemes = ThemeUtils.getRecentlyUsedThemes(project, existingThemes);
            this.addThemes(recentUsedThemes, currentThemeName, true);
        }
    }

    @Nullable
    private String getCurrentTheme() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        String theme = configuration.getTheme();
        theme = ThemeMenuAction.convertToNonResourcePrefixName(theme);
        return theme;
    }

    @Nullable
    private String getDefaultTheme() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        String theme = configurationManager.computePreferredTheme(configuration);
        return ThemeMenuAction.convertToNonResourcePrefixName(theme);
    }

    private void addThemes(List<String> themes, @Nullable String currentSelectedTheme, boolean builtInTheme) {
        if (themes.isEmpty()) {
            return;
        }
        for (String theme : themes) {
            String displayName2 = ThemeMenuAction.getThemeLabel(theme);
            if (builtInTheme) {
                displayName2 = ThemeUtils.getPreferredThemeName(displayName2);
            }
            this.add(new SetThemeAction(this.myRenderContext, theme, displayName2, ThemeMenuAction.isSameTheme(theme, currentSelectedTheme)));
        }
        this.addSeparator();
    }

    @NotNull
    private static String getThemeLabel(@NotNull String theme) {
        return ResolutionUtils.getNameFromQualifiedName(theme.substring(theme.indexOf(47) + 1));
    }

    private static boolean isSameTheme(@Nullable String left2, @Nullable String right) {
        if (left2 == null) {
            return right == null;
        }
        return right != null && ThemeMenuAction.convertToNonResourcePrefixName(left2).equals(ThemeMenuAction.convertToNonResourcePrefixName(right));
    }

    @NotNull
    private static String convertToNonResourcePrefixName(@NotNull String theme) {
        if (theme.startsWith("@android:style/")) {
            theme = theme.replace("@android:style/", "android:");
        }
        if (theme.startsWith("@style/")) {
            theme = theme.replace("@style/", "");
        }
        return theme;
    }

    @VisibleForTesting
    public class MoreThemesAction
    extends DumbAwareAction {
        public MoreThemesAction() {
            super("More Themes...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String theme;
            ThemeSelectionDialog dialog2;
            Configuration configuration = ThemeMenuAction.this.myRenderContext.getConfiguration();
            if (configuration != null && (dialog2 = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog2.getTheme()) != null) {
                configuration.setTheme(theme);
                ThemeUtils.addRecentlyUsedTheme(configuration.getModule().getProject(), theme);
            }
        }
    }

    private class SetThemeAction
    extends ConfigurationAction {
        private final String myTheme;
        private final boolean mySelected;

        public SetThemeAction(@NotNull ConfigurationHolder configurationHolder, @NotNull String theme, String themeDisplayName, boolean selected) {
            super(configurationHolder, themeDisplayName);
            this.myTheme = theme;
            this.mySelected = selected;
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.mySelected);
        }

        @Override
        protected void updatePresentation(@NotNull Presentation presentation) {
            ThemeMenuAction.this.updatePresentation(presentation);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setTheme(this.myTheme);
            if (ThemeUtils.getRecentlyUsedThemes(configuration.getModule().getProject()).contains(this.myTheme)) {
                ThemeUtils.addRecentlyUsedTheme(configuration.getModule().getProject(), this.myTheme);
            }
        }
    }
}

