/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.CompatibilityRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetMenuAction
extends DropDownAction {
    private static final int SHOW_FROM_API_LEVEL = 7;
    private final ConfigurationHolder myRenderContext;
    private final boolean myUseCompatibilityTarget;

    public TargetMenuAction(ConfigurationHolder renderContext, boolean useCompatibilityTarget) {
        super("API Version for Preview", "API Version for Preview", StudioIcons.LayoutEditor.Toolbar.ANDROID_API);
        boolean visible;
        this.myRenderContext = renderContext;
        this.myUseCompatibilityTarget = useCompatibilityTarget;
        Presentation presentation = this.getTemplatePresentation();
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            IAndroidTarget target2 = configuration.getTarget();
            String brief = TargetMenuAction.getRenderingTargetLabel(target2, true);
            presentation.setText(brief);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public TargetMenuAction(ConfigurationHolder renderContext) {
        this(renderContext, false);
    }

    public void update(@NotNull AnActionEvent e) {
        IAndroidTarget target2;
        String brief;
        boolean visible;
        Presentation presentation = e.getPresentation();
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible && !(brief = TargetMenuAction.getRenderingTargetLabel(target2 = configuration.getTarget(), true)).equals(presentation.getText())) {
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private int getMinSdkVersion() {
        AndroidFacet facet2;
        Module module2;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (module2 = configuration.getModule()) != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null) {
            return AndroidModuleInfo.getInstance(facet2).getMinSdkVersion().getFeatureLevel();
        }
        return -1;
    }

    private void addCompatibilityTargets(@NotNull DefaultActionGroup group2) {
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget currentTarget = configuration.getTarget();
        IAndroidTarget highestTarget = configuration.getConfigurationManager().getHighestApiTarget();
        assert (highestTarget != null);
        int highestApiLevel = highestTarget.getVersion().getFeatureLevel();
        int minApi = Math.max(this.getMinSdkVersion(), 7);
        for (int apiLevel = highestApiLevel; apiLevel >= minApi; --apiLevel) {
            CompatibilityRenderTarget target2 = new CompatibilityRenderTarget(highestTarget, apiLevel, null);
            boolean isSelected = currentTarget != null && target2.getVersion().equals((Object)currentTarget.getVersion());
            group2.add((AnAction)new SetTargetAction(this.myRenderContext, target2.getVersionName(), target2, isSelected));
        }
    }

    private void addRealTargets(@NotNull DefaultActionGroup group2) {
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget current = configuration.getTarget();
        IAndroidTarget[] targets = configuration.getConfigurationManager().getTargets();
        boolean haveRecent = false;
        int minSdk = this.getMinSdkVersion();
        for (int i = targets.length - 1; i >= 0; --i) {
            AndroidVersion version2;
            IAndroidTarget target2 = targets[i];
            if (!ConfigurationManager.isLayoutLibTarget(target2) || (version2 = target2.getVersion()).getFeatureLevel() < minSdk) continue;
            if (version2.getApiLevel() >= 7) {
                haveRecent = true;
            } else if (haveRecent) break;
            String title = TargetMenuAction.getRenderingTargetLabel(target2, true);
            boolean select2 = current != null && target2.getVersion().equals((Object)current.getVersion());
            group2.add((AnAction)new SetTargetAction(this.myRenderContext, title, target2, select2));
        }
    }

    protected boolean updateActions(@NotNull DataContext context2) {
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return true;
        }
        this.add(new TogglePickBestAction(configuration.getConfigurationManager()));
        this.addSeparator();
        if (this.myUseCompatibilityTarget && configuration.getConfigurationManager().getHighestApiTarget() != null) {
            this.addCompatibilityTargets((DefaultActionGroup)this);
        } else {
            this.addRealTargets((DefaultActionGroup)this);
        }
        return true;
    }

    public static String getRenderingTargetLabel(@Nullable IAndroidTarget target2, boolean brief) {
        if (target2 == null) {
            return "<null>";
        }
        AndroidVersion version2 = target2.getVersion();
        if (brief) {
            if (target2.isPlatform()) {
                String codename = version2.getCodename();
                if (codename != null && !codename.isEmpty()) {
                    if (codename.length() <= 3) {
                        return codename;
                    }
                    return Character.toString(codename.charAt(0));
                }
                return Integer.toString(version2.getApiLevel());
            }
            return target2.getName() + ":" + Integer.toString(version2.getApiLevel());
        }
        return String.format(Locale.US, "API %1$d: %2$s", version2.getApiLevel(), target2.getShortClasspathName());
    }

    private static class SetTargetAction
    extends ConfigurationAction {
        private final IAndroidTarget myTarget;

        public SetTargetAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull IAndroidTarget target2, boolean select2) {
            super(renderContext, title);
            this.myTarget = target2;
            this.getTemplatePresentation().putClientProperty("selected", (Object)select2);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (commit) {
                this.setProjectWideTarget();
            } else {
                configuration.setTarget(this.myTarget);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file2, @NotNull VirtualFile old2) {
            super.pickedBetterMatch(file2, old2);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideTarget();
            }
        }

        private void setProjectWideTarget() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setTarget(this.myTarget);
            }
        }
    }

    private static class TogglePickBestAction
    extends AnAction
    implements Toggleable {
        private final ConfigurationManager myManager;

        TogglePickBestAction(ConfigurationManager manager) {
            super("Automatically Pick Best");
            this.myManager = manager;
            if (manager.getStateManager().getProjectState().isPickTarget()) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            }
        }

        private boolean isSelected() {
            return this.myManager.getStateManager().getProjectState().isPickTarget();
        }

        private void setSelected(boolean state2) {
            this.myManager.getStateManager().getProjectState().setPickTarget(state2);
            if (state2) {
                this.myManager.setTarget(null);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            this.setSelected(!this.isSelected());
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.isSelected());
        }
    }
}

