/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.AdaptiveIconShape;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class ShapeMenuAction
extends DropDownAction {
    @NotNull
    private final ConfigurationHolder myRenderContext;

    public ShapeMenuAction(@NotNull ConfigurationHolder renderContext) {
        super("Adaptive Icon Shape", "Adaptive Icon Shape", null);
        this.myRenderContext = renderContext;
        for (AdaptiveIconShape shape : AdaptiveIconShape.values()) {
            this.add(new SetShapeAction(this.myRenderContext, shape));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Configuration configuration = this.myRenderContext.getConfiguration();
        AdaptiveIconShape shape = configuration != null ? configuration.getAdaptiveShape() : AdaptiveIconShape.getDefaultShape();
        e.getPresentation().setText(shape.getName());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private static class SetShapeAction
    extends ConfigurationAction {
        private final AdaptiveIconShape myShape;

        private SetShapeAction(@NotNull ConfigurationHolder renderContext, @NotNull AdaptiveIconShape shape) {
            super(renderContext, shape.getName());
            this.myShape = shape;
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setAdaptiveShape(this.myShape);
        }
    }
}

