/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.DeviceMenuAction2Kt;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u0016B\u001d\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0001j\b\u0012\u0004\u0012\u00020\u0005`\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0001j\b\u0012\u0004\u0012\u00020\u0005`\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/configurations/PixelDeviceComparator;", "Ljava/util/Comparator;", "Lcom/android/sdklib/devices/Device;", "Lkotlin/Comparator;", "varianceComparator", "", "(Ljava/util/Comparator;)V", "getVarianceComparator", "()Ljava/util/Comparator;", "compare", "", "o1", "o2", "compareGeneration", "name1", "name2", "getGenerationAndSuffixPair", "Lkotlin/Pair;", "str", "getSeries", "Lcom/android/tools/idea/configurations/PixelDeviceComparator$Series;", "name", "Series", "intellij.android.core"})
final class PixelDeviceComparator
implements Comparator<Device> {
    @NotNull
    private final Comparator<String> varianceComparator;

    public PixelDeviceComparator(@NotNull Comparator<String> varianceComparator) {
        Intrinsics.checkNotNullParameter(varianceComparator, (String)"varianceComparator");
        this.varianceComparator = varianceComparator;
    }

    @NotNull
    public final Comparator<String> getVarianceComparator() {
        return this.varianceComparator;
    }

    private final Series getSeries(String name) {
        return StringsKt.startsWith$default((String)name, (String)"Pixel", (boolean)false, (int)2, null) ? Series.PIXEL : (StringsKt.startsWith$default((String)name, (String)"Nexus", (boolean)false, (int)2, null) ? Series.NEXUS : Series.OTHER);
    }

    @Override
    public int compare(@Nullable Device o1, @Nullable Device o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        Device device2 = o1;
        Intrinsics.checkNotNull((Object)device2);
        String name1 = device2.getDisplayName();
        Device device3 = o2;
        Intrinsics.checkNotNull((Object)device3);
        String name2 = device3.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)name1, (String)"name1");
        Series series1 = this.getSeries(name1);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name2");
        Series series2 = this.getSeries(name2);
        return series1 == Series.NEXUS && series2 == Series.NEXUS ? this.compareGeneration(StringsKt.substringAfter$default((String)name1, (String)"Nexus", null, (int)2, null), StringsKt.substringAfter$default((String)name2, (String)"Nexus", null, (int)2, null)) : (series1 == Series.PIXEL && series2 == Series.PIXEL ? this.compareGeneration(StringsKt.substringAfter$default((String)name1, (String)"Pixel", null, (int)2, null), StringsKt.substringAfter$default((String)name2, (String)"Pixel", null, (int)2, null)) : (series1 == Series.NEXUS && series2 == Series.PIXEL ? -1 : (series1 == Series.PIXEL && series2 == Series.NEXUS ? 1 : (series1 == Series.OTHER && series2 != Series.OTHER ? -1 : (series1 != Series.OTHER && series2 == Series.OTHER ? 1 : 0)))));
    }

    private final int compareGeneration(String name1, String name2) {
        Pair<Integer, String> pair = this.getGenerationAndSuffixPair(name1);
        int gen1 = ((Number)pair.component1()).intValue();
        String suffix1 = (String)pair.component2();
        Pair<Integer, String> pair2 = this.getGenerationAndSuffixPair(name2);
        int gen2 = ((Number)pair2.component1()).intValue();
        String suffix2 = (String)pair2.component2();
        return gen1 == gen2 ? this.varianceComparator.compare(suffix1, suffix2) : gen1 - gen2;
    }

    private final Pair<Integer, String> getGenerationAndSuffixPair(String str) {
        Pair pair;
        IntRange range;
        MatchResult matchResult = Regex.find$default((Regex)DeviceMenuAction2Kt.access$getGENERATION_REGEX$p(), (CharSequence)str, (int)0, (int)2, null);
        Object object = range = matchResult != null ? matchResult.getRange() : null;
        if (range == null) {
            pair = TuplesKt.to((Object)0, (Object)str);
        } else {
            Integer n = Integer.parseInt(StringsKt.substring((String)str, (IntRange)range));
            String string = str.substring(range.getLast() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            pair = TuplesKt.to((Object)n, (Object)((Object)StringsKt.trimStart((CharSequence)string)).toString());
        }
        return pair;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/configurations/PixelDeviceComparator$Series;", "", "(Ljava/lang/String;I)V", "PIXEL", "NEXUS", "OTHER", "intellij.android.core"})
    private static final class Series
    extends Enum<Series> {
        public static final /* enum */ Series PIXEL = new Series();
        public static final /* enum */ Series NEXUS = new Series();
        public static final /* enum */ Series OTHER = new Series();
        private static final /* synthetic */ Series[] $VALUES;

        public static Series[] values() {
            return (Series[])$VALUES.clone();
        }

        public static Series valueOf(String value2) {
            return Enum.valueOf(Series.class, value2);
        }

        static {
            $VALUES = seriesArray = new Series[]{Series.PIXEL, Series.NEXUS, Series.OTHER};
        }
    }
}

