/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ScreenOrientation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OrientationMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;

    public OrientationMenuAction(@NotNull ConfigurationHolder renderContext) {
        super("Orientation for Preview", "Orientation for Preview", StudioIcons.LayoutEditor.Toolbar.ROTATE_BUTTON);
        this.myRenderContext = renderContext;
    }

    protected boolean updateActions(@NotNull DataContext context2) {
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            String title;
            Device device2 = configuration.getCachedDevice();
            if (device2 != null) {
                boolean showSetOrientationOptions;
                State currentDeviceState = configuration.getDeviceState();
                boolean bl = ((Boolean)StudioFlags.NELE_WEAR_DEVICE_FIXED_ORIENTATION.get()).booleanValue() ? !HardwareConfigHelper.isWear((Device)device2) : (showSetOrientationOptions = true);
                if (showSetOrientationOptions) {
                    List states = device2.getAllStates();
                    for (State state2 : states) {
                        String stateName;
                        title = stateName = state2.getName();
                        VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, stateName, null, null);
                        if (better != null) {
                            title = ConfigurationAction.getBetterMatchLabel(stateName, better, configuration.getFile());
                        }
                        SetDeviceStateAction action2 = new SetDeviceStateAction(this.myRenderContext, title, state2, state2 == currentDeviceState);
                        this.add(action2);
                    }
                }
            }
            this.addSeparator();
            DefaultActionGroup uiModeGroup = OrientationMenuAction.createSubMenuGroup(() -> "_UI Mode");
            UiMode currentUiMode = configuration.getUiMode();
            for (UiMode uiMode : UiMode.values()) {
                title = uiMode.getShortDisplayValue();
                boolean checked = uiMode == currentUiMode;
                uiModeGroup.add((AnAction)new SetUiModeAction(this.myRenderContext, title, uiMode, checked));
            }
            this.add((AnAction)uiModeGroup);
        }
        return true;
    }

    @NotNull
    public static ScreenOrientation getOrientation(@NotNull State state2) {
        FolderConfiguration config2 = DeviceConfigHelper.getFolderConfig((State)state2);
        ScreenOrientation orientation = null;
        if (config2 != null && config2.getScreenOrientationQualifier() != null) {
            orientation = config2.getScreenOrientationQualifier().getValue();
        }
        if (orientation == null) {
            orientation = ScreenOrientation.PORTRAIT;
        }
        return orientation;
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        @NotNull
        private final UiMode myUiMode;

        private SetUiModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull UiMode uiMode, boolean checked) {
            super(renderContext, title);
            this.myUiMode = uiMode;
            Toggleable.setSelected((Presentation)this.getTemplatePresentation(), (boolean)checked);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setUiMode(this.myUiMode);
        }
    }

    @VisibleForTesting
    static class SetDeviceStateAction
    extends ConfigurationAction {
        @NotNull
        private final State myState;

        private SetDeviceStateAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull State state2, boolean isCurrentState) {
            super(renderContext, title);
            this.myState = state2;
            Toggleable.setSelected((Presentation)this.getTemplatePresentation(), (boolean)isCurrentState);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setDeviceState(this.myState);
            if (!HardwareConfigHelper.isWear((Device)configuration.getDevice())) {
                ConfigurationProjectState projectState = configuration.getConfigurationManager().getStateManager().getProjectState();
                projectState.setNonWearDeviceLastSelectedStateName(this.myState.getName(), this.myState.isDefaultState());
            }
        }
    }
}

