/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.Locale;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.google.common.base.MoreObjects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedConfiguration
extends Configuration
implements ConfigurationListener {
    protected Configuration myParent;
    private int myOverride;

    protected NestedConfiguration(@NotNull Configuration configuration) {
        super(configuration.getConfigurationManager(), configuration.getFile(), configuration.getEditedConfig());
        this.myParent = configuration;
        this.myFullConfig.set(this.myParent.myFullConfig);
        this.myParent.addListener(this);
    }

    public int getOverrideFlags() {
        return this.myOverride;
    }

    @NotNull
    public static NestedConfiguration create(@NotNull NestedConfiguration other, @NotNull Configuration values, @NotNull Configuration parent2) {
        NestedConfiguration configuration = new NestedConfiguration(parent2);
        NestedConfiguration.initFrom(configuration, other, values);
        return configuration;
    }

    protected static void initFrom(NestedConfiguration configuration, NestedConfiguration other, Configuration values) {
        State deviceState;
        Device device2;
        IAndroidTarget target2;
        configuration.startBulkEditing();
        configuration.myOverride = other.myOverride;
        configuration.setDisplayName(values.getDisplayName());
        String activity = values.getActivity();
        if (activity != null) {
            configuration.setActivity(activity);
        }
        if (configuration.isOverridingLocale()) {
            configuration.setLocale(values.getLocale());
        }
        if (configuration.isOverridingTarget() && (target2 = values.getTarget()) != null) {
            configuration.setTarget(target2);
        }
        if (configuration.isOverridingDevice() && (device2 = values.getDevice()) != null) {
            configuration.setDevice(device2, true);
        }
        if (configuration.isOverridingDeviceState() && (deviceState = values.getDeviceState()) != null) {
            configuration.setDeviceState(deviceState);
        }
        if (configuration.isOverridingNightMode()) {
            configuration.setNightMode(values.getNightMode());
        }
        if (configuration.isOverridingUiMode()) {
            configuration.setUiMode(values.getUiMode());
        }
        configuration.finishBulkEditing();
    }

    public void setParent(@NotNull Configuration parent2) {
        this.myParent = parent2;
    }

    @NotNull
    public static NestedConfiguration create(@NotNull Configuration parent2) {
        return new NestedConfiguration(parent2);
    }

    @Override
    @NotNull
    public String getTheme() {
        if (this.isOverridingTarget()) {
            return super.getTheme();
        }
        return this.myParent.getTheme();
    }

    @Override
    public void setTheme(@Nullable String theme) {
        if (this.isOverridingTarget()) {
            super.setTheme(theme);
        } else {
            this.myParent.setTheme(theme);
        }
    }

    public void setOverrideLocale(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x10) : (this.myOverride &= 0xFFFFFFEF);
    }

    public final boolean isOverridingLocale() {
        return (this.myOverride & 0x10) != 0;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            return super.getLocale();
        }
        return this.myParent.getLocale();
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        if (this.isOverridingLocale()) {
            super.setLocale(locale);
        } else {
            this.myParent.setLocale(locale);
        }
    }

    public void setOverrideTarget(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x20) : (this.myOverride &= 0xFFFFFFDF);
    }

    public final boolean isOverridingTarget() {
        return (this.myOverride & 0x20) != 0;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        return this.myParent.getTarget();
    }

    @Override
    public void setTarget(IAndroidTarget target2) {
        if (this.isOverridingTarget()) {
            super.setTarget(target2);
        } else {
            this.myParent.setTarget(target2);
        }
    }

    public void setOverrideDevice(boolean override) {
        this.myOverride = override ? (this.myOverride |= 2) : (this.myOverride &= 0xFFFFFFFD);
    }

    public final boolean isOverridingDevice() {
        return (this.myOverride & 2) != 0;
    }

    @Override
    @Nullable
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        return this.myParent.getDevice();
    }

    @Override
    public void setDevice(Device device2, boolean preserveState) {
        if (this.isOverridingDevice()) {
            super.setDevice(device2, preserveState);
        } else {
            this.myParent.setDevice(device2, preserveState);
        }
    }

    public void setOverrideDeviceState(boolean override) {
        this.myOverride = override ? (this.myOverride |= 4) : (this.myOverride &= 0xFFFFFFFB);
    }

    public final boolean isOverridingDeviceState() {
        return (this.myOverride & 4) != 0;
    }

    @Override
    @Nullable
    public State getDeviceState() {
        Device device2;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state2 = this.myParent.getDeviceState();
        if (this.isOverridingDevice() && state2 != null && (device2 = super.getDevice()) != null) {
            String name = state2.getName();
            if ((state2 = device2.getState(name)) != null) {
                return state2;
            }
            int nameLen = name.length();
            for (State s : device2.getAllStates()) {
                String n = s.getName();
                if (!n.regionMatches(0, name, 0, Math.min(nameLen, n.length()))) continue;
                return s;
            }
            return device2.getDefaultState();
        }
        return state2;
    }

    @Override
    public void setDeviceState(State state2) {
        if (this.isOverridingDeviceState()) {
            super.setDeviceState(state2);
        } else {
            State equivalentState;
            Device device2;
            if (this.isOverridingDevice() && (device2 = super.getDevice()) != null && (equivalentState = device2.getState(state2.getName())) != null) {
                state2 = equivalentState;
            }
            this.myParent.setDeviceState(state2);
        }
    }

    public void setOverrideNightMode(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x40) : (this.myOverride &= 0xFFFFFFBF);
    }

    public final boolean isOverridingNightMode() {
        return (this.myOverride & 0x40) != 0;
    }

    @Override
    @NotNull
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            return super.getNightMode();
        }
        return this.myParent.getNightMode();
    }

    @Override
    public void setNightMode(@NotNull NightMode night) {
        if (this.isOverridingNightMode()) {
            super.setNightMode(night);
        } else {
            this.myParent.setNightMode(night);
        }
    }

    public void setOverrideUiMode(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x80) : (this.myOverride &= 0xFFFFFF7F);
    }

    public final boolean isOverridingUiMode() {
        return (this.myOverride & 0x80) != 0;
    }

    @Override
    @NotNull
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            return super.getUiMode();
        }
        return this.myParent.getUiMode();
    }

    @Override
    public void setUiMode(@NotNull UiMode uiMode) {
        if (this.isOverridingUiMode()) {
            super.setUiMode(uiMode);
        } else {
            this.myParent.setUiMode(uiMode);
        }
    }

    @NotNull
    public Configuration getParent() {
        return this.myParent;
    }

    @Override
    @Nullable
    public String getActivity() {
        return this.myParent.getActivity();
    }

    @Override
    public void setActivity(String activity) {
        super.setActivity(activity);
    }

    @Nullable
    public String computeDisplayName() {
        return NestedConfiguration.computeDisplayName(this.myOverride, this);
    }

    @Nullable
    public static String computeDisplayName(int flags, @NotNull Configuration configuration) {
        State deviceState;
        if ((flags & 0x10) != 0) {
            return Locale.getLocaleLabel((Locale)configuration.getLocale(), (boolean)false);
        }
        if ((flags & 0x20) != 0) {
            return TargetMenuAction.getRenderingTargetLabel(configuration.getTarget(), false);
        }
        if ((flags & 2) != 0) {
            return DeviceMenuAction.getDeviceLabel(configuration.getDevice(), true);
        }
        if ((flags & 4) != 0 && (deviceState = configuration.getDeviceState()) != null) {
            return deviceState.getName();
        }
        if ((flags & 0x40) != 0) {
            return configuration.getNightMode().getLongDisplayValue();
        }
        if ((flags & 0x80) != 0) {
            return configuration.getUiMode().getLongDisplayValue();
        }
        return null;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("parent", (Object)this.myParent.getDisplayName()).add("display", (Object)this.getDisplayName()).add("overrideLocale", this.isOverridingLocale()).add("overrideTarget", this.isOverridingTarget()).add("overrideDevice", this.isOverridingDevice()).add("overrideDeviceState", this.isOverridingDeviceState()).add("inherited", (Object)super.toString()).toString();
    }

    @Override
    public void dispose() {
        this.myParent.removeListener(this);
    }

    @Override
    public boolean changed(int flags) {
        if ((flags &= ~this.myOverride) != 0) {
            this.updated(flags);
        }
        return true;
    }
}

