/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.DeviceGroup;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesFeature;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AvdManagerUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0002\u001a \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\u0010\u001a\u00020\u0002\u001a&\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u001a\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\bH\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0014\u0010\u001f\u001a\u00020\u001c*\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0014\u0010\u001f\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\"\u00b3\u0001\u0010\u0000\u001a\u00a6\u0001\u0012\u0016\u0012\u0014 \u0004*\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\u00030\u0002\u00a2\u0006\u0002\b\u0003\u00120\u0012.\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007 \u0004*\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u00050\u0005 \u0004*Q\u0012\u0016\u0012\u0014 \u0004*\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\u00030\u0002\u00a2\u0006\u0002\b\u0003\u00120\u0012.\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007 \u0004*\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u00050\u00050\u0005\u00a2\u0006\u0002\b\u00030\u0001\u00a2\u0006\u0002\b\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"DEVICE_CACHES", "", "Lcom/android/tools/idea/configurations/Configuration;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "", "Lcom/android/tools/idea/configurations/DeviceGroup;", "", "Lcom/android/sdklib/devices/Device;", "DEVICE_CLASS_DESKTOP_TOOLTIP", "", "DEVICE_CLASS_FOLDABLE_TOOLTIP", "DEVICE_CLASS_PHONE_TOOLTIP", "DEVICE_CLASS_TABLET_TOOLTIP", "WEAR_OS_USE_FEATURE_TAG", "getAvdDevices", "configuration", "getSuitableDevices", "groupDevices", "devices", "isUseWearDeviceAsDefault", "", "module", "Lcom/intellij/openapi/module/Module;", "sizeGroupNexus", "device", "toDp", "", "", "density", "Lcom/android/resources/Density;", "toPx", "intellij.android.core"})
@JvmName(name="DeviceUtils")
public final class DeviceUtils {
    @NotNull
    private static final Map<Configuration, Map<DeviceGroup, List<Device>>> DEVICE_CACHES;
    @NotNull
    private static final String WEAR_OS_USE_FEATURE_TAG = "android.hardware.type.watch";
    @NotNull
    public static final String DEVICE_CLASS_PHONE_TOOLTIP = "This reference device uses the COMPACT width size class, which represents 99% of Android phones in portrait orientation.";
    @NotNull
    public static final String DEVICE_CLASS_FOLDABLE_TOOLTIP = "This reference device uses the MEDIUM width size class, which represents foldables in unfolded portrait orientation, or 94% of all tablets in portrait orientation.";
    @NotNull
    public static final String DEVICE_CLASS_TABLET_TOOLTIP = "This reference device uses the EXPANDED width size class, which represents 97% of Android tablets in landscape orientation.";
    @NotNull
    public static final String DEVICE_CLASS_DESKTOP_TOOLTIP = "This reference device uses the EXPANDED width size class, which represents 97% of Android desktops in landscape orientation.";

    @NotNull
    public static final Map<DeviceGroup, List<Device>> getSuitableDevices(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Map<Configuration, Map<DeviceGroup, List<Device>>> $this$getOrPut$iv = DEVICE_CACHES;
        boolean $i$f$getOrPut = false;
        Map<DeviceGroup, List<Device>> value$iv = $this$getOrPut$iv.get(configuration);
        if (value$iv == null) {
            boolean bl = false;
            ImmutableList<Device> immutableList = configuration.getConfigurationManager().getDevices();
            Intrinsics.checkNotNullExpressionValue(immutableList, (String)"configuration.configurationManager.devices");
            return DeviceUtils.groupDevices((List)immutableList);
        }
        return value$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<DeviceGroup, List<Device>> groupDevices(@NotNull List<Device> devices2) {
        void $this$groupByTo$iv$iv;
        Device it;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Iterable $this$filterNot$iv = devices2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Device)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)"Custom", (Object)it.getId()) || ConfigurationManager.isAvdDevice(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupDevices_u24lambda_u2d2 = $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$a$-apply-DeviceUtils$groupDevices$32 = false;
        HardwareConfigHelper.sortDevicesByScreenSize((List)$this$groupDevices_u24lambda_u2d2);
        Iterable $this$groupBy$iv = $this$filterNot$iv;
        boolean $i$f$groupBy = false;
        Iterable $i$a$-apply-DeviceUtils$groupDevices$32 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Device)element$iv$iv;
            boolean bl = false;
            DeviceGroup key$iv$iv = HardwareConfigHelper.isAutomotive((Device)it) ? DeviceGroup.AUTOMOTIVE : (HardwareConfigHelper.isWear((Device)it) ? DeviceGroup.WEAR : (HardwareConfigHelper.isDesktop((Device)it) ? DeviceGroup.DESKTOP : (HardwareConfigHelper.isTv((Device)it) ? DeviceGroup.TV : (HardwareConfigHelper.isNexus((Device)it) && !Intrinsics.areEqual((Object)it.getManufacturer(), (Object)"Generic") ? DeviceUtils.sizeGroupNexus(it) : (HardwareConfigHelper.isMobile((Device)it) && Intrinsics.areEqual((Object)it.getManufacturer(), (Object)"Generic") ? DeviceGroup.GENERIC : DeviceGroup.OTHER)))));
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return MapsKt.toSortedMap((Map)destination$iv$iv);
    }

    private static final DeviceGroup sizeGroupNexus(Device device2) {
        double diagonalLength = device2.getDefaultHardware().getScreen().getDiagonalLength();
        return diagonalLength < 5.0 ? DeviceGroup.NEXUS : (diagonalLength < 7.0 ? DeviceGroup.NEXUS_XL : DeviceGroup.NEXUS_TABLET);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Device> getAvdDevices(@NotNull Configuration configuration) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)configuration.getModule());
        if (androidFacet == null) {
            return CollectionsKt.emptyList();
        }
        AndroidFacet facet2 = androidFacet;
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        Intrinsics.checkNotNullExpressionValue((Object)configurationManager, (String)"configuration.configurationManager");
        ConfigurationManager configurationManager2 = configurationManager;
        AvdManager avdManager2 = AvdManagerUtils.getAvdManager(facet2);
        if (avdManager2 == null) {
            return CollectionsKt.emptyList();
        }
        AvdManager avdManager3 = avdManager2;
        ImmutableList immutableList = avdManager3.getValidAvds();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"avdManager.validAvds");
        Iterable $this$mapNotNull$iv = (Iterable)immutableList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Device it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AvdInfo it = (AvdInfo)element$iv$iv;
            boolean bl2 = false;
            if (configurationManager2.createDeviceForAvd(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Slow
    public static final boolean isUseWearDeviceAsDefault(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null || facet2.isDisposed()) {
            return false;
        }
        Manifest manifest = Manifest.getMainManifest(facet2);
        if (manifest == null) {
            return false;
        }
        Manifest manifest2 = manifest;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable(manifest2){
            final /* synthetic */ Manifest $manifest;
            {
                this.$manifest = $manifest;
            }

            public final Boolean compute() {
                boolean bl;
                block3: {
                    List<UsesFeature> list2 = this.$manifest.getUsesFeatures();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"manifest.usesFeatures");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            UsesFeature usesFeature2 = (UsesFeature)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)usesFeature2.getName().getValue(), (Object)"android.hardware.type.watch")) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"val manifest = Manifest.\u2026OS_USE_FEATURE_TAG }\n  })");
        return (Boolean)object;
    }

    public static final int toPx(double $this$toPx, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return MathKt.roundToInt((double)($this$toPx * ((double)density.getDpiValue() / 160.0)));
    }

    public static final int toPx(int $this$toPx, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return DeviceUtils.toPx((double)$this$toPx, density);
    }

    public static final double toDp(int $this$toDp, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return (double)$this$toDp * (double)160 / (double)density.getDpiValue();
    }

    static {
        Map map2 = ContainerUtil.createSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSoftMap<Configurat\u2026ceGroup, List<Device>>>()");
        DEVICE_CACHES = map2;
    }
}

