/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConfigurationAction
extends AnAction
implements ConfigurationListener,
Toggleable {
    private static final String FILE_ARROW = " \u2192 ";
    protected final ConfigurationHolder myRenderContext;
    private int myFlags;

    public ConfigurationAction(@NotNull ConfigurationHolder renderContext) {
        this(renderContext, null, null);
    }

    public ConfigurationAction(@NotNull ConfigurationHolder renderContext, @Nullable String title) {
        this(renderContext, title, null);
    }

    public ConfigurationAction(@NotNull ConfigurationHolder renderContext, @Nullable String title, @Nullable Icon icon2) {
        super(title, null, icon2);
        this.myRenderContext = renderContext;
    }

    protected void updatePresentation(@NotNull Presentation presentation) {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ActionUtil.performDumbAwareWithCallbacks((AnAction)this, (AnActionEvent)e, () -> {
            this.tryUpdateConfiguration();
            this.updatePresentation(e.getPresentation());
        });
    }

    protected void tryUpdateConfiguration() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            ConfigurationMatcher matcher;
            List<VirtualFile> matchingFiles;
            VirtualFile file2;
            Module module2;
            boolean affectsFileSelection;
            Configuration clone = configuration.clone();
            this.myFlags = 0;
            clone.addListener(this);
            this.updateConfiguration(clone, false);
            clone.removeListener(this);
            boolean bl = affectsFileSelection = (this.myFlags & 0xF6) != 0;
            if (affectsFileSelection && (module2 = this.myRenderContext.getConfiguration().getModule()) != null && (file2 = this.myRenderContext.getConfiguration().getFile()) != null && !(matchingFiles = (matcher = new ConfigurationMatcher(clone, file2)).getBestFileMatches()).isEmpty() && !matchingFiles.contains(file2)) {
                this.pickedBetterMatch(matchingFiles.get(0), file2);
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                assert (facet2 != null);
                ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(module2);
                this.updateConfiguration(configurationManager.getConfiguration(matchingFiles.get(0)), true);
                return;
            }
            this.updateConfiguration(configuration, true);
        }
    }

    protected void pickedBetterMatch(@NotNull VirtualFile file2, @NotNull VirtualFile old2) {
        Module module2 = this.myRenderContext.getConfiguration().getModule();
        assert (module2 != null);
        Project project = module2.getProject();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, -1);
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)project);
        FileEditorWithProvider previousSelection = manager.getSelectedEditorWithProvider(old2);
        manager.openEditor(descriptor2, true);
        if (previousSelection != null) {
            manager.setSelectedEditor(file2, previousSelection.getProvider().getEditorTypeId());
        }
    }

    @Override
    public boolean changed(int flags) {
        this.myFlags |= flags;
        return true;
    }

    protected abstract void updateConfiguration(@NotNull Configuration var1, boolean var2);

    public static boolean isBetterMatchLabel(@NotNull String label) {
        return label.contains(FILE_ARROW);
    }

    public static String getBetterMatchLabel(@NotNull String prefix, @NotNull VirtualFile better, @Nullable VirtualFile file2) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(FILE_ARROW);
        String folderName = better.getParent().getName();
        if (folderName.equals("layout")) {
            if (file2 != null && !Objects.equals(file2.getParent(), better.getParent())) {
                sb.append("layout");
                sb.append(File.separatorChar);
            }
        } else {
            if (folderName.startsWith("layout")) {
                folderName = folderName.substring("layout".length() + 1);
            }
            sb.append(folderName);
            sb.append(File.separatorChar);
        }
        sb.append(better.getName());
        return sb.toString();
    }

    public static Icon getBetterMatchIcon() {
        return AllIcons.Actions.CloseDarkGrey;
    }
}

