/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.NavSource;
import com.android.tools.idea.codenavigation.TraceSignatureConverter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/codenavigation/PsiNavSource;", "Lcom/android/tools/idea/codenavigation/NavSource;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "findClass", "Lcom/intellij/psi/PsiClass;", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "findMethod", "Lcom/intellij/psi/PsiMethod;", "psiClass", "lookUp", "Lcom/intellij/pom/Navigatable;", "arch", "", "codenavigation"})
public final class PsiNavSource
implements NavSource {
    @NotNull
    private final Project project;

    public PsiNavSource(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @Nullable
    public Navigatable lookUp(@NotNull CodeLocation location2, @Nullable String arch) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        PsiClass psiClass = this.findClass(location2);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        if (location2.getLineNumber() >= 0) {
            return (Navigatable)new OpenFileDescriptor(this.project, psiClass2.getNavigationElement().getContainingFile().getVirtualFile(), location2.getLineNumber(), 0);
        }
        PsiMethod psiMethod = this.findMethod(psiClass2, location2);
        return psiMethod != null ? (Navigatable)psiMethod : (Navigatable)psiClass2;
    }

    private final PsiClass findClass(CodeLocation location2) {
        CharSequence charSequence = location2.getClassName();
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        if (location2.getClassName() == null) {
            return null;
        }
        String string = location2.getClassName();
        Intrinsics.checkNotNull((Object)string);
        String className = string;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
        PsiManager manager = psiManager;
        PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)manager, (String)className);
        if (psiClass == null && location2.getLineNumber() >= 0) {
            psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)manager, (String)location2.getOuterClass());
        }
        return psiClass;
    }

    private final PsiMethod findMethod(PsiClass psiClass, CodeLocation location2) {
        Object object;
        block2: {
            if (location2.getMethodName() == null || location2.getSignature() == null) {
                return null;
            }
            PsiMethod[] psiMethodArray = psiClass.findMethodsByName(location2.getMethodName(), true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"psiClass.findMethodsByNa\u2026ocation.methodName, true)");
            Object[] $this$firstOrNull$iv = psiMethodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                PsiType psiType = it.getReturnType();
                PsiType[] psiTypeArray = it.getSignature(PsiSubstitutor.EMPTY).getParameterTypes();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"it.getSignature(PsiSubst\u2026tor.EMPTY).parameterTypes");
                String signature = TraceSignatureConverter.INSTANCE.getTraceSignature(psiType, psiTypeArray);
                if (!Intrinsics.areEqual((Object)location2.getSignature(), (Object)signature)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        return (PsiMethod)object;
    }
}

