/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.LibraryMapping;
import com.android.tools.idea.codenavigation.NavSource;
import com.google.common.base.Strings;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkNavSource
implements NavSource {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<LibraryMapping> myLibraryMappings;

    public ApkNavSource(@NotNull Project project) {
        this.myProject = project;
        this.myLibraryMappings = ApkNavSource.getLibraryMappings(project);
    }

    @Override
    @Nullable
    public Navigatable lookUp(@NotNull CodeLocation location2, @Nullable String arch) {
        if (!Strings.isNullOrEmpty((String)location2.getFileName()) && location2.getLineNumber() != -1) {
            Navigatable navigatable = this.getExplicitLocationNavigable(location2);
            if (navigatable != null) {
                return navigatable;
            }
            navigatable = this.getApkMappingNavigable(location2);
            if (navigatable != null) {
                return navigatable;
            }
        }
        return null;
    }

    @Nullable
    private Navigatable getExplicitLocationNavigable(@NotNull CodeLocation location2) {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile sourceFile = fileSystem.findFileByPath(location2.getFileName());
        if (sourceFile == null || !sourceFile.exists()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, sourceFile, location2.getLineNumber(), 0);
    }

    @Nullable
    private Navigatable getApkMappingNavigable(@NotNull CodeLocation location2) {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (LibraryMapping mapping : this.myLibraryMappings) {
            if (!location2.getFileName().startsWith(mapping.getOriginalPath())) continue;
            String pathTailAfterPrefix = location2.getFileName().substring(mapping.getOriginalPath().length());
            String newFileName2 = Paths.get(mapping.getLocalPath(), pathTailAfterPrefix).toString();
            VirtualFile sourceFile = fileSystem.findFileByPath(newFileName2);
            if (sourceFile == null || !sourceFile.exists()) continue;
            return new OpenFileDescriptor(this.myProject, sourceFile, location2.getLineNumber(), 0);
        }
        return null;
    }

    @NotNull
    private static List<LibraryMapping> getLibraryMappings(@NotNull Project project) {
        ArrayList<LibraryMapping> sourceMap = new ArrayList<LibraryMapping>();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            ApkFacet apkFacet = ApkFacet.getInstance(module2);
            if (apkFacet == null) continue;
            for (Map.Entry<String, String> entry : ((ApkFacetConfiguration)apkFacet.getConfiguration()).getSymbolFolderPathMappings().entrySet()) {
                if (entry.getValue().isEmpty() || entry.getKey().equals(entry.getValue())) continue;
                sourceMap.add(new LibraryMapping(entry.getKey(), entry.getValue()));
            }
        }
        return sourceMap;
    }
}

