/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.emulatorcommand;

import com.android.sdklib.internal.avd.AvdInfo;
import com.intellij.execution.configurations.GeneralCommandLine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorCommandBuilder {
    @NotNull
    private final Path myEmulator;
    @NotNull
    final AvdInfo myAvd;
    @Nullable
    private Path myAvdHome;
    private boolean myEmulatorSupportsSnapshots;
    @Nullable
    private Path myStudioParams;
    private boolean myLaunchInToolWindow;
    @NotNull
    private final @NotNull List<@NotNull String> myStudioEmuParams;

    public EmulatorCommandBuilder(@NotNull Path emulator, @NotNull AvdInfo avd) {
        this.myEmulator = emulator;
        this.myAvd = avd;
        this.myStudioEmuParams = new ArrayList<String>();
    }

    @NotNull
    public final EmulatorCommandBuilder setAvdHome(@Nullable Path avdHome) {
        this.myAvdHome = avdHome;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder setEmulatorSupportsSnapshots(boolean emulatorSupportsSnapshots) {
        this.myEmulatorSupportsSnapshots = emulatorSupportsSnapshots;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder setStudioParams(@Nullable Path studioParams) {
        this.myStudioParams = studioParams;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder setLaunchInToolWindow(boolean launchInToolWindow) {
        this.myLaunchInToolWindow = launchInToolWindow;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder addAllStudioEmuParams(@NotNull @NotNull Collection<@NotNull String> studioEmuParams) {
        this.myStudioEmuParams.addAll(studioEmuParams);
        return this;
    }

    @NotNull
    public final GeneralCommandLine build() {
        GeneralCommandLine command2 = new GeneralCommandLine();
        command2.setExePath(this.myEmulator.toString());
        if (this.myAvdHome != null) {
            command2.getEnvironment().put("ANDROID_AVD_HOME", this.myAvdHome.toString());
        }
        EmulatorCommandBuilder.addParametersIfParameter2IsntNull(command2, "-netdelay", this.myAvd.getProperty("runtime.network.latency"));
        EmulatorCommandBuilder.addParametersIfParameter2IsntNull(command2, "-netspeed", this.myAvd.getProperty("runtime.network.speed"));
        if (this.myEmulatorSupportsSnapshots) {
            this.addSnapshotParameters(command2);
        }
        EmulatorCommandBuilder.addParametersIfParameter2IsntNull(command2, "-studio-params", this.myStudioParams);
        command2.addParameters(new String[]{"-avd", this.myAvd.getName()});
        if (this.myLaunchInToolWindow) {
            command2.addParameter("-qt-hide-window");
            command2.addParameter("-grpc-use-token");
            command2.addParameters(new String[]{"-idle-grpc-timeout", "300"});
        }
        command2.addParameters(this.myStudioEmuParams);
        return command2;
    }

    private static void addParametersIfParameter2IsntNull(@NotNull GeneralCommandLine command2, @NotNull String parameter1, @Nullable Object parameter2) {
        if (parameter2 == null) {
            return;
        }
        command2.addParameters(new String[]{parameter1, parameter2.toString()});
    }

    void addSnapshotParameters(@NotNull GeneralCommandLine command2) {
    }
}

