/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.sdklib.repository.targets.SystemImageManager;
import com.android.tools.idea.avdmanager.ApiLevelComparator;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImageListModel
extends ListTableModel<SystemImageDescription> {
    private final Project myProject;
    private final StatusIndicator myIndicator;
    private final AndroidSdkHandler mySdkHandler;
    private boolean myUpdating;
    private int myCompletedCalls;
    private final Object myLock = new Object();
    private static final ProgressIndicator LOGGER = new StudioLoggerProgressIndicator(SystemImageListModel.class);
    private final ColumnInfo[] ourColumnInfos = new ColumnInfo[]{new SystemImageColumnInfo("Release Name"){

        @NotNull
        public String valueOf(SystemImageDescription systemImage) {
            return SystemImageListModel.releaseDisplayName(systemImage);
        }

        @Override
        @NotNull
        public Comparator<SystemImageDescription> getComparator() {
            return Comparator.comparing(SystemImageDescription::getVersion);
        }
    }, new SystemImageColumnInfo("API Level", JBUI.scale((int)100)){

        @NotNull
        public String valueOf(SystemImageDescription systemImage) {
            return systemImage.getVersion().getApiString();
        }
    }, new SystemImageColumnInfo("ABI", JBUI.scale((int)100)){

        @NotNull
        public String valueOf(SystemImageDescription systemImage) {
            return systemImage.getAbiType();
        }
    }, new SystemImageColumnInfo("Target"){

        @NotNull
        public String valueOf(SystemImageDescription systemImage) {
            IdDisplay tag = systemImage.getTag();
            String name = systemImage.getName();
            return String.format("%1$s%2$s", name, tag.equals((Object)SystemImage.DEFAULT_TAG) ? "" : String.format(" (%s)", tag.getDisplay()));
        }
    }};

    public SystemImageListModel(@Nullable Project project, @NotNull StatusIndicator indicator) {
        super(new ColumnInfo[0]);
        this.myProject = project;
        this.myIndicator = indicator;
        this.mySdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        this.setColumnInfos(this.ourColumnInfos);
        this.setSortable(true);
    }

    public void refreshLocalImagesSynchronously() {
        try {
            this.myIndicator.onRefreshStart("Get local images...");
            this.setItems(this.getLocalImages());
        }
        finally {
            this.myIndicator.onRefreshDone("", true);
        }
    }

    public void setItems(@NotNull List<SystemImageDescription> items2) {
        this.myUpdating = true;
        super.setItems(items2);
        this.myUpdating = false;
    }

    public boolean isUpdating() {
        return this.myUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshImages(boolean forceRefresh) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCompletedCalls = 0;
        }
        this.myIndicator.onRefreshStart("Refreshing...");
        ArrayList items2 = new ArrayList();
        RepoManager.RepoLoadedListener localComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            items2.addAll(this.getLocalImages());
            this.setItems(items2);
            this.completedDownload("");
        }, ModalityState.any());
        RepoManager.RepoLoadedListener remoteComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            List<SystemImageDescription> remotes = SystemImageListModel.getRemoteImages(packages);
            if (remotes != null) {
                items2.addAll(remotes);
                this.setItems(items2);
            }
            this.completedDownload("");
        }, ModalityState.any());
        Runnable error = () -> ApplicationManager.getApplication().invokeLater(() -> this.completedDownload("Error loading remote images"), ModalityState.any());
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Loading Images", this.myProject);
        this.mySdkHandler.getSdkManager(LOGGER).load(forceRefresh ? 0L : RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)localComplete), (List)ImmutableList.of((Object)remoteComplete), (List)ImmutableList.of((Object)error), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completedDownload(@NotNull String message2) {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCompletedCalls;
            this.myIndicator.onRefreshDone(message2, this.myCompletedCalls < 2);
            if (this.myCompletedCalls < 2) {
                this.myIndicator.onRefreshStart("Refreshing...");
            }
        }
    }

    private List<SystemImageDescription> getLocalImages() {
        SystemImageManager systemImageManager = this.mySdkHandler.getSystemImageManager(LOGGER);
        ArrayList<SystemImageDescription> items2 = new ArrayList<SystemImageDescription>();
        for (ISystemImage image : systemImageManager.getImages()) {
            SystemImageDescription desc = new SystemImageDescription(image);
            items2.add(desc);
        }
        return items2;
    }

    @Nullable
    private static List<SystemImageDescription> getRemoteImages(@NotNull RepositoryPackages packages) {
        ArrayList<SystemImageDescription> items2 = new ArrayList<SystemImageDescription>();
        Set infos = packages.getNewPkgs();
        if (infos.isEmpty()) {
            return null;
        }
        for (RemotePackage info2 : infos) {
            if (!SystemImageDescription.hasSystemImage((RepoPackage)info2)) continue;
            SystemImageDescription image = new SystemImageDescription(info2);
            items2.add(image);
        }
        return items2;
    }

    @VisibleForTesting
    @NotNull
    static String releaseDisplayName(@NotNull SystemImageDescription systemImage) {
        Object codeName;
        AndroidVersion version2 = systemImage.getVersion();
        Object object = codeName = version2.isPreview() ? version2.getCodename() : SdkVersionInfo.getCodeName((int)version2.getApiLevel());
        if (codeName == null) {
            codeName = "API " + version2.getApiLevel();
        }
        String maybeDeprecated = systemImage.obsolete() || version2.getApiLevel() < 16 ? " (Deprecated)" : "";
        String extensionDetails = !version2.isBaseExtension() && version2.getExtensionLevel() != null ? " (Extension Level " + version2.getExtensionLevel() + ")" : "";
        return (String)codeName + extensionDetails + maybeDeprecated;
    }

    public static interface StatusIndicator {
        public void onRefreshStart(@NotNull String var1);

        public void onRefreshDone(@NotNull String var1, boolean var2);
    }

    public abstract class SystemImageColumnInfo
    extends ColumnInfo<SystemImageDescription, String> {
        private final int myWidth;

        public SystemImageColumnInfo(String name, int width) {
            super(name);
            this.myWidth = width;
        }

        public SystemImageColumnInfo(String name) {
            this(name, -1);
        }

        public boolean isCellEditable(SystemImageDescription systemImageDescription) {
            return systemImageDescription.isRemote();
        }

        @Nullable
        public TableCellEditor getEditor(SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        @Nullable
        public TableCellRenderer getRenderer(SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        private void downloadImage(SystemImageDescription image) {
            ArrayList requestedPackages = Lists.newArrayList((Object[])new String[]{image.getRemotePackage().getPath()});
            ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(SystemImageListModel.this.myProject, requestedPackages);
            if (dialog2 != null) {
                dialog2.show();
                SystemImageListModel.this.refreshImages(true);
            }
        }

        @Nullable
        public Comparator<SystemImageDescription> getComparator() {
            return new Comparator<SystemImageDescription>(){
                ApiLevelComparator myComparator = new ApiLevelComparator();

                @Override
                public int compare(SystemImageDescription o1, SystemImageDescription o2) {
                    int res2 = this.myComparator.compare((String)SystemImageColumnInfo.this.valueOf(o1), (String)SystemImageColumnInfo.this.valueOf(o2));
                    if (res2 == 0) {
                        return o1.getTag().compareTo(o2.getTag());
                    }
                    return res2;
                }
            };
        }

        public int getWidth(JTable table2) {
            return this.myWidth;
        }

        private class SystemImageDescriptionRenderer
        extends AbstractTableCellEditor
        implements TableCellRenderer {
            private final SystemImageDescription image;

            SystemImageDescriptionRenderer(SystemImageDescription o) {
                this.image = o;
            }

            @Override
            public Component getTableCellRendererComponent(final JTable table2, Object value2, boolean isSelected, boolean hasFocus, final int row2, final int column2) {
                FlowLayout flowLayout = new FlowLayout(0);
                JPanel panel2 = new JPanel(flowLayout);
                JBLabel label = new JBLabel((String)value2);
                if (isSelected) {
                    if (this.image.isRemote()) {
                        panel2.setBackground(UIUtil.getListSelectionBackground((boolean)false));
                    } else {
                        panel2.setBackground(table2.getSelectionBackground());
                        label.setBackground(table2.getSelectionBackground());
                        label.setForeground(table2.getSelectionForeground());
                    }
                    panel2.setForeground(table2.getSelectionForeground());
                } else {
                    panel2.setBackground(table2.getBackground());
                    panel2.setForeground(table2.getForeground());
                }
                panel2.setOpaque(true);
                Font labelFont = StartupUiUtil.getLabelFont();
                if (column2 == 0) {
                    label.setFont(labelFont.deriveFont(1));
                }
                if (this.image.isRemote()) {
                    Font font = labelFont.deriveFont(label.getFont().getStyle() | 2);
                    label.setFont(font);
                    label.setForeground(UIUtil.getLabelDisabledForeground());
                    if (!label.getText().isEmpty()) {
                        int fontMetricsWidth = label.getFontMetrics(label.getFont()).stringWidth(label.getText());
                        TextLayout l = new TextLayout(label.getText(), label.getFont(), label.getFontMetrics(label.getFont()).getFontRenderContext());
                        int offset = (int)Math.ceil(l.getBounds().getWidth()) - fontMetricsWidth;
                        if (offset > 0) {
                            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, offset));
                        }
                    }
                    panel2.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent e) {
                            if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                                SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                            }
                        }
                    });
                }
                panel2.add((Component)label);
                if (this.image.isRemote() && column2 == 0) {
                    JBLabel link2 = new JBLabel(AllIcons.Actions.Download);
                    link2.setBackground(table2.getBackground());
                    link2.setCursor(Cursor.getPredefinedCursor(12));
                    link2.addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                            table2.changeSelection(row2, column2, false, false);
                        }
                    });
                    int columnWidth = table2.getColumnModel().getColumn(0).getWidth();
                    double extraWidth = link2.getPreferredSize().getWidth() + (double)(flowLayout.getHgap() * 3);
                    if (label.getPreferredSize().getWidth() + extraWidth > (double)columnWidth) {
                        Dimension labelSize = new Dimension((int)((double)columnWidth - extraWidth), (int)label.getPreferredSize().getHeight());
                        label.setMinimumSize(labelSize);
                        label.setMaximumSize(labelSize);
                        label.setPreferredSize(labelSize);
                        label.setSize(labelSize);
                    }
                    panel2.add((Component)link2);
                }
                return panel2;
            }

            public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row2, int column2) {
                return this.getTableCellRendererComponent(table2, value2, isSelected, false, row2, column2);
            }

            public Object getCellEditorValue() {
                return null;
            }

            public boolean isCellEditable(EventObject e) {
                return true;
            }
        }
    }
}

