/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.avdmanager.SkinChooser;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.CollectionComboBoxModel;
import java.io.File;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LoadSkinsFutureCallback
implements FutureCallback<List<File>> {
    @NotNull
    private final SkinChooser myChooser;
    @Nullable
    private final Object mySkin;

    LoadSkinsFutureCallback(@NotNull SkinChooser chooser, @Nullable Object skin) {
        this.myChooser = chooser;
        this.mySkin = skin;
    }

    public void onSuccess(@NotNull @NotNull List<@NotNull File> skins) {
        JComboBox<File> comboBox2 = this.myChooser.getComboBox();
        comboBox2.setModel((ComboBoxModel<File>)new CollectionComboBoxModel(skins));
        if (this.mySkin != null) {
            comboBox2.setSelectedItem(this.mySkin);
        }
    }

    public final void onFailure(@NotNull Throwable throwable) {
        Logger.getInstance(LoadSkinsFutureCallback.class).warn(throwable);
        this.myChooser.getComboBox().setModel((ComboBoxModel<File>)new CollectionComboBoxModel(List.of(SkinChooser.FAILED_TO_LOAD_SKINS)));
    }
}

