/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ImportDevicesAction
extends DeviceUiAction {
    public ImportDevicesAction(@NotNull DeviceUiAction.DeviceProvider provider2) {
        super(provider2, "Import Hardware Profiles");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, true);
        String homePath = System.getProperty("user.home");
        File parentPath = homePath == null ? new File("/") : new File(homePath);
        VirtualFile parent2 = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        VirtualFile[] files2 = FileChooserFactory.getInstance().createFileChooser(descriptor2, this.myProvider.getProject(), null).choose(parent2, null);
        ArrayList<Device> importedDevices = new ArrayList<Device>();
        for (VirtualFile vf : files2) {
            importedDevices.addAll(DeviceManagerConnection.getDevicesFromFile(VfsUtilCore.virtualToIoFile((VirtualFile)vf)));
        }
        if (!importedDevices.isEmpty()) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().createDevices(importedDevices);
            this.myProvider.refreshDevices();
        }
    }
}

