/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.run.util.LaunchUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorConnectionListener {
    public static ListenableFuture<IDevice> getDeviceForEmulator(@Nullable Project project, @NotNull String avdName, @Nullable ProcessHandler emulatorProcessHandler, long timeout, @NotNull TimeUnit units) {
        if (emulatorProcessHandler == null) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("The emulator process for AVD " + avdName + " died."));
        }
        SettableFuture future2 = SettableFuture.create();
        WaitForEmulatorTask task2 = new WaitForEmulatorTask(project, (SettableFuture<IDevice>)future2, avdName, emulatorProcessHandler, timeout, units);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)task2);
        return future2;
    }

    private static final class WaitForEmulatorTask
    implements Runnable {
        private static final TimeUnit POLL_TIMEUNIT = TimeUnit.SECONDS;
        private final Project myProject;
        private final SettableFuture<IDevice> myDeviceFuture;
        private final String myAvdName;
        private final ProcessHandler myEmulatorProcessHandler;
        private final long myTimeout;

        private WaitForEmulatorTask(@Nullable Project project, @NotNull SettableFuture<IDevice> device2, @NotNull String avdName, @NotNull ProcessHandler emulatorProcessHandler, long timeout, @NotNull TimeUnit units) {
            this.myProject = project;
            this.myDeviceFuture = device2;
            this.myAvdName = avdName;
            this.myEmulatorProcessHandler = emulatorProcessHandler;
            this.myTimeout = POLL_TIMEUNIT.convert(timeout, units);
        }

        @Override
        public void run() {
            File adb = AndroidSdkUtils.getAdb(this.myProject);
            if (adb == null) {
                this.myDeviceFuture.setException((Throwable)new IllegalArgumentException("Unable to locate adb"));
                return;
            }
            for (long i = 0L; i < this.myTimeout; ++i) {
                AndroidDebugBridge bridge;
                if (this.myDeviceFuture.isCancelled()) {
                    return;
                }
                if (this.myEmulatorProcessHandler.isProcessTerminated() || this.myEmulatorProcessHandler.isProcessTerminating()) {
                    this.myDeviceFuture.setException((Throwable)new RuntimeException("The emulator process for AVD " + this.myAvdName + " has terminated."));
                    return;
                }
                ListenableFuture<AndroidDebugBridge> bridgeFuture = AdbService.getInstance().getDebugBridge(adb);
                try {
                    bridge = (AndroidDebugBridge)bridgeFuture.get(1L, POLL_TIMEUNIT);
                }
                catch (TimeoutException e) {
                    continue;
                }
                catch (Exception e) {
                    this.myDeviceFuture.setException((Throwable)e);
                    return;
                }
                if (bridge == null || !bridge.isConnected()) {
                    this.myDeviceFuture.setException((Throwable)new RuntimeException("adb connection not available, or was terminated."));
                    return;
                }
                for (IDevice device2 : bridge.getDevices()) {
                    if (!device2.isEmulator() || !StringUtil.equals((CharSequence)device2.getAvdName(), (CharSequence)this.myAvdName) || !WaitForEmulatorTask.isEmulatorReady(device2)) continue;
                    LaunchUtils.initiateDismissKeyguard(device2);
                    this.myDeviceFuture.set((Object)device2);
                    return;
                }
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)POLL_TIMEUNIT);
            }
            String msg = "Timed out after " + POLL_TIMEUNIT.toSeconds(this.myTimeout) + "seconds waiting for emulator to come online.";
            this.myDeviceFuture.setException((Throwable)new TimeoutException(msg));
            Logger.getInstance(EmulatorConnectionListener.class).warn(msg);
        }

        private static boolean isEmulatorReady(@NotNull IDevice device2) {
            if (!device2.isOnline()) {
                return false;
            }
            String bootComplete = device2.getProperty("dev.bootcomplete");
            if (bootComplete == null) {
                Logger.getInstance(EmulatorConnectionListener.class).warn("Emulator not ready yet, dev.bootcomplete = null");
                return false;
            }
            return true;
        }
    }
}

