/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.io.IAbstractFile;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;

public final class EmulatorAdvFeatures {
    public static final String FEATURE_FAST_BOOT = "FastSnapshotV1";
    public static final String FEATURE_SCREEN_RECORDING = "ScreenRecording";
    public static final String FEATURE_VIRTUAL_SCENE = "VirtualScene";
    private static Map<String, String> mEmuAdvFeatures;
    private static Map<String, String> mEmuAdvFeaturesCanary;

    public static Map<String, String> getEmulatorFeaturesMap(String featuresFile, AndroidSdkHandler sdkHandler, ProgressIndicator progressIndicator, ILogger log) {
        Path emuAdvFeaturesFile;
        if (sdkHandler == null) {
            return null;
        }
        LocalPackage emulatorPackage = sdkHandler.getLocalPackage("emulator", progressIndicator);
        if (emulatorPackage != null && Files.exists(emuAdvFeaturesFile = emulatorPackage.getLocation().resolve("lib" + File.separator + featuresFile), new LinkOption[0])) {
            return ProjectProperties.parsePropertyFile((IAbstractFile)new PathFileWrapper(emuAdvFeaturesFile), (ILogger)log);
        }
        return null;
    }

    public static boolean emulatorSupportsFeature(String theFeature, AndroidSdkHandler sdkHandler, ProgressIndicator progressIndicator, ILogger log) {
        Map<String, String> theMap;
        ChannelStatus channelStatus = UpdateSettings.getInstance().getSelectedChannelStatus();
        switch (channelStatus) {
            case EAP: {
                if (mEmuAdvFeaturesCanary == null) {
                    mEmuAdvFeaturesCanary = EmulatorAdvFeatures.getEmulatorFeaturesMap("advancedFeaturesCanary.ini", sdkHandler, progressIndicator, log);
                }
                theMap = mEmuAdvFeaturesCanary;
                break;
            }
            default: {
                if (mEmuAdvFeatures == null) {
                    mEmuAdvFeatures = EmulatorAdvFeatures.getEmulatorFeaturesMap("advancedFeatures.ini", sdkHandler, progressIndicator, log);
                }
                theMap = mEmuAdvFeatures;
            }
        }
        if (channelStatus != ChannelStatus.RELEASE && theMap == null) {
            if (mEmuAdvFeatures == null) {
                mEmuAdvFeatures = EmulatorAdvFeatures.getEmulatorFeaturesMap("advancedFeatures.ini", sdkHandler, progressIndicator, log);
            }
            theMap = mEmuAdvFeatures;
        }
        return theMap != null && "on".equals(theMap.get(theFeature));
    }

    public static boolean emulatorSupportsFastBoot(AndroidSdkHandler sdkHandler, ProgressIndicator progressIndicator, ILogger log) {
        return EmulatorAdvFeatures.emulatorSupportsFeature(FEATURE_FAST_BOOT, sdkHandler, progressIndicator, log);
    }

    public static boolean emulatorSupportsScreenRecording(AndroidSdkHandler sdkHandler, ProgressIndicator progressIndicator, ILogger log) {
        return EmulatorAdvFeatures.emulatorSupportsFeature(FEATURE_SCREEN_RECORDING, sdkHandler, progressIndicator, log);
    }

    public static boolean emulatorSupportsVirtualScene(AndroidSdkHandler sdkHandler, ProgressIndicator progressIndicator, ILogger log) {
        return EmulatorAdvFeatures.emulatorSupportsFeature(FEATURE_VIRTUAL_SCENE, sdkHandler, progressIndicator, log);
    }
}

