/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceSkinUpdater;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@Service
public final class DeviceSkinUpdaterService {
    @NotNull
    private final ListeningExecutorService myExecutorService;

    private DeviceSkinUpdaterService() {
        ExecutorService delegate2 = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"DeviceSkinUpdaterService", (int)1);
        this.myExecutorService = MoreExecutors.listeningDecorator((ExecutorService)delegate2);
    }

    @NotNull
    public static DeviceSkinUpdaterService getInstance() {
        return (DeviceSkinUpdaterService)ApplicationManager.getApplication().getService(DeviceSkinUpdaterService.class);
    }

    @NotNull
    Executor getExecutor() {
        return this.myExecutorService;
    }

    @AnyThread
    @NotNull
    @NotNull ListenableFuture<@NotNull Path> updateSkins(@NotNull Path device2) {
        return this.updateSkins(device2, null);
    }

    @AnyThread
    @NotNull
    public @NotNull ListenableFuture<@NotNull Path> updateSkins(@NotNull Path device2, SystemImageDescription image) {
        return this.myExecutorService.submit(() -> DeviceSkinUpdater.updateSkins(device2, image));
    }

    @AnyThread
    @NotNull
    @NotNull ListenableFuture<@NotNull Collection<@NotNull Path>> updateSkinsIncludingSdkHandlerOnes() {
        return this.myExecutorService.submit(() -> DeviceSkinUpdaterService.updateSkins(DeviceSkinUpdater::updateSkins));
    }

    @AnyThread
    @NotNull
    @NotNull ListenableFuture<@NotNull Collection<@NotNull Path>> updateSkinsExcludingSdkHandlerOnes() {
        return this.myExecutorService.submit(() -> DeviceSkinUpdaterService.updateSkins(Path::getFileName));
    }

    @WorkerThread
    @NotNull
    private static @NotNull Collection<@NotNull Path> updateSkins(@NotNull @NotNull Function<@NotNull Path, @NotNull Path> updateSkins) {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(DeviceSkinUpdaterService.class);
        Stream stream = Streams.concat((Stream[])new Stream[]{DeviceSkinUpdaterService.deviceSkinStream(), DeviceSkinUpdaterService.targetSkinStream(handler2, (ProgressIndicator)indicator, updateSkins), DeviceSkinUpdaterService.imageSkinStream(handler2, (ProgressIndicator)indicator, updateSkins)});
        return stream.collect(Collectors.toList());
    }

    @WorkerThread
    @NotNull
    private static @NotNull Stream<@NotNull Path> deviceSkinStream() {
        return DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices().stream().map(Device::getDefaultHardware).map(Hardware::getSkinFile).filter(Objects::nonNull).map(File::toPath).map(DeviceSkinUpdater::updateSkins);
    }

    @WorkerThread
    @NotNull
    private static @NotNull Stream<@NotNull Path> targetSkinStream(@NotNull AndroidSdkHandler handler2, @NotNull ProgressIndicator indicator, @NotNull @NotNull Function<@NotNull Path, @NotNull Path> updateSkins) {
        return handler2.getAndroidTargetManager(indicator).getTargets(indicator).stream().map(IAndroidTarget::getSkins).flatMap(Arrays::stream).filter(Objects::nonNull).map(updateSkins);
    }

    @WorkerThread
    @NotNull
    private static @NotNull Stream<@NotNull Path> imageSkinStream(@NotNull AndroidSdkHandler handler2, @NotNull ProgressIndicator indicator, @NotNull @NotNull Function<@NotNull Path, @NotNull Path> updateSkins) {
        return handler2.getSystemImageManager(indicator).getImages().stream().map(SystemImage::getSkins).flatMap(Arrays::stream).filter(Objects::nonNull).map(updateSkins);
    }
}

