/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceDefinitionList;
import com.android.tools.idea.observable.InvalidationListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceDefinitionPreview
extends JPanel
implements DeviceDefinitionList.DeviceCategorySelectionListener {
    public static final String DO_NOT_DISPLAY = "DO_NOT_DISPLAY";
    private static final int FIGURE_PADDING = JBUI.scale((int)3);
    private static final DecimalFormat FORMAT = new DecimalFormat(".##\"");
    public static final int DIMENSION_LINE_WIDTH = JBUI.scale((int)1);
    public static final int OUTLINE_LINE_WIDTH = JBUI.scale((int)5);
    private static final String NO_DEVICE_SELECTED = "No Device Selected";
    double myMaxOutlineWidth;
    double myMinOutlineWidthIn;
    private static final int PADDING = JBUI.scale((int)20);
    private final AvdDeviceData myDeviceData;
    private static final JBColor OUR_GRAY = new JBColor((Color)Gray._192, (Color)Gray._96);
    private InvalidationListener myRepaintListener = () -> this.repaint();

    public DeviceDefinitionPreview(@NotNull AvdDeviceData deviceData) {
        this.myDeviceData = deviceData;
        this.addListeners();
    }

    @NotNull
    public AvdDeviceData getDeviceData() {
        return this.myDeviceData;
    }

    @NotNull
    public static Icon getIcon(@Nullable AvdDeviceData deviceData) {
        Icon icon2 = StudioIcons.Avd.DEVICE_MOBILE_LARGE;
        if (deviceData != null) {
            if (((Boolean)deviceData.isTv().get()).booleanValue()) {
                icon2 = StudioIcons.Avd.DEVICE_TV_LARGE;
            } else if (((Boolean)deviceData.isWear().get()).booleanValue()) {
                icon2 = StudioIcons.Avd.DEVICE_WEAR_LARGE;
            }
        }
        return icon2;
    }

    private void addListeners() {
        this.myDeviceData.supportsLandscape().addWeakListener(this.myRepaintListener);
        this.myDeviceData.supportsPortrait().addWeakListener(this.myRepaintListener);
        this.myDeviceData.name().addWeakListener(this.myRepaintListener);
        this.myDeviceData.screenResolutionWidth().addWeakListener(this.myRepaintListener);
        this.myDeviceData.screenResolutionHeight().addWeakListener(this.myRepaintListener);
        this.myDeviceData.deviceType().addWeakListener(this.myRepaintListener);
        this.myDeviceData.diagonalScreenSize().addWeakListener(this.myRepaintListener);
        this.myDeviceData.isScreenRound().addWeakListener(this.myRepaintListener);
        this.myDeviceData.screenDpi().addWeakListener(this.myRepaintListener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g, (boolean)true, (boolean)true);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(JBColor.foreground());
        g2d.setFont(AvdWizardUtils.STANDARD_FONT);
        if (((String)this.myDeviceData.name().get()).equals(DO_NOT_DISPLAY)) {
            FontMetrics metrics = g2d.getFontMetrics();
            g2d.drawString(NO_DEVICE_SELECTED, (this.getWidth() - metrics.stringWidth(NO_DEVICE_SELECTED)) / 2, (this.getHeight() - metrics.getHeight()) / 2);
            return;
        }
        boolean isCircular = (Boolean)this.myDeviceData.isWear().get() != false && (Boolean)this.myDeviceData.isScreenRound().get() != false;
        Icon icon2 = DeviceDefinitionPreview.getIcon(this.myDeviceData);
        icon2.paintIcon(this, g, PADDING / 2, PADDING / 2);
        g2d.setFont(AvdWizardUtils.TITLE_FONT);
        FontMetrics metrics = g.getFontMetrics(AvdWizardUtils.TITLE_FONT);
        g2d.drawString((String)this.myDeviceData.name().get(), JBUI.scale((int)50), PADDING + metrics.getHeight() / 2);
        g2d.drawLine(0, JBUI.scale((int)50), this.getWidth(), JBUI.scale((int)50));
        Dimension screenSize = this.getScaledDimension();
        Dimension pixelScreenSize = this.myDeviceData.getDeviceScreenDimension();
        if (screenSize != null) {
            int infoSegmentY;
            int infoSegmentX;
            if (screenSize.getHeight() <= 0.0) {
                screenSize.height = 1;
            }
            if (screenSize.getWidth() <= 0.0) {
                screenSize.width = 1;
            }
            RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(PADDING, JBUI.scale((int)100), screenSize.width, screenSize.height, JBUI.scale((int)10), JBUI.scale((int)10));
            BasicStroke normalStroke = new BasicStroke(DIMENSION_LINE_WIDTH);
            g2d.setStroke(normalStroke);
            g2d.setColor((Color)OUR_GRAY);
            g2d.setFont(AvdWizardUtils.FIGURE_FONT);
            metrics = g2d.getFontMetrics(AvdWizardUtils.FIGURE_FONT);
            int stringHeight = metrics.getHeight() - metrics.getDescent();
            if (((Boolean)this.myDeviceData.isFoldable().get()).booleanValue()) {
                double displayFactor = (double)screenSize.height / (double)((Integer)this.myDeviceData.screenResolutionHeight().get()).intValue();
                int foldedX = (int)((double)((Integer)this.myDeviceData.screenFoldedXOffset().get()).intValue() * displayFactor + 0.5);
                int foldedY = (int)((double)((Integer)this.myDeviceData.screenFoldedYOffset().get()).intValue() * displayFactor + 0.5);
                int foldedWidth = (int)((double)((Integer)this.myDeviceData.screenFoldedWidth().get()).intValue() * displayFactor + 0.5);
                int foldedHeight = (int)((double)((Integer)this.myDeviceData.screenFoldedHeight().get()).intValue() * displayFactor + 0.5);
                int foldedX2 = (int)((double)((Integer)this.myDeviceData.screenFoldedXOffset2().get()).intValue() * displayFactor + 0.5);
                int foldedY2 = (int)((double)((Integer)this.myDeviceData.screenFoldedYOffset2().get()).intValue() * displayFactor + 0.5);
                int foldedWidth2 = (int)((double)((Integer)this.myDeviceData.screenFoldedWidth2().get()).intValue() * displayFactor + 0.5);
                int foldedHeight2 = (int)((double)((Integer)this.myDeviceData.screenFoldedHeight2().get()).intValue() * displayFactor + 0.5);
                int foldedX3 = (int)((double)((Integer)this.myDeviceData.screenFoldedXOffset3().get()).intValue() * displayFactor + 0.5);
                int foldedY3 = (int)((double)((Integer)this.myDeviceData.screenFoldedYOffset3().get()).intValue() * displayFactor + 0.5);
                int foldedWidth3 = (int)((double)((Integer)this.myDeviceData.screenFoldedWidth3().get()).intValue() * displayFactor + 0.5);
                int foldedHeight3 = (int)((double)((Integer)this.myDeviceData.screenFoldedHeight3().get()).intValue() * displayFactor + 0.5);
                foldedX += PADDING;
                foldedY += JBUI.scale((int)100);
                foldedX2 += PADDING;
                foldedY2 += JBUI.scale((int)100);
                foldedX3 += PADDING;
                foldedY3 += JBUI.scale((int)100);
                g2d.setStroke(new BasicStroke(OUTLINE_LINE_WIDTH, 0, 2, 0.0f, new float[]{9.0f}, 0.0f));
                if ((Integer)this.myDeviceData.screenFoldedXOffset().get() != 0) {
                    g2d.drawLine(foldedX, foldedY, foldedX, foldedY + foldedHeight);
                }
                if ((Integer)this.myDeviceData.screenFoldedYOffset().get() != 0) {
                    g2d.drawLine(foldedX, foldedY, foldedX + foldedWidth, foldedY);
                }
                if ((Integer)this.myDeviceData.screenFoldedXOffset().get() + (Integer)this.myDeviceData.screenFoldedWidth().get() != (Integer)this.myDeviceData.screenResolutionWidth().get()) {
                    g2d.drawLine(foldedX + foldedWidth, foldedY, foldedX + foldedWidth, foldedY + foldedHeight);
                }
                if ((Integer)this.myDeviceData.screenFoldedYOffset().get() + (Integer)this.myDeviceData.screenFoldedHeight().get() != (Integer)this.myDeviceData.screenResolutionHeight().get()) {
                    g2d.drawLine(foldedX, foldedY + foldedHeight, foldedX + foldedWidth, foldedY + foldedHeight);
                }
                if ((Integer)this.myDeviceData.screenFoldedXOffset2().get() != 0) {
                    g2d.drawLine(foldedX2, foldedY2, foldedX2, foldedY2 + foldedHeight2);
                }
                if ((Integer)this.myDeviceData.screenFoldedYOffset2().get() != 0) {
                    g2d.drawLine(foldedX2, foldedY2, foldedX2 + foldedWidth2, foldedY2);
                }
                if ((Integer)this.myDeviceData.screenFoldedWidth2().get() != 0 && (Integer)this.myDeviceData.screenFoldedXOffset2().get() + (Integer)this.myDeviceData.screenFoldedWidth2().get() != (Integer)this.myDeviceData.screenResolutionWidth().get()) {
                    g2d.drawLine(foldedX2 + foldedWidth2, foldedY2, foldedX2 + foldedWidth2, foldedY2 + foldedHeight2);
                }
                if ((Integer)this.myDeviceData.screenFoldedHeight2().get() != 0 && (Integer)this.myDeviceData.screenFoldedYOffset2().get() + (Integer)this.myDeviceData.screenFoldedHeight2().get() != (Integer)this.myDeviceData.screenResolutionHeight().get()) {
                    g2d.drawLine(foldedX2, foldedY2 + foldedHeight2, foldedX2 + foldedWidth2, foldedY2 + foldedHeight2);
                }
                if ((Integer)this.myDeviceData.screenFoldedXOffset3().get() != 0) {
                    g2d.drawLine(foldedX3, foldedY3, foldedX3, foldedY3 + foldedHeight3);
                }
                if ((Integer)this.myDeviceData.screenFoldedYOffset3().get() != 0) {
                    g2d.drawLine(foldedX3, foldedY3, foldedX3 + foldedWidth3, foldedY3);
                }
                if ((Integer)this.myDeviceData.screenFoldedWidth3().get() != 0 && (Integer)this.myDeviceData.screenFoldedXOffset3().get() + (Integer)this.myDeviceData.screenFoldedWidth3().get() != (Integer)this.myDeviceData.screenResolutionWidth().get()) {
                    g2d.drawLine(foldedX3 + foldedWidth3, foldedY3, foldedX3 + foldedWidth3, foldedY3 + foldedHeight3);
                }
                if ((Integer)this.myDeviceData.screenFoldedHeight3().get() != 0 && (Integer)this.myDeviceData.screenFoldedYOffset3().get() + (Integer)this.myDeviceData.screenFoldedHeight3().get() != (Integer)this.myDeviceData.screenResolutionHeight().get()) {
                    g2d.drawLine(foldedX3, foldedY3 + foldedHeight3, foldedX3 + foldedWidth3, foldedY3 + foldedHeight3);
                }
                g2d.setStroke(normalStroke);
            }
            String widthString = Integer.toString(pixelScreenSize.width) + "px";
            int widthLineY = JBUI.scale((int)95) - (metrics.getHeight() - metrics.getDescent()) / 2;
            g2d.drawLine(PADDING, widthLineY, DeviceDefinitionPreview.round(PADDING + screenSize.width), widthLineY);
            g2d.setColor(JBColor.background());
            int widthStringWidth = metrics.stringWidth(widthString);
            int widthTextX = DeviceDefinitionPreview.round((double)PADDING + (double)(screenSize.width - widthStringWidth) / 2.0);
            g2d.drawLine(widthTextX - FIGURE_PADDING, widthLineY, widthTextX + widthStringWidth + FIGURE_PADDING, widthLineY);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(widthString, widthTextX, JBUI.scale((int)95));
            g2d.setColor((Color)OUR_GRAY);
            String heightString = Integer.toString(pixelScreenSize.height) + "px";
            int heightLineX = DeviceDefinitionPreview.round(PADDING + screenSize.width + JBUI.scale((int)15));
            g2d.drawLine(heightLineX, JBUI.scale((int)100), heightLineX, DeviceDefinitionPreview.round(JBUI.scale((int)100) + screenSize.height));
            g2d.setColor(JBColor.background());
            int heightTextY = DeviceDefinitionPreview.round((double)JBUI.scale((int)100) + (double)(screenSize.height + stringHeight) / 2.0);
            g2d.drawLine(heightLineX, heightTextY + FIGURE_PADDING, heightLineX, heightTextY - stringHeight - FIGURE_PADDING);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(heightString, heightLineX - JBUI.scale((int)10), heightTextY);
            g2d.setColor((Color)OUR_GRAY);
            String diagString = FORMAT.format(this.myDeviceData.diagonalScreenSize().get());
            int diagTextX = DeviceDefinitionPreview.round((double)PADDING + (double)(screenSize.width - metrics.stringWidth(diagString)) / 2.0);
            int diagTextY = DeviceDefinitionPreview.round((double)JBUI.scale((int)100) + (double)(screenSize.height + stringHeight) / 2.0);
            double chin = ((Integer)this.myDeviceData.screenChinSize().get()).intValue();
            Line2D.Double diagLine = new Line2D.Double(PADDING, (double)(JBUI.scale((int)100) + screenSize.height) + (chin *= screenSize.getWidth() / this.myDeviceData.getDeviceScreenDimension().getWidth()), PADDING + screenSize.width, JBUI.scale((int)100));
            if (isCircular) {
                double dist = 0.5 * ((double)screenSize.width - (double)screenSize.width / Math.sqrt(2.0));
                ((Line2D)diagLine).setLine(((Line2D)diagLine).getX1() + dist, ((Line2D)diagLine).getY1() - dist, ((Line2D)diagLine).getX2() - dist, ((Line2D)diagLine).getY2() + dist);
            }
            g2d.draw(diagLine);
            g2d.setColor(JBColor.background());
            Rectangle erasureRect = new Rectangle(diagTextX - FIGURE_PADDING, diagTextY - stringHeight - FIGURE_PADDING, metrics.stringWidth(diagString) + FIGURE_PADDING * 2, stringHeight + FIGURE_PADDING * 2);
            g2d.fill(erasureRect);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(diagString, diagTextX, diagTextY);
            g2d.setStroke(new BasicStroke(OUTLINE_LINE_WIDTH));
            g2d.setColor(JBColor.foreground());
            if (isCircular) {
                double x = ((RectangularShape)roundRect).getX();
                double y = ((RectangularShape)roundRect).getY();
                Ellipse2D.Double circle = new Ellipse2D.Double(x, y, screenSize.width, (double)screenSize.height + chin);
                g2d.draw(circle);
                if (chin > 0.0) {
                    erasureRect = new Rectangle((int)x, (int)(y + (double)screenSize.height + (double)OUTLINE_LINE_WIDTH / 2.0 + 1.0), screenSize.width, (int)chin + OUTLINE_LINE_WIDTH / 2 + 1);
                    g2d.setColor(JBColor.background());
                    g2d.fill(erasureRect);
                    g2d.setColor(JBColor.foreground());
                    double halfChinWidth = Math.sqrt(chin * ((double)screenSize.width - chin)) - (double)OUTLINE_LINE_WIDTH / 2.0;
                    int chinX = (int)(x + (double)(screenSize.width / 2) - halfChinWidth);
                    g2d.drawLine(chinX, (int)(y + (double)screenSize.height), (int)((double)chinX + halfChinWidth * 2.0), (int)(y + (double)screenSize.height));
                }
            } else {
                g2d.draw(roundRect);
            }
            g2d.setFont(AvdWizardUtils.STANDARD_FONT);
            metrics = g2d.getFontMetrics(AvdWizardUtils.STANDARD_FONT);
            stringHeight = metrics.getHeight();
            if (this.myDeviceData.getDefaultDeviceOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                infoSegmentX = DeviceDefinitionPreview.round(PADDING + screenSize.width + metrics.stringWidth(heightString) + PADDING);
                infoSegmentY = JBUI.scale((int)100);
            } else {
                infoSegmentX = PADDING;
                infoSegmentY = DeviceDefinitionPreview.round(JBUI.scale((int)100) + screenSize.height + PADDING);
            }
            int valueOffsetX = metrics.stringWidth("Density:") + metrics.stringWidth(" ");
            ScreenSize size = ScreenSize.getScreenSize((Double)((Double)this.myDeviceData.diagonalScreenSize().get()));
            g2d.drawString("Size:", infoSegmentX, infoSegmentY += stringHeight);
            g2d.drawString(size.getResourceValue(), infoSegmentX + valueOffsetX, infoSegmentY);
            ScreenRatio ratio = AvdScreenData.getScreenRatio((Integer)this.myDeviceData.screenResolutionWidth().get(), (Integer)this.myDeviceData.screenResolutionHeight().get());
            g2d.drawString("Ratio:", infoSegmentX, infoSegmentY += stringHeight);
            g2d.drawString(ratio.getResourceValue(), infoSegmentX + valueOffsetX, infoSegmentY);
            g2d.drawString("Density:", infoSegmentX, infoSegmentY += stringHeight);
            g2d.drawString(((Density)this.myDeviceData.density().get()).getResourceValue(), infoSegmentX + valueOffsetX, infoSegmentY);
            if (((Boolean)this.myDeviceData.isFoldable().get()).booleanValue()) {
                infoSegmentY += stringHeight;
                if ((Integer)this.myDeviceData.screenFoldedWidth2().get() == 0 && (Integer)this.myDeviceData.screenFoldedWidth3().get() == 0) {
                    g2d.drawString("Folded: " + this.myDeviceData.screenFoldedWidth().get() + "x" + this.myDeviceData.screenFoldedHeight(), infoSegmentX, infoSegmentY);
                } else {
                    g2d.drawString("Rolled in: " + this.myDeviceData.screenFoldedWidth().get() + "x" + this.myDeviceData.screenFoldedHeight(), infoSegmentX, infoSegmentY);
                    if ((Integer)this.myDeviceData.screenFoldedWidth2().get() != 0) {
                        g2d.drawString("Intermediate: " + this.myDeviceData.screenFoldedWidth2().get() + "x" + this.myDeviceData.screenFoldedHeight2(), infoSegmentX, infoSegmentY += stringHeight);
                    }
                    if ((Integer)this.myDeviceData.screenFoldedWidth3().get() != 0) {
                        g2d.drawString("Intermediate2: " + this.myDeviceData.screenFoldedWidth3().get() + "x" + this.myDeviceData.screenFoldedHeight3(), infoSegmentX, infoSegmentY += stringHeight);
                    }
                    g2d.drawString("Rolled out: " + pixelScreenSize.width + "x" + pixelScreenSize.height, infoSegmentX, infoSegmentY += stringHeight);
                }
            }
            if (((String)this.myDeviceData.deviceId().get()).equals("resizable")) {
                g2d.drawString("This device resizes to:", infoSegmentX, infoSegmentY += stringHeight * 2);
                g2d.drawString("Phone (1080 x 2340 @ 420dpi)", infoSegmentX, infoSegmentY += stringHeight);
                g2d.drawString("Foldable (1768 x 2208 @ 420dpi)", infoSegmentX, infoSegmentY += stringHeight);
                g2d.drawString("Tablet (1920 x 1200 @ 240dpi)", infoSegmentX, infoSegmentY += stringHeight);
                g2d.drawString("Desktop (1920 x 1080 @ 160dpi)", infoSegmentX, infoSegmentY += stringHeight);
            }
        }
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }

    @Nullable
    private Dimension getScaledDimension() {
        Dimension pixelSize = this.myDeviceData.getDeviceScreenDimension();
        if (pixelSize == null) {
            return null;
        }
        double diagonalIn = (Double)this.myDeviceData.diagonalScreenSize().get();
        double sideRatio = pixelSize.getWidth() / pixelSize.getHeight();
        double heightIn = diagonalIn / Math.sqrt(1.0 + sideRatio * sideRatio);
        double widthIn = sideRatio * heightIn;
        double maxWidthIn = this.myMaxOutlineWidth == 0.0 ? widthIn : this.myMaxOutlineWidth;
        double desiredMaxWidthPx = (double)this.getWidth() * 0.4;
        double desiredMinWidthPx = (double)this.getWidth() * 0.1;
        double widthPixels = widthIn * desiredMaxWidthPx / maxWidthIn;
        if (this.myMinOutlineWidthIn * desiredMaxWidthPx / maxWidthIn < desiredMinWidthPx) {
            widthPixels = desiredMinWidthPx + (widthIn - this.myMinOutlineWidthIn) * (desiredMaxWidthPx - desiredMinWidthPx) / (maxWidthIn - this.myMinOutlineWidthIn);
        }
        double heightPixels = widthPixels / widthIn * heightIn;
        return new Dimension((int)widthPixels, (int)heightPixels);
    }

    @Override
    public void onCategorySelectionChanged(@Nullable String category, @Nullable List<Device> devices2) {
        if (devices2 == null) {
            this.myMaxOutlineWidth = 0.0;
            this.myMinOutlineWidthIn = 0.0;
        } else {
            double maxWidth = 0.0;
            double minWidth = Double.MAX_VALUE;
            for (Device d : devices2) {
                Dimension pixelSize = d.getScreenSize(d.getDefaultState().getOrientation());
                if (pixelSize == null) continue;
                double diagonal = d.getDefaultHardware().getScreen().getDiagonalLength();
                double sideRatio = pixelSize.getHeight() / pixelSize.getWidth();
                double widthIn = diagonal / Math.sqrt(1.0 + sideRatio * sideRatio);
                maxWidth = Math.max(maxWidth, widthIn);
                minWidth = Math.min(minWidth, widthIn);
            }
            this.myMaxOutlineWidth = maxWidth;
            this.myMinOutlineWidthIn = minWidth;
        }
    }
}

