/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.SkinChooser;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

final class CustomSkinValidator
implements Validator<Optional<File>> {
    CustomSkinValidator() {
    }

    @NotNull
    public Validator.Result validate(@NotNull @NotNull Optional<@NotNull File> optionalCustomSkin) {
        if (optionalCustomSkin.isEmpty()) {
            return Validator.Result.OK;
        }
        File customSkin = optionalCustomSkin.get();
        if (FileUtil.filesEqual((File)customSkin, (File)AvdWizardUtils.NO_SKIN)) {
            return Validator.Result.OK;
        }
        if (FileUtil.filesEqual((File)customSkin, (File)SkinChooser.LOADING_SKINS)) {
            return new Validator.Result(Validator.Severity.ERROR, "Loading device skins. This can take a few seconds.");
        }
        File layout = new File(customSkin, "layout");
        if (!layout.isFile()) {
            return new Validator.Result(Validator.Severity.ERROR, "The skin directory does not point to a valid skin.");
        }
        return Validator.Result.OK;
    }
}

