/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Navigation;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.adtui.TooltipLabel;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.ConfigureDeviceModel;
import com.android.tools.idea.avdmanager.CustomSkinValidator;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.LoadSkinsFutureCallback;
import com.android.tools.idea.avdmanager.SkinChooser;
import com.android.tools.idea.avdmanager.StorageField;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.adapters.StringToDoubleAdapterProperty;
import com.android.tools.idea.observable.adapters.StringToIntAdapterProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.deprecated.StudioWizardStepPanel;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class ConfigureDeviceOptionsStep
extends ModelWizardStep<ConfigureDeviceModel> {
    private static final String DEFAULT_DEVICE_TYPE_LABEL = "Phone/Tablet";
    private JPanel myRootPanel;
    private DeviceDefinitionPreview myDeviceDefinitionPreview;
    private JCheckBox myHasBackFacingCamera;
    private JCheckBox myHasFrontFacingCamera;
    private JCheckBox myHasAccelerometer;
    private JCheckBox myHasGyroscope;
    private JCheckBox myHasGps;
    private JCheckBox myHasProximitySensor;
    private JCheckBox mySupportsLandscape;
    private JCheckBox mySupportsPortrait;
    private JCheckBox myHasHardwareKeyboard;
    private JCheckBox myHasHardwareButtons;
    private JTextField myDeviceName;
    private JTextField myScreenResolutionWidth;
    private JTextField myScreenResolutionHeight;
    private SkinChooser myCustomSkinPath;
    private BrowserLink myHardwareSkinHelpLabel;
    private ComboBox<IdDisplay> myDeviceTypeComboBox;
    private JTextField myDiagonalScreenSize;
    private StorageField myRamField;
    private JComboBox myNavigationControlsCombo;
    private TooltipLabel myHelpAndErrorLabel;
    private JCheckBox myIsScreenRound;
    private JBScrollPane myScrollPane;
    private StringToDoubleAdapterProperty myDiagScreenSizeAdapter;
    private StringToIntAdapterProperty myScreenResWidthAdapter;
    private StringToIntAdapterProperty myScreenResHeightAdapter;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;

    public ConfigureDeviceOptionsStep(@NotNull ConfigureDeviceModel model2) {
        super(model2, "Configure Hardware Profile");
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, "Configure this hardware profile");
        this.initSkinComboBox();
    }

    private void initSkinComboBox() {
        final OptionalProperty<File> optionalSkin = ((ConfigureDeviceModel)this.getModel()).getDeviceData().customSkinFile();
        final File skin = optionalSkin.getValueOrNull();
        LoadSkinsFutureCallback callback = new LoadSkinsFutureCallback(this.myCustomSkinPath, skin){

            @Override
            public void onSuccess(@NotNull @NotNull List<@NotNull File> skins) {
                super.onSuccess(skins);
                if (skin != null) {
                    optionalSkin.setValue(skin);
                }
                ConfigureDeviceOptionsStep.this.myCustomSkinPath.setEnabled(true);
            }
        };
        Futures.addCallback(this.myCustomSkinPath.loadSkins(), (FutureCallback)callback, (Executor)EdtExecutorService.getInstance());
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        this.myDeviceTypeComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(AvdWizardUtils.ALL_DEVICE_TAGS));
        this.myDeviceTypeComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DEFAULT_DEVICE_TYPE_LABEL, value2 -> SystemImage.DEFAULT_TAG.equals(value2) ? DEFAULT_DEVICE_TYPE_LABEL : value2.getDisplay()));
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myHelpAndErrorLabel.setBackground(JBColor.background());
        this.myHelpAndErrorLabel.setForeground(JBColor.foreground());
        this.myHelpAndErrorLabel.setBorder(BorderFactory.createEmptyBorder(15, 15, 10, 10));
        this.myDiagScreenSizeAdapter = new StringToDoubleAdapterProperty(new TextProperty(this.myDiagonalScreenSize), 1, 2);
        this.myScreenResWidthAdapter = new StringToIntAdapterProperty(new TextProperty(this.myScreenResolutionWidth));
        this.myScreenResHeightAdapter = new StringToIntAdapterProperty(new TextProperty(this.myScreenResolutionHeight));
        this.attachBindingsAndValidators();
    }

    @Override
    protected void onEntering() {
        AvdDeviceData deviceModel = ((ConfigureDeviceModel)this.getModel()).getDeviceData();
        this.myDiagScreenSizeAdapter.set(deviceModel.diagonalScreenSize());
        this.myScreenResWidthAdapter.set(deviceModel.screenResolutionWidth());
        this.myScreenResHeightAdapter.set(deviceModel.screenResolutionHeight());
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    private void attachBindingsAndValidators() {
        AvdDeviceData deviceModel = ((ConfigureDeviceModel)this.getModel()).getDeviceData();
        this.myBindings.bindTwoWay(new TextProperty(this.myDeviceName), deviceModel.name());
        this.myBindings.bind(deviceModel.diagonalScreenSize(), this.myDiagScreenSizeAdapter);
        this.myBindings.bind(deviceModel.screenResolutionWidth(), this.myScreenResWidthAdapter);
        this.myBindings.bind(deviceModel.screenResolutionHeight(), this.myScreenResHeightAdapter);
        this.myBindings.bindTwoWay(this.myRamField.storage(), deviceModel.ramStorage());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasHardwareButtons), deviceModel.hasHardwareButtons());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasHardwareKeyboard), deviceModel.hasHardwareKeyboard());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myNavigationControlsCombo), deviceModel.navigation());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myIsScreenRound), deviceModel.isScreenRound());
        this.myBindings.bindTwoWay(new SelectedProperty(this.mySupportsLandscape), deviceModel.supportsLandscape());
        this.myBindings.bindTwoWay(new SelectedProperty(this.mySupportsPortrait), deviceModel.supportsPortrait());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasBackFacingCamera), deviceModel.hasBackCamera());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasFrontFacingCamera), deviceModel.hasFrontCamera());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasAccelerometer), deviceModel.hasAccelerometer());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasGyroscope), deviceModel.hasGyroscope());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasGps), deviceModel.hasGps());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasProximitySensor), deviceModel.hasProximitySensor());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myCustomSkinPath.getComboBox()), deviceModel.customSkinFile());
        SelectedItemProperty selectedDeviceType = new SelectedItemProperty((JComboBox)this.myDeviceTypeComboBox);
        this.myBindings.bindTwoWay(selectedDeviceType, deviceModel.deviceType());
        this.myListeners.listen(selectedDeviceType, idDisplayOptional -> {
            if (idDisplayOptional.isPresent()) {
                IdDisplay selectedType = (IdDisplay)idDisplayOptional.get();
                ((ConfigureDeviceModel)this.getModel()).getDeviceData().isWear().set(selectedType.equals((Object)SystemImage.WEAR_TAG));
                ((ConfigureDeviceModel)this.getModel()).getDeviceData().isTv().set(selectedType.equals((Object)SystemImage.ANDROID_TV_TAG) || selectedType.equals((Object)SystemImage.GOOGLE_TV_TAG));
                ((ConfigureDeviceModel)this.getModel()).getDeviceData().isDesktop().set(selectedType.equals((Object)SystemImage.DESKTOP_TAG));
                this.myIsScreenRound.setEnabled(selectedType.equals((Object)SystemImage.WEAR_TAG));
                this.myIsScreenRound.setSelected((Boolean)((ConfigureDeviceModel)this.getModel()).getDeviceData().isScreenRound().get());
            }
        });
        this.myValidatorPanel.registerTest((ObservableValue)deviceModel.name().isEmpty().not(), "Please write a name for the new device.");
        this.myValidatorPanel.registerTest((ObservableValue)this.myDiagScreenSizeAdapter.inSync().and(deviceModel.diagonalScreenSize().isEqualTo(this.myDiagScreenSizeAdapter)), "Please enter a non-zero positive floating point value for the screen size.");
        this.myValidatorPanel.registerTest((ObservableValue)this.myScreenResWidthAdapter.inSync().and(deviceModel.screenResolutionWidth().isEqualTo(this.myScreenResWidthAdapter)), "Please enter a valid value for the screen width.");
        this.myValidatorPanel.registerTest((ObservableValue)this.myScreenResHeightAdapter.inSync().and(deviceModel.screenResolutionHeight().isEqualTo(this.myScreenResHeightAdapter)), "Please enter a valid value for the screen height.");
        this.myValidatorPanel.registerValidator(deviceModel.ramStorage(), value2 -> value2.getSize() > 0L ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, "Please specify a non-zero amount of RAM."), new ObservableValue[0]);
        this.myValidatorPanel.registerTest((ObservableValue)deviceModel.screenDpi().isGreaterThan(0.0), "The given resolution and screen size specified have a DPI that is too low.");
        this.myValidatorPanel.registerTest((ObservableValue)deviceModel.supportsLandscape().or(deviceModel.supportsPortrait()), "A device must support at least one orientation (Portrait or Landscape).");
        this.myValidatorPanel.registerValidator(deviceModel.customSkinFile(), (Validator)new CustomSkinValidator(), new ObservableValue[0]);
        this.myValidatorPanel.registerTest((ObservableValue)((ConfigureDeviceModel)this.getModel()).getDeviceData().compatibleSkinSize(), Validator.Severity.WARNING, "The selected skin is not large enough to view the entire screen.");
    }

    private void createUIComponents() {
        this.myNavigationControlsCombo = new ComboBox((ComboBoxModel)new EnumComboBoxModel(Navigation.class));
        this.myNavigationControlsCombo.setRenderer(SimpleListCellRenderer.create((String)"", Navigation::getShortDisplayValue));
        this.myHardwareSkinHelpLabel = new BrowserLink("How do I create a custom hardware skin?", "http://developer.android.com/tools/devices/managing-avds.html#skins");
        this.myCustomSkinPath = new SkinChooser(null, false);
        this.myDeviceDefinitionPreview = new DeviceDefinitionPreview(((ConfigureDeviceModel)this.getModel()).getDeviceData());
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TooltipLabel tooltipLabel;
        JCheckBox jCheckBox;
        StorageField storageField;
        JTextField jTextField;
        ComboBox comboBox2;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.setMaximumSize(new Dimension(1280, 768));
        DeviceDefinitionPreview deviceDefinitionPreview = this.myDeviceDefinitionPreview;
        jPanel.add((Component)deviceDefinitionPreview, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(360, -1), null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(28, 2, new Insets(5, 5, 5, 5), -1, 5, false, false));
        jBScrollPane.setViewportView(jPanel2);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Screen");
        jPanel2.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Memory");
        jPanel2.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Cameras");
        jPanel2.add((Component)jBLabel3, new GridConstraints(17, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Sensors");
        jPanel2.add((Component)jBLabel4, new GridConstraints(20, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHasBackFacingCamera = jCheckBox11 = new JCheckBox();
        jCheckBox11.setSelected(true);
        jCheckBox11.setText("Back-facing camera");
        jCheckBox11.setToolTipText("<html>Enables back-facing camera support in emulator</html>");
        jPanel2.add((Component)jCheckBox11, new GridConstraints(17, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHasFrontFacingCamera = jCheckBox10 = new JCheckBox();
        jCheckBox10.setSelected(true);
        jCheckBox10.setText("Front-facing camera");
        jCheckBox10.setToolTipText("<html>Enables front-facing camera support in emulator</html>");
        jPanel2.add((Component)jCheckBox10, new GridConstraints(18, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHasAccelerometer = jCheckBox9 = new JCheckBox();
        jCheckBox9.setSelected(true);
        jCheckBox9.setText("Accelerometer");
        jCheckBox9.setToolTipText("<html>Enables accelerometer support in emulator.</html>");
        jPanel2.add((Component)jCheckBox9, new GridConstraints(20, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHasGyroscope = jCheckBox8 = new JCheckBox();
        jCheckBox8.setSelected(true);
        jCheckBox8.setText("Gyroscope");
        jCheckBox8.setToolTipText("<html>Enables gyroscope support in emulator.</html>");
        jPanel2.add((Component)jCheckBox8, new GridConstraints(21, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHasGps = jCheckBox7 = new JCheckBox();
        jCheckBox7.setSelected(true);
        jCheckBox7.setText("GPS");
        jCheckBox7.setToolTipText("<html>Enables GPS (global positioning support) support in emulator.</html>");
        jPanel2.add((Component)jCheckBox7, new GridConstraints(22, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHasProximitySensor = jCheckBox6 = new JCheckBox();
        jCheckBox6.setSelected(true);
        jCheckBox6.setText("Proximity Sensor");
        jCheckBox6.setToolTipText("<html>Enables proximity sensor support in emulator</html>");
        jPanel2.add((Component)jCheckBox6, new GridConstraints(23, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySupportsLandscape = jCheckBox5 = new JCheckBox();
        jCheckBox5.setSelected(true);
        jCheckBox5.setText("Landscape");
        jCheckBox5.setToolTipText("<html>Enables the landscape device screen state in emulator</html>");
        jPanel2.add((Component)jCheckBox5, new GridConstraints(15, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySupportsPortrait = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(true);
        jCheckBox4.setText("Portrait");
        jCheckBox4.setToolTipText("<html>Enables the portrait device screen state in emulator.</html>");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(14, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("<html>Supported<br>device states</html>");
        jPanel2.add((Component)jBLabel5, new GridConstraints(14, 0, 2, 1, 9, 0, 0, 0, null, null, null));
        this.myHasHardwareKeyboard = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        jCheckBox3.setText("Has Hardware Keyboard");
        jCheckBox3.setToolTipText("<html>Enables hardware keyboard  support in Android Virtual Device.</html>");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(11, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHasHardwareButtons = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Has Hardware Buttons (Back/Home/Menu)");
        jCheckBox2.setToolTipText("<html>Enables hardware navigation button support in Android Virtual Device</html>");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(10, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Input");
        jPanel2.add((Component)jBLabel6, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceName = jTextField4 = new JTextField();
        jTextField4.setToolTipText("<html>Name of the Device Profile</html>");
        jPanel2.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Device Name");
        jPanel2.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(5, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Resolution:");
        jPanel3.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myScreenResolutionWidth = jTextField3 = new JTextField();
        jTextField3.setColumns(5);
        jTextField3.setToolTipText("<html>The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.  Width in pixels </html>");
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("x");
        jPanel3.add((Component)jBLabel9, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myScreenResolutionHeight = jTextField2 = new JTextField();
        jTextField2.setColumns(5);
        jTextField2.setToolTipText("<html>The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.  Height in pixels </html>");
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("px");
        jPanel3.add((Component)jBLabel10, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(24, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 15), new Dimension(-1, 15), null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("Default Skin");
        jPanel2.add((Component)jBLabel11, new GridConstraints(26, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SkinChooser skinChooser = this.myCustomSkinPath;
        ((JComponent)((Object)skinChooser)).setToolTipText("<html>Path to a directory containing a custom skin</html>");
        jPanel2.add((Component)((Object)skinChooser), new GridConstraints(26, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        BrowserLink browserLink = this.myHardwareSkinHelpLabel;
        jPanel2.add((Component)browserLink, new GridConstraints(27, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setText("Device Type");
        jPanel2.add((Component)jBLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceTypeComboBox = comboBox2 = new ComboBox();
        jPanel2.add((Component)comboBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel13 = new JBLabel();
        jBLabel13.setText("inch");
        jPanel4.add((Component)jBLabel13, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myDiagonalScreenSize = jTextField = new JTextField();
        jTextField.setColumns(10);
        jTextField.setToolTipText("<html>Actual Android Virtual Device size of the screen, measured as the screen's diagonal</html>");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel14 = new JBLabel();
        jBLabel14.setText("Screen size:");
        jPanel4.add((Component)jBLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(8, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel15 = new JBLabel();
        jBLabel15.setText("RAM:");
        jPanel5.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRamField = storageField = new StorageField();
        storageField.setToolTipText("<html>The amount of physical RAM on the device.</html>");
        jPanel5.add((Component)storageField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(12, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel16 = new JBLabel();
        jBLabel16.setText("Navigation Style:");
        jPanel6.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myNavigationControlsCombo;
        jComboBox.setToolTipText("<html>No Navigation - No navigational controls  <br>Directional Pad - Enables direction pad support in emulator <br>Trackball - Enables trackball support in emulator</html>");
        jPanel6.add((Component)jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel2.add((Component)jSeparator2, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator3 = new JSeparator();
        jPanel2.add((Component)jSeparator3, new GridConstraints(7, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator4 = new JSeparator();
        jPanel2.add((Component)jSeparator4, new GridConstraints(9, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel2.add((Component)jSeparator5, new GridConstraints(13, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator6 = new JSeparator();
        jPanel2.add((Component)jSeparator6, new GridConstraints(16, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator7 = new JSeparator();
        jPanel2.add((Component)jSeparator7, new GridConstraints(19, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator8 = new JSeparator();
        jPanel2.add((Component)jSeparator8, new GridConstraints(25, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myIsScreenRound = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(false);
        jCheckBox.setSelected(true);
        jCheckBox.setText("Round");
        jCheckBox.setToolTipText("<html>Useful for wear devices with screens that can be round</html>");
        jPanel2.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHelpAndErrorLabel = tooltipLabel = new TooltipLabel();
        tooltipLabel.setOpaque(true);
        tooltipLabel.setVerticalTextPosition(1);
        jPanel.add((Component)tooltipLabel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, new Dimension(-1, 100), new Dimension(360, 100), null));
        jBLabel7.setLabelFor(jTextField4);
        jBLabel8.setLabelFor(jTextField3);
        jBLabel9.setLabelFor(jTextField2);
        jBLabel14.setLabelFor(jTextField);
        jBLabel16.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

