/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.Revision;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.avdmanager.SystemImageList;
import com.android.tools.idea.avdmanager.SystemImageListModel;
import com.android.tools.idea.avdmanager.SystemImagePreview;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.system.CpuArch;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSystemImagePanel
extends JPanel
implements SystemImageList.SystemImageSelectionListener,
SystemImageListModel.StatusIndicator,
Disposable {
    private static final boolean IS_ARM64_HOST_OS = CpuArch.isArm64() || CommonMetricsData.getOsArchitecture() == ProductDetails.CpuArchitecture.X86_ON_ARM;
    private final List<Consumer<SystemImageDescription>> mySystemImageListeners;
    private JPanel myPanel;
    private SystemImageList myRecommendedImageList;
    private SystemImageList myPerformantImageList;
    private SystemImageList myOtherImageList;
    private SystemImagePreview mySystemImagePreview;
    private JBTabbedPane myTabPane;
    private JBLabel myStatusLabel;
    private JButton myRefreshButton;
    private AsyncProcessIcon myAsyncIcon;
    private SystemImageListModel myListModel;
    @Nullable
    private Device myDevice;
    @Nullable
    private SystemImageDescription mySystemImage;

    public void setDevice(@Nullable Device device2) {
        this.myDevice = device2;
        this.myListModel.refreshImages(false);
    }

    public ChooseSystemImagePanel(@Nullable Project project, @Nullable Device initialDevice, @Nullable SystemImageDescription initialSystemImage) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.mySystemImageListeners = Lists.newArrayListWithExpectedSize((int)1);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myPanel);
        this.mySystemImage = initialSystemImage;
        this.myDevice = initialDevice;
        this.myListModel = new SystemImageListModel(project, this);
        this.setupImageLists();
        this.myRefreshButton.setIcon(AllIcons.Actions.Refresh);
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSystemImagePanel.this.myListModel.refreshImages(true);
            }
        });
        this.myTabPane.setTitleAt(1, IS_ARM64_HOST_OS ? AndroidBundle.message("avd.manager.arm.images", new Object[0]) : AndroidBundle.message("avd.manager.x86.images", new Object[0]));
        this.myTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChooseSystemImagePanel.this.previewCurrentTab();
            }
        });
        this.myRecommendedImageList.addSelectionListener(this);
        this.myRecommendedImageList.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        this.myListModel.refreshLocalImagesSynchronously();
        this.myListModel.refreshImages(false);
        this.setSelectedImage(this.mySystemImage);
        this.add(this.myPanel);
    }

    @NotNull
    @VisibleForTesting
    static SystemImageClassification getClassificationForDevice(@NotNull SystemImageDescription image, @Nullable Device theDevice, boolean isArm64HostOs) {
        Abi abi = Abi.getEnum((String)image.getAbiType());
        SystemImageClassification classification = ChooseSystemImagePanel.getClassificationFromParts(abi, image.getVersion(), image.getTag(), isArm64HostOs);
        if (theDevice != null && !image.getTag().equals((Object)SystemImage.WEAR_TAG)) {
            if (theDevice.hasPlayStore()) {
                if (classification == SystemImageClassification.RECOMMENDED && !image.getSystemImage().hasPlayStore()) {
                    classification = abi == Abi.X86 || abi == Abi.X86_64 ? SystemImageClassification.PERFORMANT : SystemImageClassification.OTHER;
                }
            } else if (image.getSystemImage().hasPlayStore()) {
                classification = SystemImageClassification.FORBIDDEN;
            }
        }
        return classification;
    }

    @NotNull
    private SystemImageClassification getClassification(@NotNull SystemImageDescription image) {
        return ChooseSystemImagePanel.getClassificationForDevice(image, this.myDevice, IS_ARM64_HOST_OS);
    }

    @NotNull
    @VisibleForTesting
    static SystemImageClassification getClassificationFromParts(@NotNull Abi abi, @NotNull AndroidVersion androidVersion, @NotNull IdDisplay tag, boolean isArm64HostOs) {
        boolean isAvdArm;
        int apiLevel = androidVersion.getApiLevel();
        boolean isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
        boolean bl = isAvdArm = abi == Abi.ARM64_V8A;
        if (!isAvdArm && !isAvdIntel) {
            return SystemImageClassification.OTHER;
        }
        if (!androidVersion.isBaseExtension() && androidVersion.getExtensionLevel() != null) {
            return isArm64HostOs == isAvdIntel ? SystemImageClassification.OTHER : SystemImageClassification.PERFORMANT;
        }
        if (isAvdIntel == isArm64HostOs) {
            return SystemImageClassification.OTHER;
        }
        if (tag.equals((Object)SystemImage.WEAR_TAG)) {
            return apiLevel >= 25 && (isArm64HostOs || abi == Abi.X86) ? SystemImageClassification.RECOMMENDED : SystemImageClassification.PERFORMANT;
        }
        if (apiLevel < 22) {
            return SystemImageClassification.PERFORMANT;
        }
        if (SystemImageDescription.TAGS_WITH_GOOGLE_API.contains(tag) && (isArm64HostOs || apiLevel <= 30 && abi == Abi.X86 || apiLevel > 30 && abi == Abi.X86_64)) {
            return SystemImageClassification.RECOMMENDED;
        }
        return SystemImageClassification.PERFORMANT;
    }

    public static boolean systemImageMatchesDevice(@Nullable SystemImageDescription image, @Nullable Device device2) {
        Dimension screenSize;
        if (device2 == null || image == null) {
            return false;
        }
        String deviceTagId = device2.getTagId();
        String deviceId = device2.getId();
        IdDisplay imageTag = image.getTag();
        if (device2.getDefaultHardware().getScreen().isFoldable() && image.getVersion().getFeatureLevel() < 29) {
            return false;
        }
        if (deviceId.equals("13.5in Freeform")) {
            if (image.getVersion() == null || image.getVersion().getFeatureLevel() < 30) {
                return false;
            }
            if ("R".equals(image.getVersion().getCodename()) && (image.getRevision() == null || image.getRevision().compareTo(new Revision(2, 0, 0)) <= 0)) {
                return false;
            }
        }
        if ((deviceId.equals("7.6in Foldable") || deviceId.equals("8in Foldable") || deviceId.equals("6.7in Foldable") || deviceId.equals("7.4in Rollable")) && (image.getVersion() == null || image.getVersion().getFeatureLevel() < 30)) {
            return false;
        }
        if (deviceId.equals("pixel_4a") && (image.getVersion() == null || image.getVersion().getFeatureLevel() < 30)) {
            return false;
        }
        if (deviceId.equals("resizable") && (image.getVersion() == null || image.getVersion().getFeatureLevel() < 33)) {
            return false;
        }
        if (deviceTagId == null || deviceTagId.equals(SystemImage.DEFAULT_TAG.getId())) {
            return !imageTag.equals((Object)SystemImage.ANDROID_TV_TAG) && !imageTag.equals((Object)SystemImage.GOOGLE_TV_TAG) && !imageTag.equals((Object)SystemImage.WEAR_TAG) && !imageTag.equals((Object)SystemImage.DESKTOP_TAG) && !imageTag.equals((Object)SystemImage.CHROMEOS_TAG) && !imageTag.equals((Object)SystemImage.AUTOMOTIVE_TAG) && !imageTag.equals((Object)SystemImage.AUTOMOTIVE_PLAY_STORE_TAG);
        }
        if (deviceId.equals("tv_4k") && (image.getVersion() == null || image.getVersion().getFeatureLevel() < 31)) {
            return false;
        }
        if (deviceTagId.equals(SystemImage.ANDROID_TV_TAG.getId()) || deviceTagId.equals(SystemImage.GOOGLE_TV_TAG.getId())) {
            return imageTag.equals((Object)SystemImage.ANDROID_TV_TAG) || imageTag.equals((Object)SystemImage.GOOGLE_TV_TAG);
        }
        if (imageTag.equals((Object)SystemImage.WEAR_TAG) && !device2.isScreenRound() && (screenSize = device2.getScreenSize(ScreenOrientation.PORTRAIT)) != null && screenSize.getWidth() != screenSize.getHeight() && image.getVersion().getFeatureLevel() < 28) {
            return false;
        }
        return deviceTagId.equals(imageTag.getId());
    }

    private void setupImageLists() {
        this.setupImageList(this.myRecommendedImageList);
        this.setupImageList(this.myPerformantImageList);
        this.setupImageList(this.myOtherImageList);
        this.setImageListFilters();
    }

    private void setupImageList(@NotNull SystemImageList list2) {
        list2.setModel(this.myListModel);
        list2.addSelectionListener(this);
        list2.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
    }

    private void setImageListFilters() {
        this.myRecommendedImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.RECOMMENDED));
        this.myPerformantImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.PERFORMANT));
        this.myOtherImageList.setRowFilter(new ClassificationRowFilter(SystemImageClassification.OTHER));
    }

    @Override
    public void onSystemImageSelected(@Nullable SystemImageDescription systemImage) {
        this.mySystemImagePreview.setImage(systemImage);
        this.mySystemImage = systemImage != null && !systemImage.isRemote() ? systemImage : null;
        for (Consumer<SystemImageDescription> listener2 : this.mySystemImageListeners) {
            listener2.consume((Object)this.mySystemImage);
        }
    }

    private void setSelectedImage(@Nullable SystemImageDescription systemImage) {
        if (systemImage != null) {
            SystemImageClassification classification = this.getClassification(systemImage);
            switch (classification) {
                case RECOMMENDED: {
                    this.myRecommendedImageList.setSelectedImage(systemImage);
                    this.myTabPane.setSelectedIndex(0);
                    break;
                }
                case PERFORMANT: {
                    this.myPerformantImageList.setSelectedImage(systemImage);
                    this.myTabPane.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.myOtherImageList.setSelectedImage(systemImage);
                    this.myTabPane.setSelectedIndex(2);
                }
            }
        }
    }

    @Override
    public void onRefreshStart(@NotNull String message2) {
        this.myStatusLabel.setText(message2);
        this.myRefreshButton.setEnabled(false);
        this.myAsyncIcon.setVisible(true);
    }

    @Override
    public void onRefreshDone(@NotNull String message2, boolean partlyDownloaded) {
        this.myStatusLabel.setText(message2);
        this.myRefreshButton.setEnabled(true);
        this.myAsyncIcon.setVisible(false);
        this.myRecommendedImageList.restoreSelection(partlyDownloaded, this.mySystemImage);
        this.myPerformantImageList.restoreSelection(partlyDownloaded, this.mySystemImage);
        this.myOtherImageList.restoreSelection(partlyDownloaded, this.mySystemImage);
        this.previewCurrentTab();
    }

    private void previewCurrentTab() {
        switch (this.myTabPane.getSelectedIndex()) {
            case 0: {
                this.myRecommendedImageList.makeListCurrent();
                if (this.myDevice != null && SystemImage.WEAR_TAG.getId().equals(this.myDevice.getTagId())) {
                    this.mySystemImagePreview.showExplanationForRecommended(SystemImagePreview.ImageRecommendation.RECOMMENDATION_WEAR);
                    break;
                }
                if (this.myDevice != null && this.myDevice.hasPlayStore()) {
                    this.mySystemImagePreview.showExplanationForRecommended(SystemImagePreview.ImageRecommendation.RECOMMENDATION_GOOGLE_PLAY);
                    break;
                }
                this.mySystemImagePreview.showExplanationForRecommended(SystemImagePreview.ImageRecommendation.RECOMMENDATION_X86);
                break;
            }
            case 1: {
                this.myPerformantImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(SystemImagePreview.ImageRecommendation.RECOMMENDATION_NONE);
                break;
            }
            default: {
                this.myOtherImageList.makeListCurrent();
                this.mySystemImagePreview.showExplanationForRecommended(SystemImagePreview.ImageRecommendation.RECOMMENDATION_NONE);
            }
        }
    }

    private void createUIComponents() {
        this.myAsyncIcon = new AsyncProcessIcon("refresh images");
        this.myRecommendedImageList = new SystemImageList();
        this.myPerformantImageList = new SystemImageList();
        this.myOtherImageList = new SystemImageList();
        this.mySystemImagePreview = new SystemImagePreview(this);
    }

    public void addSystemImageListener(@NotNull Consumer<SystemImageDescription> onSystemImageSelected) {
        this.mySystemImageListeners.add(onSystemImageSelected);
        onSystemImageSelected.consume((Object)this.mySystemImage);
    }

    public void dispose() {
        this.mySystemImageListeners.clear();
    }

    @Nullable
    public SystemImageDescription getSystemImage() {
        return this.mySystemImage;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JButton jButton;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabPane = jBTabbedPane = new JBTabbedPane();
        jPanel.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, new Dimension(650, 400), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Recommended", null, jPanel2, null);
        SystemImageList systemImageList = this.myRecommendedImageList;
        jPanel2.add((Component)systemImageList, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Performant Images", null, jPanel3, null);
        SystemImageList systemImageList2 = this.myPerformantImageList;
        jPanel3.add((Component)systemImageList2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Other Images", null, jPanel4, null);
        SystemImageList systemImageList3 = this.myOtherImageList;
        jPanel4.add((Component)systemImageList3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, new Dimension(54, 10), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myRefreshButton = jButton = new JButton();
        jButton.setText("");
        jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStatusLabel = jBLabel = new JBLabel();
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myAsyncIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 1, 2, 1, 0, 2, 1, 3, null, null, null));
        SystemImagePreview systemImagePreview = this.mySystemImagePreview;
        JComponent jComponent = systemImagePreview.$$$getRootComponent$$$();
        jBScrollPane.setViewportView(jComponent);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ClassificationRowFilter
    extends RowFilter<ListTableModel<SystemImageDescription>, Integer> {
        private final SystemImageClassification myClassification;

        public ClassificationRowFilter(SystemImageClassification classification) {
            this.myClassification = classification;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ListTableModel<SystemImageDescription>, ? extends Integer> entry) {
            SystemImageDescription image = (SystemImageDescription)ChooseSystemImagePanel.this.myListModel.getRowValue(entry.getIdentifier());
            return ChooseSystemImagePanel.this.getClassification(image) == this.myClassification && ChooseSystemImagePanel.systemImageMatchesDevice(image, ChooseSystemImagePanel.this.myDevice) && this.versionSupported(image);
        }

        private boolean versionSupported(@NotNull SystemImageDescription image) {
            return image.getVersion().getApiLevel() > 2;
        }
    }

    @VisibleForTesting
    static enum SystemImageClassification {
        RECOMMENDED,
        PERFORMANT,
        OTHER,
        FORBIDDEN;

    }
}

