/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.Slow;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdNameVerifier;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.ChooseDeviceDefinitionStep;
import com.android.tools.idea.avdmanager.ChooseSystemImageStep;
import com.android.tools.idea.avdmanager.ConfigureAvdOptionsStep;
import com.android.tools.idea.avdmanager.DeviceSkinUpdater;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.StudioWizardDialogBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdWizardUtils {
    public static final String WIZARD_ONLY = "AvdManager.WizardOnly.";
    public static final String DEVICE_DEFINITION_KEY = "AvdManager.WizardOnly.DeviceDefinition";
    public static final String SYSTEM_IMAGE_KEY = "AvdManager.WizardOnly.SystemImage";
    public static final String RAM_STORAGE_KEY = "hw.ramSize";
    public static final String VM_HEAP_STORAGE_KEY = "vm.heapSize";
    public static final String INTERNAL_STORAGE_KEY = "disk.dataPartition.size";
    public static final String SD_CARD_STORAGE_KEY = "sdcard.size";
    public static final String EXISTING_SD_LOCATION = "sdcard.path";
    public static final String DISPLAY_SD_SIZE_KEY = "AvdManager.WizardOnly.displaySdCardSize";
    public static final String DISPLAY_SD_LOCATION_KEY = "AvdManager.WizardOnly.displaySdLocation";
    public static final String DISPLAY_USE_EXTERNAL_SD_KEY = "AvdManager.WizardOnly.displayUseExistingSd";
    public static final String DEFAULT_ORIENTATION_KEY = "AvdManager.WizardOnly.DefaultOrientation";
    public static final String AVD_INI_NETWORK_SPEED = "runtime.network.speed";
    public static final String NETWORK_SPEED_KEY = "runtime.network.speed";
    public static final String AVD_INI_NETWORK_LATENCY = "runtime.network.latency";
    public static final String NETWORK_LATENCY_KEY = "runtime.network.latency";
    public static final String FRONT_CAMERA_KEY = "hw.camera.front";
    public static final String BACK_CAMERA_KEY = "hw.camera.back";
    public static final String USE_HOST_GPU_KEY = "hw.gpu.enabled";
    public static final String HOST_GPU_MODE_KEY = "hw.gpu.mode";
    public static final String USE_COLD_BOOT = "fastboot.forceColdBoot";
    public static final String USE_FAST_BOOT = "fastboot.forceFastBoot";
    public static final String USE_CHOSEN_SNAPSHOT_BOOT = "fastboot.forceChosenSnapshotBoot";
    public static final String CHOSEN_SNAPSHOT_FILE = "fastboot.chosenSnapshotFile";
    public static final String IS_IN_EDIT_MODE_KEY = "AvdManager.WizardOnly.isInEditMode";
    public static final String CUSTOM_SKIN_FILE_KEY = "skin.path";
    public static final String BACKUP_SKIN_FILE_KEY = "skin.path.backup";
    public static final String DEVICE_FRAME_KEY = "showDeviceFrame";
    public static final String DISPLAY_NAME_KEY = "avd.ini.displayname";
    public static final String AVD_ID_KEY = "AvdId";
    public static final String CPU_CORES_KEY = "hw.cpu.ncore";
    public static final String HAS_HARDWARE_KEYBOARD_KEY = "hw.keyboard";
    public static final Font STANDARD_FONT = JBFont.create((Font)new Font("DroidSans", 0, 12));
    public static final Font FIGURE_FONT = JBFont.create((Font)new Font("DroidSans", 0, 10));
    public static final Font TITLE_FONT = JBFont.create((Font)new Font("DroidSans", 1, 16));
    public static final List<IdDisplay> ALL_DEVICE_TAGS = ImmutableList.of((Object)SystemImage.DEFAULT_TAG, (Object)SystemImage.WEAR_TAG, (Object)SystemImage.DESKTOP_TAG, (Object)SystemImage.ANDROID_TV_TAG, (Object)SystemImage.GOOGLE_TV_TAG, (Object)SystemImage.CHROMEOS_TAG, (Object)SystemImage.AUTOMOTIVE_TAG);
    public static final String CREATE_SKIN_HELP_LINK = "http://developer.android.com/tools/devices/managing-avds.html#skins";
    @Deprecated
    static final File NO_SKIN = new File("_no_skin");
    private static final Dimension AVD_WIZARD_MIN_SIZE = JBUI.size((int)600, (int)400);
    private static final Dimension AVD_WIZARD_SIZE = JBUI.size((int)1000, (int)650);
    private static final String AVD_WIZARD_HELP_URL = "https://developer.android.com/r/studio-ui/avd-manager.html";
    private static final int MAX_RAM_MB = 1536;
    private static final Revision MIN_SNAPSHOT_MANAGEMENT_VERSION = new Revision(27, 2, 5);
    private static final Revision MIN_WEBP_VERSION = new Revision(25, 2, 3);

    @NotNull
    public static Storage getDefaultRam(@NotNull Hardware hardware) {
        return AvdWizardUtils.getMaxPossibleRam(hardware.getRam());
    }

    @NotNull
    public static Storage getMaxPossibleRam() {
        return new Storage(1536L, Storage.Unit.MiB);
    }

    @NotNull
    private static Storage getMaxPossibleRam(Storage ram) {
        if (ram.getSizeAsUnit(Storage.Unit.MiB) >= 1536L) {
            return new Storage(1536L, Storage.Unit.MiB);
        }
        return ram;
    }

    public static int getMaxCpuCores() {
        return Runtime.getRuntime().availableProcessors() / 2;
    }

    public static String cleanAvdName(@NotNull AvdManagerConnection connection2, @NotNull String candidateBase, boolean uniquify) {
        if ((candidateBase = AvdNameVerifier.stripBadCharactersAndCollapse(candidateBase)).isEmpty()) {
            candidateBase = "myavd";
        }
        String candidate = candidateBase;
        if (uniquify) {
            int i = 1;
            while (connection2.avdExists(candidate)) {
                candidate = String.format(Locale.US, "%1$s_%2$d", candidateBase, i++);
            }
        }
        return candidate;
    }

    @Deprecated
    @Slow
    @Nullable
    public static File pathToUpdatedSkins(@Nullable Path device2, @Nullable SystemImageDescription image) {
        return device2 == null ? null : DeviceSkinUpdater.updateSkins(device2, image).toFile();
    }

    static boolean emulatorSupportsWebp(@NotNull AndroidSdkHandler sdkHandler) {
        return AvdWizardUtils.emulatorVersionIsAtLeast(sdkHandler, MIN_WEBP_VERSION);
    }

    static boolean emulatorSupportsSnapshotManagement(@NotNull AndroidSdkHandler sdkHandler) {
        return AvdWizardUtils.emulatorVersionIsAtLeast(sdkHandler, MIN_SNAPSHOT_MANAGEMENT_VERSION);
    }

    private static boolean emulatorVersionIsAtLeast(@NotNull AndroidSdkHandler sdkHandler, Revision minRevision) {
        StudioLoggerProgressIndicator log = new StudioLoggerProgressIndicator(AvdWizardUtils.class);
        LocalPackage sdkPackage = sdkHandler.getLocalPackage("emulator", (ProgressIndicator)log);
        if (sdkPackage != null) {
            return sdkPackage.getVersion().compareTo(minRevision) >= 0;
        }
        return false;
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent2, @Nullable Project project) {
        return AvdWizardUtils.createAvdWizard(parent2, project, new AvdOptionsModel(null));
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent2, @Nullable Project project, @Nullable AvdInfo avdInfo) {
        return AvdWizardUtils.createAvdWizard(parent2, project, new AvdOptionsModel(avdInfo));
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent2, @Nullable Project project, @NotNull AvdOptionsModel model2) {
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        if (!((Boolean)model2.isInEditMode().get()).booleanValue()) {
            wizardBuilder.addStep(new ChooseDeviceDefinitionStep(model2));
            wizardBuilder.addStep(new ChooseSystemImageStep(model2, project));
        }
        wizardBuilder.addStep(new ConfigureAvdOptionsStep(project, model2));
        ModelWizard wizard = wizardBuilder.build();
        StudioWizardDialogBuilder builder2 = new StudioWizardDialogBuilder(wizard, "Virtual Device Configuration", parent2);
        builder2.setMinimumSize(AVD_WIZARD_MIN_SIZE);
        builder2.setPreferredSize(AVD_WIZARD_SIZE);
        return builder2.setHelpUrl(AvdWizardUtils.toUrl(AVD_WIZARD_HELP_URL)).build();
    }

    @NotNull
    private static URL toUrl(@NotNull String urlAsString) {
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public static ModelWizardDialog createAvdWizardForDuplication(@Nullable Component parent2, @Nullable Project project, @NotNull AvdOptionsModel avdOptions) {
        avdOptions.setAsCopy();
        return AvdWizardUtils.createAvdWizard(parent2, project, avdOptions);
    }
}

