/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdScreenData {
    private AvdDeviceData myDeviceData;

    public AvdScreenData(AvdDeviceData deviceData) {
        this.myDeviceData = deviceData;
    }

    public static double calculateDpi(double screenResolutionWidth, double screenResolutionHeight, double diagonalScreenSize, boolean isRound) {
        double diagonalPixelResolution = isRound ? screenResolutionWidth : Math.sqrt(Math.pow(screenResolutionWidth, 2.0) + Math.pow(screenResolutionHeight, 2.0));
        return diagonalPixelResolution / diagonalScreenSize;
    }

    @NotNull
    public static ScreenRatio getScreenRatio(int width, int height) {
        int shortSide;
        int longSide = Math.max(width, height);
        if ((double)longSide / (double)(shortSide = Math.min(width, height)) >= 1.6666666666666667) {
            return ScreenRatio.LONG;
        }
        return ScreenRatio.NOTLONG;
    }

    @NotNull
    public static Density getScreenDensity(@Nullable String deviceId, boolean isTv, double dpi, int screenHeight) {
        if (isTv) {
            return screenHeight <= 720 ? Density.TV : Density.XHIGH;
        }
        Density specialDensity = AvdScreenData.specialDeviceDensity(deviceId);
        if (specialDensity != null) {
            return specialDensity;
        }
        Density bucket = Density.MEDIUM;
        double minDifference = Double.MAX_VALUE;
        for (Density bucketDensity : Density.values()) {
            double difference;
            if (!bucketDensity.isValidValueForDevice() || !bucketDensity.isRecommended() || !((difference = Math.abs((double)bucketDensity.getDpiValue() - dpi)) < minDifference)) continue;
            minDifference = difference;
            bucket = bucketDensity;
        }
        return bucket;
    }

    @Nullable
    private static Density specialDeviceDensity(@Nullable String deviceId) {
        if ("Nexus 5X".equals(deviceId)) {
            return Density.DPI_420;
        }
        if ("Nexus 6".equals(deviceId)) {
            return Density.DPI_560;
        }
        if ("Nexus 6P".equals(deviceId)) {
            return Density.DPI_560;
        }
        if ("pixel".equals(deviceId)) {
            return Density.DPI_420;
        }
        if ("pixel_xl".equals(deviceId)) {
            return Density.DPI_560;
        }
        if ("pixel 2".equals(deviceId)) {
            return Density.DPI_420;
        }
        if ("pixel_2_xl".equals(deviceId)) {
            return Density.DPI_560;
        }
        return null;
    }

    @NotNull
    public Screen createScreen() {
        double screenDiagonal;
        Screen screen = new Screen();
        screen.setMultitouch(Multitouch.JAZZ_HANDS);
        screen.setMechanism(TouchScreen.FINGER);
        screen.setScreenType(ScreenType.CAPACITIVE);
        screen.setScreenRound((Boolean)this.myDeviceData.isScreenRound().get() != false ? ScreenRound.ROUND : ScreenRound.NOTROUND);
        int screenWidth = (Integer)this.myDeviceData.screenResolutionWidth().get();
        int screenHeight = (Integer)this.myDeviceData.screenResolutionHeight().get();
        double effectiveDiagonal = screenDiagonal = ((Double)this.myDeviceData.diagonalScreenSize().get()).doubleValue();
        if (((Boolean)this.myDeviceData.isScreenRound().get()).booleanValue()) {
            effectiveDiagonal *= Math.sqrt(2.0);
        }
        screen.setDiagonalLength(screenDiagonal);
        screen.setSize(ScreenSize.getScreenSize((Double)effectiveDiagonal));
        screen.setXDimension(screenWidth);
        screen.setYDimension(screenHeight);
        screen.setFoldedXOffset(((Integer)this.myDeviceData.screenFoldedXOffset().get()).intValue());
        screen.setFoldedYOffset(((Integer)this.myDeviceData.screenFoldedYOffset().get()).intValue());
        screen.setFoldedWidth(((Integer)this.myDeviceData.screenFoldedWidth().get()).intValue());
        screen.setFoldedHeight(((Integer)this.myDeviceData.screenFoldedHeight().get()).intValue());
        screen.setFoldedXOffset2(((Integer)this.myDeviceData.screenFoldedXOffset2().get()).intValue());
        screen.setFoldedYOffset2(((Integer)this.myDeviceData.screenFoldedYOffset2().get()).intValue());
        screen.setFoldedWidth2(((Integer)this.myDeviceData.screenFoldedWidth2().get()).intValue());
        screen.setFoldedHeight2(((Integer)this.myDeviceData.screenFoldedHeight2().get()).intValue());
        screen.setFoldedXOffset3(((Integer)this.myDeviceData.screenFoldedXOffset3().get()).intValue());
        screen.setFoldedYOffset3(((Integer)this.myDeviceData.screenFoldedYOffset3().get()).intValue());
        screen.setFoldedWidth3(((Integer)this.myDeviceData.screenFoldedWidth3().get()).intValue());
        screen.setFoldedHeight3(((Integer)this.myDeviceData.screenFoldedHeight3().get()).intValue());
        screen.setRatio(AvdScreenData.getScreenRatio(screenWidth, screenHeight));
        double dpi = (Double)this.myDeviceData.screenDpi().get();
        if (dpi <= 0.0) {
            dpi = AvdScreenData.calculateDpi(screenWidth, screenHeight, screenDiagonal, (Boolean)this.myDeviceData.isScreenRound().get());
        }
        dpi = (double)Math.round(dpi * 100.0) / 100.0;
        screen.setYdpi(dpi);
        screen.setXdpi(dpi);
        screen.setPixelDensity((Density)this.myDeviceData.density().get());
        return screen;
    }
}

