/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.IDevice;
import com.android.io.CancellableFileIo;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdIsAlreadyRunningException;
import com.android.tools.idea.avdmanager.AvdLaunchListener;
import com.android.tools.idea.avdmanager.DeviceSkinUpdater;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.avdmanager.EmulatorConnectionListener;
import com.android.tools.idea.avdmanager.EmulatorRunner;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.avdmanager.emulatorcommand.BootWithSnapshotEmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.ColdBootEmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.ColdBootNowEmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.DefaultEmulatorCommandBuilderFactory;
import com.android.tools.idea.avdmanager.emulatorcommand.EmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.EmulatorCommandBuilderFactory;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeAvdManagers;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.utils.ILogger;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class AvdManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG);
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AvdManagerConnection.class);
    private static final AvdManagerConnection NULL_CONNECTION = new AvdManagerConnection(null, null);
    private static final int MNC_API_LEVEL_23 = 23;
    private static final int LMP_MR1_API_LEVEL_22 = 22;
    private static final String INTERNAL_STORAGE_KEY = "disk.dataPartition.size";
    private static final String SD_CARD_STORAGE_KEY = "sdcard.size";
    public static final String AVD_INI_HW_LCD_DENSITY = "hw.lcd.density";
    public static final Revision TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"25.0.0 rc1");
    public static final Revision TOOLS_REVISION_25_0_2_RC3 = Revision.parseRevision((String)"25.0.2 rc3");
    public static final Revision PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"23.1.0");
    protected static final Revision EMULATOR_REVISION_SUPPORTS_STUDIO_PARAMS = Revision.parseRevision((String)"26.1.0");
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENDENCY_WITH_FIRST_QEMU2 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 2), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 2), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 6), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 10)};
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENDENCY_WITH_25_0_2_RC3 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 4), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 4), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 8), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 12)};
    private static final Map<Path, AvdManagerConnection> ourAvdCache = new WeakHashMap<Path, AvdManagerConnection>();
    @NotNull
    private static final @NotNull Map<@NotNull Path, @NotNull AvdManagerConnection> ourGradleAvdCache = new WeakHashMap<Path, AvdManagerConnection>();
    private static long ourMemorySize = -1L;
    @NotNull
    private static @NotNull BiFunction<@Nullable AndroidSdkHandler, @Nullable Path, @NotNull AvdManagerConnection> ourConnectionFactory = AvdManagerConnection::new;
    @Nullable
    private static Map<String, HardwareProperties.HardwareProperty> ourHardwareProperties;
    @Nullable
    private final AndroidSdkHandler mySdkHandler;
    @NotNull
    private final ListeningExecutorService myEdtListeningExecutorService;
    @Nullable
    private AvdManager myAvdManager;
    @Nullable
    private final Path myAvdHomeFolder;

    @NotNull
    public static AvdManagerConnection getDefaultAvdManagerConnection() {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        if (handler2.getLocation() == null) {
            return NULL_CONNECTION;
        }
        return AvdManagerConnection.getAvdManagerConnection(handler2);
    }

    @NotNull
    public static synchronized AvdManagerConnection getAvdManagerConnection(@NotNull AndroidSdkHandler handler2) {
        Path sdkPath = handler2.getLocation();
        return ourAvdCache.computeIfAbsent(sdkPath, path2 -> {
            try {
                return ourConnectionFactory.apply(handler2, AndroidLocationsSingleton.INSTANCE.getAvdLocation());
            }
            catch (AndroidLocationsException e) {
                IJ_LOG.warn((Throwable)e);
                return NULL_CONNECTION;
            }
        });
    }

    @NotNull
    public static synchronized AvdManagerConnection getDefaultGradleAvdManagerConnection() {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        if (handler2.getLocation() == null) {
            return NULL_CONNECTION;
        }
        return AvdManagerConnection.getGradleAvdManagerConnection(handler2);
    }

    @NotNull
    public static synchronized AvdManagerConnection getGradleAvdManagerConnection(@NotNull AndroidSdkHandler handler2) {
        Path sdkPath = handler2.getLocation();
        return ourGradleAvdCache.computeIfAbsent(sdkPath, path2 -> {
            try {
                return ourConnectionFactory.apply(handler2, AndroidLocationsSingleton.INSTANCE.getGradleAvdLocation());
            }
            catch (AndroidLocationsException e) {
                IJ_LOG.warn((Throwable)e);
                return NULL_CONNECTION;
            }
        });
    }

    private AvdManagerConnection(@Nullable AndroidSdkHandler sdkHandler, @Nullable Path avdHomeFolder) {
        this(sdkHandler, avdHomeFolder, MoreExecutors.listeningDecorator((ExecutorService)EdtExecutorService.getInstance()));
    }

    @VisibleForTesting
    public AvdManagerConnection(@Nullable AndroidSdkHandler sdkHandler, @Nullable Path avdHomeFolder, @NotNull ListeningExecutorService edtListeningExecutorService) {
        this.mySdkHandler = sdkHandler;
        this.myEdtListeningExecutorService = edtListeningExecutorService;
        this.myAvdHomeFolder = avdHomeFolder;
    }

    @VisibleForTesting
    protected static synchronized void setConnectionFactory(@NotNull @NotNull BiFunction<@Nullable AndroidSdkHandler, @Nullable Path, @NotNull AvdManagerConnection> factory2) {
        ourAvdCache.clear();
        ourGradleAvdCache.clear();
        ourConnectionFactory = factory2;
    }

    @VisibleForTesting
    protected static void resetConnectionFactory() {
        AvdManagerConnection.setConnectionFactory(AvdManagerConnection::new);
    }

    private boolean initIfNecessary() {
        if (this.myAvdManager == null) {
            if (this.mySdkHandler == null) {
                IJ_LOG.warn("No Android SDK Found");
                return false;
            }
            if (this.myAvdHomeFolder == null) {
                IJ_LOG.warn("No AVD Home Folder");
                return false;
            }
            try {
                this.myAvdManager = IdeAvdManagers.INSTANCE.getAvdManager(this.mySdkHandler, this.myAvdHomeFolder);
            }
            catch (AndroidLocationsException e) {
                IJ_LOG.error((Throwable)e);
                return false;
            }
            return this.myAvdManager != null;
        }
        return true;
    }

    @Nullable
    public String getSdCardSizeFromHardwareProperties() {
        assert (this.mySdkHandler != null);
        return this.getHardwarePropertyDefaultValue(SD_CARD_STORAGE_KEY, this.mySdkHandler);
    }

    @Nullable
    public String getInternalStorageSizeFromHardwareProperties() {
        assert (this.mySdkHandler != null);
        return this.getHardwarePropertyDefaultValue(INTERNAL_STORAGE_KEY, this.mySdkHandler);
    }

    @Nullable
    private String getHardwarePropertyDefaultValue(@NotNull String name, @Nullable AndroidSdkHandler sdkHandler) {
        LocalPackage emulatorPackage;
        if (ourHardwareProperties == null && sdkHandler != null && (emulatorPackage = sdkHandler.getLocalPackage("emulator", (ProgressIndicator)new StudioLoggerProgressIndicator(AvdManagerConnection.class))) != null) {
            Path hardwareDefs = emulatorPackage.getLocation().resolve("lib" + File.separator + "hardware-properties.ini");
            ourHardwareProperties = HardwareProperties.parseHardwareDefinitions((IAbstractFile)new PathFileWrapper(hardwareDefs), (ILogger)new LogWrapper(Logger.getInstance(AvdManagerConnection.class)));
        }
        HardwareProperties.HardwareProperty hwProp = ourHardwareProperties == null ? null : ourHardwareProperties.get(name);
        return hwProp == null ? null : hwProp.getDefault();
    }

    @Nullable
    private Path getBinaryLocation(@NotNull String filename) {
        assert (this.mySdkHandler != null);
        LocalPackage sdkPackage = this.mySdkHandler.getLocalPackage("emulator", REPO_LOG);
        if (sdkPackage == null) {
            return null;
        }
        Path binaryFile = sdkPackage.getLocation().resolve(filename);
        if (CancellableFileIo.notExists((Path)binaryFile, (LinkOption[])new LinkOption[0])) {
            return null;
        }
        return binaryFile;
    }

    @Nullable
    public Path getEmulatorBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR);
    }

    @Nullable
    public Path getEmulatorCheckBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR_CHECK);
    }

    @Nullable
    private SystemImageUpdateDependency[] getSystemImageUpdateDependencies() {
        assert (this.mySdkHandler != null);
        LocalPackage info2 = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("emulator");
        if (info2 == null) {
            return null;
        }
        if (info2.getVersion().compareTo(TOOLS_REVISION_25_0_2_RC3) >= 0) {
            return SYSTEM_IMAGE_DEPENDENCY_WITH_25_0_2_RC3;
        }
        if (info2.getVersion().compareTo(TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0) {
            return SYSTEM_IMAGE_DEPENDENCY_WITH_FIRST_QEMU2;
        }
        return null;
    }

    private boolean hasQEMU2Installed() {
        return this.getSystemImageUpdateDependencies() != null;
    }

    private boolean hasPlatformToolsForQEMU2Installed() {
        assert (this.mySdkHandler != null);
        LocalPackage info2 = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("platform-tools");
        if (info2 == null) {
            return false;
        }
        return info2.getVersion().compareTo(PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0;
    }

    private boolean hasSystemImagesForQEMU2Installed() {
        return this.getSystemImageUpdates().isEmpty();
    }

    @NotNull
    public List<String> getSystemImageUpdates() {
        ArrayList<String> requested = new ArrayList<String>();
        SystemImageUpdateDependency[] dependencies2 = this.getSystemImageUpdateDependencies();
        if (dependencies2 == null) {
            return requested;
        }
        assert (this.mySdkHandler != null);
        block0: for (SystemImage systemImage : this.mySdkHandler.getSystemImageManager(REPO_LOG).getImages()) {
            for (SystemImageUpdateDependency dependency : dependencies2) {
                if (!dependency.updateRequired(systemImage)) continue;
                requested.add(systemImage.getPackage().getPath());
                continue block0;
            }
        }
        return requested;
    }

    @Slow
    @NotNull
    public List<AvdInfo> getAvds(boolean forceRefresh) {
        if (!this.initIfNecessary()) {
            return ImmutableList.of();
        }
        if (forceRefresh) {
            try {
                assert (this.myAvdManager != null);
                this.myAvdManager.reloadAvds();
            }
            catch (AndroidLocationsException e) {
                IJ_LOG.error("Could not find Android SDK!", (Throwable)e);
            }
        }
        assert (this.myAvdManager != null);
        ArrayList avds = Lists.newArrayList((Object[])this.myAvdManager.getAllAvds());
        boolean needsRefresh = false;
        for (AvdInfo avd : avds) {
            if (avd.getStatus() != AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED) continue;
            this.updateDeviceChanged(avd);
            needsRefresh = true;
        }
        if (needsRefresh) {
            return this.getAvds(true);
        }
        return avds;
    }

    @Slow
    public boolean deleteAvd(@NotNull AvdInfo info2) {
        if (!this.initIfNecessary()) {
            return false;
        }
        assert (this.myAvdManager != null);
        return this.myAvdManager.deleteAvd(info2);
    }

    @Slow
    public boolean isAvdRunning(@NotNull AvdInfo avd) {
        if (!this.initIfNecessary()) {
            return false;
        }
        assert (this.myAvdManager != null);
        Optional<Boolean> online = this.myAvdManager.getPid(avd).stream().mapToObj(ProcessHandle::of).flatMap(Optional::stream).map(ProcessHandle::isAlive).findFirst();
        return online.orElseGet(() -> {
            SDK_LOG.warning("Unable to determine if " + avd.getName() + " is online, assuming it's not", new Object[0]);
            return false;
        });
    }

    @NotNull
    public @NotNull ListenableFuture<@NotNull Boolean> isAvdRunningAsync(@NotNull AvdInfo info2) {
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService());
        return service.submit(() -> this.isAvdRunning(info2));
    }

    public final @NotNull ListenableFuture<@Nullable Void> stopAvdAsync(@NotNull AvdInfo avd) {
        return Futures.submit(() -> this.stopAvd(avd), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Slow
    public void stopAvd(@NotNull AvdInfo info2) {
        assert (this.myAvdManager != null);
        this.myAvdManager.stopAvd(info2);
    }

    @NotNull
    public @NotNull ListenableFuture<@NotNull IDevice> coldBoot(@NotNull Project project, @NotNull AvdInfo avd) {
        return this.startAvd(project, avd, ColdBootEmulatorCommandBuilder::new);
    }

    @NotNull
    public @NotNull ListenableFuture<@NotNull IDevice> quickBoot(@NotNull Project project, @NotNull AvdInfo avd) {
        return this.startAvd(project, avd, EmulatorCommandBuilder::new);
    }

    @NotNull
    public @NotNull ListenableFuture<@NotNull IDevice> bootWithSnapshot(@NotNull Project project, @NotNull AvdInfo avd, @NotNull String snapshot) {
        return this.startAvd(project, avd, (emulator, a) -> new BootWithSnapshotEmulatorCommandBuilder(emulator, a, snapshot));
    }

    @NotNull
    public @NotNull ListenableFuture<@NotNull IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info2) {
        return this.startAvd(project, info2, new DefaultEmulatorCommandBuilderFactory());
    }

    @NotNull
    public @NotNull ListenableFuture<@NotNull IDevice> startAvdWithColdBoot(@Nullable Project project, @NotNull AvdInfo info2) {
        return this.startAvd(project, info2, ColdBootNowEmulatorCommandBuilder::new);
    }

    @NotNull
    public @NotNull ListenableFuture<@NotNull IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info2, @NotNull EmulatorCommandBuilderFactory factory2) {
        if (!this.initIfNecessary()) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("No Android SDK Found"));
        }
        assert (this.mySdkHandler != null);
        String skinPath = (String)info2.getProperties().get("skin.path");
        if (skinPath != null) {
            DeviceSkinUpdater.updateSkins(this.mySdkHandler.toCompatiblePath(skinPath), null);
        }
        return Futures.transformAsync(this.checkAccelerationAsync(), code -> this.continueToStartAvdIfAccelerationErrorIsNotBlocking((AccelerationErrorCode)((Object)code), project, info2, factory2), (Executor)MoreExecutors.directExecutor());
    }

    @NotNull
    private ListenableFuture<IDevice> continueToStartAvdIfAccelerationErrorIsNotBlocking(@NotNull AccelerationErrorCode code, @Nullable Project project, @NotNull AvdInfo info2, @NotNull EmulatorCommandBuilderFactory factory2) {
        switch (code) {
            case ALREADY_INSTALLED: {
                return this.continueToStartAvd(project, info2, factory2);
            }
            case TOOLS_UPDATE_REQUIRED: 
            case PLATFORM_TOOLS_UPDATE_ADVISED: 
            case SYSTEM_IMAGE_UPDATE_ADVISED: {
                return this.continueToStartAvd(project, info2, factory2);
            }
            case NO_EMULATOR_INSTALLED: {
                return this.handleAccelerationError(project, info2, code);
            }
        }
        Abi abi = Abi.getEnum((String)info2.getAbiType());
        if (abi == null) {
            return this.continueToStartAvd(project, info2, factory2);
        }
        if (abi.equals((Object)Abi.X86) || abi.equals((Object)Abi.X86_64)) {
            return this.handleAccelerationError(project, info2, code);
        }
        return this.continueToStartAvd(project, info2, factory2);
    }

    @NotNull
    private ListenableFuture<IDevice> continueToStartAvd(@Nullable Project project, @NotNull AvdInfo avd, @NotNull EmulatorCommandBuilderFactory factory2) {
        ProcessHandler processHandler2;
        Path emulatorBinary = this.getEmulatorBinary();
        if (emulatorBinary == null) {
            IJ_LOG.error("No emulator binary found!");
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("No emulator binary found"));
        }
        avd = this.reloadAvd(avd);
        String avdName = avd.getDisplayName();
        assert (this.myAvdManager != null);
        if (this.myAvdManager.isAvdRunning(avd)) {
            this.myAvdManager.logRunningAvdInfo(avd);
            return Futures.immediateFailedFuture((Throwable)new AvdIsAlreadyRunningException(avd));
        }
        GeneralCommandLine commandLine = this.newEmulatorCommand(project, emulatorBinary, avd, factory2);
        EmulatorRunner runner = new EmulatorRunner(commandLine, avd);
        try {
            processHandler2 = runner.start();
        }
        catch (ExecutionException e) {
            IJ_LOG.error("Error launching emulator", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(String.format("Error launching emulator %1$s", avdName), e));
        }
        BackgroundableProcessIndicator p = this.hasQEMU2Installed() ? new BackgroundableProcessIndicator(project, "Launching emulator", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false) : new ProgressWindow(false, true, project);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> AvdManagerConnection.lambda$continueToStartAvd$7((ProgressWindow)p, processHandler2));
        MessageBus messageBus = project != null ? project.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
        ((AvdLaunchListener)messageBus.syncPublisher(AvdLaunchListener.TOPIC)).avdLaunched(avd, commandLine, project);
        return EmulatorConnectionListener.getDeviceForEmulator(project, avd.getName(), processHandler2, 5L, TimeUnit.MINUTES);
    }

    @NotNull
    protected GeneralCommandLine newEmulatorCommand(@Nullable Project project, @NotNull Path emulator, @NotNull AvdInfo avd, @NotNull EmulatorCommandBuilderFactory factory2) {
        StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(AvdManagerConnection.class);
        LogWrapper logger2 = new LogWrapper(Logger.getInstance(AvdManagerConnection.class));
        Optional<Collection> params2 = Optional.ofNullable(System.getenv("studio.emu.params")).map(arg_0 -> ((Splitter)Splitter.on((char)',')).splitToList(arg_0));
        return factory2.newEmulatorCommandBuilder(emulator, avd).setAvdHome(this.myAvdManager.getBaseAvdFolder()).setEmulatorSupportsSnapshots(EmulatorAdvFeatures.emulatorSupportsFastBoot(this.mySdkHandler, (ProgressIndicator)indicator, (ILogger)logger2)).setStudioParams(this.writeParameterFile().orElse(null)).setLaunchInToolWindow(AvdManagerConnection.shouldLaunchInToolWindow(project)).addAllStudioEmuParams(params2.orElse(Collections.emptyList())).build();
    }

    private static boolean shouldLaunchInToolWindow(@Nullable Project project) {
        return EmulatorSettings.getInstance().getLaunchInToolWindow() && project != null && ToolWindowManager.getInstance((Project)project).getToolWindow("Running Devices") != null;
    }

    public static boolean isFoldable(@NotNull AvdInfo avd) {
        String displayRegionWidth = avd.getProperty("hw.displayRegion.0.1.width");
        return displayRegionWidth != null && !"0".equals(displayRegionWidth);
    }

    public boolean emulatorVersionIsAtLeast(@NotNull Revision desired) {
        if (this.mySdkHandler == null) {
            return false;
        }
        StudioLoggerProgressIndicator log = new StudioLoggerProgressIndicator(AvdManagerConnection.class);
        LocalPackage sdkPackage = this.mySdkHandler.getLocalPackage("emulator", (ProgressIndicator)log);
        if (sdkPackage == null) {
            return false;
        }
        return sdkPackage.getVersion().compareTo(desired) >= 0;
    }

    @NotNull
    private @NotNull Optional<@NotNull Path> writeParameterFile() {
        if (!this.emulatorVersionIsAtLeast(EMULATOR_REVISION_SUPPORTS_STUDIO_PARAMS)) {
            return Optional.empty();
        }
        HttpConfigurable httpInstance = HttpConfigurable.getInstance();
        if (httpInstance == null) {
            return Optional.empty();
        }
        ArrayList<String> proxyParameters = new ArrayList<String>();
        List myPropList = httpInstance.getJvmProperties(false, null);
        for (Pair kv : myPropList) {
            switch ((String)kv.getFirst()) {
                case "http.proxyHost": 
                case "http.proxyPort": 
                case "https.proxyHost": 
                case "https.proxyPort": 
                case "proxy.authentication.username": 
                case "proxy.authentication.password": {
                    proxyParameters.add((String)kv.getFirst() + "=" + (String)kv.getSecond() + "\n");
                    break;
                }
            }
        }
        if (proxyParameters.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(AvdManagerConnection.writeTempFile(proxyParameters)).map(File::getAbsoluteFile).map(File::toPath);
    }

    @Nullable
    public static File tempFileDirectory() {
        String androidSdkRootValue = System.getenv("ANDROID_SDK_ROOT");
        if (androidSdkRootValue == null) {
            androidSdkRootValue = System.getProperty("user.home");
        }
        File tempDir = new File(androidSdkRootValue, "temp");
        tempDir.mkdirs();
        if (!tempDir.exists()) {
            return null;
        }
        return tempDir;
    }

    @Nullable
    public static File writeTempFile(@NotNull List<String> fileContents) {
        File tempFile;
        block4: {
            tempFile = null;
            try {
                File tempDir = AvdManagerConnection.tempFileDirectory();
                if (tempDir == null) {
                    return null;
                }
                tempFile = FileUtil.createTempFile((File)tempDir, (String)"emu", (String)".tmp", (boolean)true);
                tempFile.deleteOnExit();
                if (!tempFile.setReadable(false, false) || !tempFile.setReadable(true, true)) {
                    IJ_LOG.warn("Error setting permissions for " + tempFile.getAbsolutePath());
                }
                Files.write(tempFile.toPath(), fileContents, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                if (tempFile == null) break block4;
                tempFile.delete();
                tempFile = null;
            }
        }
        return tempFile;
    }

    @NotNull
    private ListenableFuture<IDevice> handleAccelerationError(@Nullable Project project, @NotNull AvdInfo info2, @NotNull AccelerationErrorCode code) {
        if (code.getSolution().equals((Object)AccelerationErrorSolution.SolutionCode.NONE)) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(code.getProblem() + "\n\n" + code.getSolutionMessage() + "\n"));
        }
        return Futures.transformAsync(this.showAccelerationErrorDialog(code, project), result2 -> this.tryFixingAccelerationError((int)result2, project, info2, code), (Executor)MoreExecutors.directExecutor());
    }

    @NotNull
    private ListenableFuture<Integer> showAccelerationErrorDialog(@NotNull AccelerationErrorCode code, @Nullable Project project) {
        return this.myEdtListeningExecutorService.submit(() -> {
            String message2 = (SystemInfo.isLinux ? "KVM" : "Intel HAXM") + " is required to run this AVD.\n" + code.getProblem() + "\n\n" + code.getSolutionMessage() + "\n";
            return Messages.showOkCancelDialog((Project)project, (String)message2, (String)code.getSolution().getDescription(), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)AllIcons.General.WarningDialog);
        });
    }

    @NotNull
    private ListenableFuture<IDevice> tryFixingAccelerationError(int result2, @Nullable Project project, @NotNull AvdInfo info2, @NotNull AccelerationErrorCode code) {
        if (result2 == 2) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Could not start AVD"));
        }
        SettableFuture future2 = SettableFuture.create();
        Runnable setFuture = () -> future2.setFuture(this.startAvd(project, info2));
        Runnable setException = () -> future2.setException((Throwable)new RuntimeException("Retry after fixing problem by hand"));
        ApplicationManager.getApplication().invokeLater(AccelerationErrorSolution.getActionForFix(code, project, setFuture, setException));
        return future2;
    }

    public AccelerationErrorCode checkAcceleration() {
        int exitValue2;
        if (!this.initIfNecessary()) {
            return AccelerationErrorCode.UNKNOWN_ERROR;
        }
        Path emulatorBinary = this.getEmulatorBinary();
        if (emulatorBinary == null) {
            return AccelerationErrorCode.NO_EMULATOR_INSTALLED;
        }
        if (AvdManagerConnection.getMemorySize() < Storage.Unit.GiB.getNumberOfBytes()) {
            return AccelerationErrorCode.NOT_ENOUGH_MEMORY;
        }
        if (!this.hasQEMU2Installed()) {
            return AccelerationErrorCode.TOOLS_UPDATE_REQUIRED;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        Path checkBinary = this.getEmulatorCheckBinary();
        if (checkBinary != null) {
            commandLine.setExePath(checkBinary.toString());
            commandLine.addParameter("accel");
        } else {
            commandLine.setExePath(emulatorBinary.toString());
            commandLine.addParameter("-accel-check");
        }
        try {
            CapturingAnsiEscapesAwareProcessHandler process2 = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            ProcessOutput output = process2.runProcess();
            exitValue2 = output.getExitCode();
        }
        catch (ExecutionException e) {
            exitValue2 = AccelerationErrorCode.UNKNOWN_ERROR.getErrorCode();
        }
        if (exitValue2 != 0) {
            return AccelerationErrorCode.fromExitCode(exitValue2);
        }
        if (!this.hasPlatformToolsForQEMU2Installed()) {
            return AccelerationErrorCode.PLATFORM_TOOLS_UPDATE_ADVISED;
        }
        if (!this.hasSystemImagesForQEMU2Installed()) {
            return AccelerationErrorCode.SYSTEM_IMAGE_UPDATE_ADVISED;
        }
        return AccelerationErrorCode.ALREADY_INSTALLED;
    }

    @NotNull
    public ListenableFuture<AccelerationErrorCode> checkAccelerationAsync() {
        return MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE).submit(this::checkAcceleration);
    }

    @Nullable
    public AvdInfo createOrUpdateAvd(@Nullable AvdInfo currentInfo, @NotNull String avdName, @NotNull Device device2, @NotNull SystemImageDescription systemImageDescription, @NotNull ScreenOrientation orientation, boolean isCircular, @Nullable String sdCard, @Nullable Path skinFolder, @NotNull Map<String, String> hardwareProperties, boolean removePrevious) {
        Path avdFolder;
        if (!this.initIfNecessary()) {
            return null;
        }
        assert (this.mySdkHandler != null);
        try {
            if (currentInfo != null) {
                avdFolder = currentInfo.getDataFolderPath();
            } else {
                assert (this.myAvdManager != null);
                avdFolder = AvdInfo.getDefaultAvdFolder((AvdManager)this.myAvdManager, (String)avdName, (boolean)true);
            }
        }
        catch (Throwable e) {
            IJ_LOG.error("Could not create AVD " + avdName, e);
            return null;
        }
        Dimension resolution2 = device2.getScreenSize(orientation);
        assert (resolution2 != null);
        String skinName = null;
        if (skinFolder == null && isCircular) {
            File skin = this.getRoundSkin(systemImageDescription);
            Path path2 = skinFolder = skin == null ? null : this.mySdkHandler.toCompatiblePath(skin);
        }
        if (skinFolder != null && skinFolder.toString().equals("_no_skin")) {
            skinFolder = null;
        }
        if (skinFolder == null) {
            skinName = String.format(Locale.US, "%dx%d", Math.round(resolution2.getWidth()), Math.round(resolution2.getHeight()));
        }
        if (orientation == ScreenOrientation.LANDSCAPE) {
            hardwareProperties.put("hw.initialOrientation", StringUtil.toLowerCase((String)ScreenOrientation.LANDSCAPE.getShortDisplayValue()));
        }
        if (device2.getId().equals("13.5in Freeform")) {
            hardwareProperties.put("display.settings.xml", "freeform");
        }
        if (device2.getId().equals("7.6in Foldable")) {
            hardwareProperties.put("hw.sensor.hinge", "yes");
            hardwareProperties.put("hw.sensor.hinge.count", "1");
            hardwareProperties.put("hw.sensor.hinge.type", "1");
            hardwareProperties.put("hw.sensor.hinge.sub_type", "1");
            hardwareProperties.put("hw.sensor.hinge.ranges", "0-180");
            hardwareProperties.put("hw.sensor.hinge.defaults", "180");
            hardwareProperties.put("hw.sensor.hinge.areas", "884-0-1-2208");
            hardwareProperties.put("hw.sensor.posture_list", "1,2,3");
            hardwareProperties.put("hw.sensor.hinge_angles_posture_definitions", "0-30, 30-150, 150-180");
        }
        if (device2.getId().equals("8in Foldable")) {
            hardwareProperties.put("hw.sensor.hinge", "yes");
            hardwareProperties.put("hw.sensor.hinge.count", "1");
            hardwareProperties.put("hw.sensor.hinge.type", "1");
            hardwareProperties.put("hw.sensor.hinge.sub_type", "1");
            hardwareProperties.put("hw.sensor.hinge.ranges", "180-360");
            hardwareProperties.put("hw.sensor.hinge.defaults", "180");
            hardwareProperties.put("hw.sensor.hinge.areas", "1148-0-1-2480");
            hardwareProperties.put("hw.sensor.hinge.fold_to_displayRegion.0.1_at_posture", "4");
            hardwareProperties.put("hw.sensor.posture_list", "3, 4");
            hardwareProperties.put("hw.sensor.hinge_angles_posture_definitions", "180-330, 330-360");
        }
        if (device2.getId().equals("6.7in Foldable")) {
            hardwareProperties.put("hw.sensor.hinge", "yes");
            hardwareProperties.put("hw.sensor.hinge.count", "1");
            hardwareProperties.put("hw.sensor.hinge.type", "0");
            hardwareProperties.put("hw.sensor.hinge.sub_type", "1");
            hardwareProperties.put("hw.sensor.hinge.ranges", "0-180");
            hardwareProperties.put("hw.sensor.hinge.defaults", "180");
            hardwareProperties.put("hw.sensor.hinge.areas", "0-1318-1080-1");
            hardwareProperties.put("hw.sensor.posture_list", "1, 2, 3");
            hardwareProperties.put("hw.sensor.hinge_angles_posture_definitions", "0-30, 30-150, 150-180");
        }
        if (device2.getId().equals("7.4in Rollable")) {
            hardwareProperties.put("hw.sensor.roll", "yes");
            hardwareProperties.put("hw.sensor.roll.count", "1");
            hardwareProperties.put("hw.sensor.hinge.type", "3");
            hardwareProperties.put("hw.sensor.roll.ranges", "58.55-100");
            hardwareProperties.put("hw.sensor.roll.defaults", "67.5");
            hardwareProperties.put("hw.sensor.roll.radius", "3");
            hardwareProperties.put("hw.sensor.roll.direction", "1");
            hardwareProperties.put("hw.sensor.roll.resize_to_displayRegion.0.1_at_posture", "1");
            hardwareProperties.put("hw.sensor.roll.resize_to_displayRegion.0.2_at_posture", "2");
            hardwareProperties.put("hw.sensor.posture_list", "1, 2, 3");
            hardwareProperties.put("hw.sensor.roll_percentages_posture_definitions", "58.55-76.45, 76.45-94.35, 94.35-100");
        }
        if (device2.getId().equals("resizable")) {
            hardwareProperties.put("hw.resizable.configs", "phone-0-1080-2340-420, foldable-1-1768-2208-420, tablet-2-1920-1200-240, desktop-3-1920-1080-160");
        }
        if (currentInfo != null && !avdName.equals(currentInfo.getName()) && removePrevious) {
            assert (this.myAvdManager != null);
            boolean success2 = this.myAvdManager.moveAvd(currentInfo, avdName, currentInfo.getDataFolderPath());
            if (!success2) {
                return null;
            }
        }
        assert (this.myAvdManager != null);
        return this.myAvdManager.createAvd(avdFolder, avdName, systemImageDescription.getSystemImage(), skinFolder, skinName, sdCard, hardwareProperties, device2.getBootProps(), device2.hasPlayStore(), false, removePrevious);
    }

    @Nullable
    private File getRoundSkin(SystemImageDescription systemImageDescription) {
        Path[] skins;
        for (Path skin : skins = systemImageDescription.getSkins()) {
            if (!skin.getFileName().toString().contains("Round")) continue;
            return FileOpUtils.toFile((Path)skin);
        }
        return null;
    }

    public static boolean doesSystemImageSupportQemu2(@Nullable SystemImageDescription description2) {
        boolean bl;
        block10: {
            if (description2 == null) {
                return false;
            }
            ISystemImage systemImage = description2.getSystemImage();
            if (systemImage == null) {
                return false;
            }
            Path location2 = systemImage.getLocation();
            Stream files2 = CancellableFileIo.list((Path)location2);
            try {
                bl = files2.anyMatch(file2 -> file2.getFileName().toString().startsWith("kernel-ranchu"));
                if (files2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (files2 != null) {
                        try {
                            files2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            files2.close();
        }
        return bl;
    }

    @Nullable
    public AvdInfo findAvd(@NotNull String avdId) {
        if (this.initIfNecessary()) {
            assert (this.myAvdManager != null);
            return this.myAvdManager.getAvd(avdId, false);
        }
        return null;
    }

    public boolean avdExists(@NotNull String candidate) {
        return this.findAvd(candidate) != null;
    }

    public static boolean isAvdRepairable(@NotNull AvdInfo.AvdStatus avdStatus) {
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_MISSING || avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_MISSING;
    }

    public static boolean isSystemImageDownloadProblem(@NotNull AvdInfo.AvdStatus status2) {
        switch (status2) {
            case ERROR_IMAGE_DIR: 
            case ERROR_IMAGE_MISSING: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AvdInfo reloadAvd(@NotNull String avdId) {
        AvdInfo avd = this.findAvd(avdId);
        if (avd != null) {
            return this.reloadAvd(avd);
        }
        return null;
    }

    @NotNull
    private AvdInfo reloadAvd(@NotNull AvdInfo avdInfo) {
        assert (this.myAvdManager != null);
        return this.myAvdManager.reloadAvd(avdInfo);
    }

    @Nullable
    public static String getRequiredSystemImagePath(@NotNull AvdInfo avdInfo) {
        String imageSystemDir = (String)avdInfo.getProperties().get("image.sysdir.1");
        if (imageSystemDir == null) {
            return null;
        }
        return StringUtil.trimEnd((String)imageSystemDir.replace(File.separatorChar, ';'), (char)';');
    }

    public void updateDeviceChanged(@NotNull AvdInfo avdInfo) {
        if (this.initIfNecessary()) {
            try {
                assert (this.myAvdManager != null);
                this.myAvdManager.updateDeviceChanged(avdInfo);
            }
            catch (IOException e) {
                IJ_LOG.warn("Could not update AVD Device " + avdInfo.getName(), (Throwable)e);
            }
        }
    }

    @NotNull
    public final @NotNull ListenableFuture<@NotNull Boolean> wipeUserDataAsync(@NotNull AvdInfo avd) {
        return Futures.submit(() -> this.wipeUserData(avd), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Slow
    public boolean wipeUserData(@NotNull AvdInfo avdInfo) {
        if (!this.initIfNecessary()) {
            return false;
        }
        assert (this.mySdkHandler != null);
        Path path2 = avdInfo.getDataFolderPath().resolve("userdata-qemu.img");
        if (Files.exists(path2, new LinkOption[0])) {
            try {
                PathUtils.deleteRecursivelyIfExists((Path)path2);
            }
            catch (IOException e) {
                return false;
            }
        }
        Path snapshotDirectory = avdInfo.getDataFolderPath().resolve("snapshots");
        try {
            PathUtils.deleteRecursivelyIfExists((Path)snapshotDirectory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public String uniquifyDisplayName(@NotNull String name) {
        int suffix = 1;
        String result2 = name;
        while (this.findAvdWithDisplayName(result2)) {
            result2 = String.format(Locale.US, "%1$s %2$d", name, ++suffix);
        }
        return result2;
    }

    public boolean findAvdWithDisplayName(@NotNull String name) {
        for (AvdInfo avd : this.getAvds(false)) {
            if (!avd.getDisplayName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static long getMemorySize() {
        if (ourMemorySize < 0L) {
            ourMemorySize = AvdManagerConnection.checkMemorySize();
        }
        return ourMemorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result2 = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result2 instanceof Number) {
                return ((Number)result2).longValue();
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException oracleSpecificMXBean) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            IJ_LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$continueToStartAvd$7(ProgressWindow p, ProcessHandler processHandler2) {
        try {
            p.start();
            p.setText("Starting AVD...");
            for (double d = 0.0; d < 1.0; d += 0.0125) {
                p.setFraction(d);
                Thread.sleep(100L);
                if (!processHandler2.isProcessTerminated()) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            p.stop();
            p.processFinish();
        }
    }

    private static class SystemImageUpdateDependency {
        private final int myFeatureLevel;
        private final IdDisplay myTag;
        private final int myRequiredMajorRevision;

        SystemImageUpdateDependency(int featureLevel, @NotNull IdDisplay tag, int requiredMajorRevision) {
            this.myFeatureLevel = featureLevel;
            this.myTag = tag;
            this.myRequiredMajorRevision = requiredMajorRevision;
        }

        public boolean updateRequired(@NotNull SystemImage image) {
            return this.updateRequired(image.getAbiType(), image.getAndroidVersion().getFeatureLevel(), image.getTag(), image.getRevision());
        }

        public boolean updateRequired(@NotNull String abiType, int featureLevel, @NotNull IdDisplay tag, @NotNull Revision revision) {
            Abi abi = Abi.getEnum((String)abiType);
            boolean isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
            return isAvdIntel && featureLevel == this.myFeatureLevel && this.myTag.equals((Object)tag) && revision.getMajor() < this.myRequiredMajorRevision;
        }
    }
}

