/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.concurrent.FutureCallback;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/assistant/AssistantGetBundleFromConfigTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Ljava/net/URL;", "uiCallback", "Lorg/apache/http/concurrent/FutureCallback;", "Lcom/android/tools/idea/assistant/datamodel/TutorialBundleData;", "bundleCreatorId", "", "(Lcom/intellij/openapi/project/Project;Ljava/net/URL;Lorg/apache/http/concurrent/FutureCallback;Ljava/lang/String;)V", "bundleData", "getBundle", "onCancel", "", "onSuccess", "onThrowable", "error", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "assistant"})
public final class AssistantGetBundleFromConfigTask
extends Task.Backgroundable {
    @NotNull
    private final URL config;
    @NotNull
    private final FutureCallback<TutorialBundleData> uiCallback;
    @NotNull
    private final String bundleCreatorId;
    private TutorialBundleData bundleData;

    public AssistantGetBundleFromConfigTask(@NotNull Project project, @NotNull URL config2, @NotNull FutureCallback<TutorialBundleData> uiCallback, @NotNull String bundleCreatorId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter(uiCallback, (String)"uiCallback");
        Intrinsics.checkNotNullParameter((Object)bundleCreatorId, (String)"bundleCreatorId");
        super(project, "Loading assistant content...");
        this.config = config2;
        this.uiCallback = uiCallback;
        this.bundleCreatorId = bundleCreatorId;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.bundleData = this.getBundle(this.config);
    }

    public void onSuccess() {
        super.onSuccess();
        TutorialBundleData tutorialBundleData = this.bundleData;
        if (tutorialBundleData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleData");
            tutorialBundleData = null;
        }
        this.uiCallback.completed((Object)tutorialBundleData);
    }

    public void onCancel() {
        super.onCancel();
        this.uiCallback.cancelled();
    }

    public void onThrowable(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.uiCallback.failed((Exception)new RuntimeException(error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TutorialBundleData getBundle(URL config2) {
        TutorialBundleData tutorialBundleData;
        Closeable closeable = config2.openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            TutorialBundleData tutorialBundleData2 = DefaultTutorialBundle.parse(it, this.bundleCreatorId);
            tutorialBundleData = tutorialBundleData2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)tutorialBundleData, (String)"config.openStream().use \u2026se(it, bundleCreatorId) }");
        return tutorialBundleData;
    }
}

