/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.internal.process;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.appinspection.internal.process.SingleDebuggableProcessReceiver;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.profiler.proto.Common;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"findDevice", "Lcom/android/ddmlib/IDevice;", "Lcom/android/tools/profiler/proto/Common$Device;", "isDebuggable", "", "processName", "", "isPackageDebuggable", "packageName", "app-inspection.api"})
public final class DebuggableProcessFilterKt {
    public static final boolean isDebuggable(@NotNull Common.Device $this$isDebuggable, @NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebuggable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        if (!Intrinsics.areEqual((Object)$this$isDebuggable.getBuildType(), (Object)"userdebug")) {
            return true;
        }
        IDevice iDevice = DebuggableProcessFilterKt.findDevice($this$isDebuggable);
        if (iDevice == null) {
            return false;
        }
        IDevice device2 = iDevice;
        return DebuggableProcessFilterKt.isPackageDebuggable(device2, processName);
    }

    public static final boolean isPackageDebuggable(@NotNull IDevice $this$isPackageDebuggable, @NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackageDebuggable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        SingleDebuggableProcessReceiver receiver2 = new SingleDebuggableProcessReceiver();
        try {
            $this$isPackageDebuggable.executeShellCommand("dumpsys package " + packageName2, (IShellOutputReceiver)receiver2);
        }
        catch (Exception ex) {
            Logger.getInstance(TransportDeviceManager.class).warn((Throwable)ex);
        }
        return Intrinsics.areEqual((Object)receiver2.getPackageName(), (Object)packageName2) && receiver2.isDebuggable();
    }

    private static final IDevice findDevice(Common.Device $this$findDevice) {
        IDevice iDevice;
        block3: {
            IDevice[] iDeviceArray = AndroidDebugBridge.getBridge();
            if (iDeviceArray != null && (iDeviceArray = iDeviceArray.getDevices()) != null) {
                IDevice[] iDeviceArray2 = iDeviceArray;
                int n = iDeviceArray2.length;
                for (int i = 0; i < n; ++i) {
                    IDevice iDevice2;
                    IDevice it = iDevice2 = iDeviceArray2[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)$this$findDevice.getSerial(), (Object)it.getSerialNumber())) continue;
                    iDevice = iDevice2;
                    break block3;
                }
                iDevice = null;
            } else {
                iDevice = null;
            }
        }
        return iDevice;
    }
}

