/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.BorderlessTableCellRenderer;
import com.android.tools.adtui.stdui.TimelineTable;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModel;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.SelectionRangeDataFetcher;
import com.android.tools.idea.appinspection.inspectors.network.view.ThreadsView;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.FontsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.LayoutKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0006\u000f\u0010\u0011\u0012\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView;", "", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "parentPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;Lcom/android/tools/adtui/stdui/TooltipLayeredPane;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "threadsTable", "Ljavax/swing/JTable;", "Column", "Companion", "ConnectionsInfoComponent", "ThreadsTableModel", "TimelineRenderer", "TooltipView", "app-inspection.inspectors.network.view"})
public final class ThreadsView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTable threadsTable;
    @NotNull
    private final AspectObserver observer;
    private static final int STATE_HEIGHT = JBUI.scale((int)15);
    private static final int SELECTION_OUTLINE_PADDING = JBUI.scale((int)3);
    private static final int SELECTION_OUTLINE_BORDER = JBUI.scale((int)2);
    private static final int ROW_HEIGHT = STATE_HEIGHT + 2 * (SELECTION_OUTLINE_BORDER + SELECTION_OUTLINE_PADDING);

    public ThreadsView(final @NotNull NetworkInspectorModel model2, @NotNull TooltipLayeredPane parentPane) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        Intrinsics.checkNotNullParameter((Object)parentPane, (String)"parentPane");
        ThreadsTableModel tableModel2 = new ThreadsTableModel(model2.getSelectionRangeDataFetcher());
        JBTable jBTable = TimelineTable.create((TableModel)tableModel2, (Timeline)((Timeline)model2.getTimeline()), (String)Column.TIMELINE.getDisplayName(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jBTable, (String)"create(tableModel, model\u2026MELINE.displayName, true)");
        this.threadsTable = (JTable)jBTable;
        final TimelineRenderer timelineRenderer = new TimelineRenderer(this.threadsTable, model2);
        this.threadsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer((TableCellRenderer)new BorderlessTableCellRenderer());
        this.threadsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer((TableCellRenderer)((Object)timelineRenderer));
        this.threadsTable.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        this.threadsTable.setShowVerticalLines(true);
        this.threadsTable.setShowHorizontalLines(false);
        this.threadsTable.setCellSelectionEnabled(false);
        this.threadsTable.setFocusable(false);
        this.threadsTable.setRowMargin(0);
        this.threadsTable.setRowHeight(ROW_HEIGHT);
        this.threadsTable.setFocusTraversalKeys(0, null);
        this.threadsTable.setFocusTraversalKeys(1, null);
        this.threadsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                threadsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setPreferredWidth((int)((double)threadsTable.getWidth() * 1.0 / (double)8));
                threadsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setPreferredWidth((int)((double)threadsTable.getWidth() * 7.0 / (double)8));
            }
        });
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(tableModel2);
        sorter.setComparator(Column.NAME.ordinal(), Comparator.comparing(2.INSTANCE));
        sorter.setComparator(Column.TIMELINE.ordinal(), Comparator.comparing(3.INSTANCE));
        this.threadsTable.setRowSorter((RowSorter<? extends TableModel>)sorter);
        this.threadsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Range range = timelineRenderer.getActiveRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"timelineRenderer.activeRange");
                Range selection = range;
                HttpData data2 = Companion.findHttpDataUnderCursor(threadsTable, selection, e);
                if (data2 != null) {
                    model2.setSelectedConnection(data2);
                    model2.setDetailContent(NetworkInspectorModel.DetailContent.CONNECTION);
                    e.consume();
                }
            }
        });
        Range range = timelineRenderer.getActiveRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"timelineRenderer.activeRange");
        this.threadsTable.addMouseMotionListener(new TooltipView(this.threadsTable, parentPane, range));
        this.observer = new AspectObserver();
        model2.getAspect().addDependency(this.observer).onChange((Enum)NetworkInspectorAspect.SELECTED_CONNECTION, new Runnable(){

            @Override
            public final void run() {
                timelineRenderer.updateRows();
                threadsTable.repaint();
            }
        });
    }

    @NotNull
    public final JComponent getComponent() {
        return this.threadsTable;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$Column;", "", "displayName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "NAME", "TIMELINE", "app-inspection.inspectors.network.view"})
    private static final class Column
    extends Enum<Column> {
        @NotNull
        private final String displayName;
        public static final /* enum */ Column NAME = new Column("Initiating thread");
        public static final /* enum */ Column TIMELINE = new Column("Timeline");
        private static final /* synthetic */ Column[] $VALUES;

        private Column(String displayName2) {
            this.displayName = displayName2;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value2) {
            return Enum.valueOf(Column.class, value2);
        }

        static {
            $VALUES = columnArray = new Column[]{Column.NAME, Column.TIMELINE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ThreadsTableModel;", "Ljavax/swing/table/AbstractTableModel;", "selectionRangeDataFetcher", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/SelectionRangeDataFetcher;", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/SelectionRangeDataFetcher;)V", "threads", "", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "getColumnCount", "", "getColumnName", "", "column", "getRowCount", "getValueAt", "", "rowIndex", "columnIndex", "httpDataChanged", "", "dataList", "app-inspection.inspectors.network.view"})
    private static final class ThreadsTableModel
    extends AbstractTableModel {
        @NotNull
        private final List<List<HttpData>> threads;

        public ThreadsTableModel(@NotNull SelectionRangeDataFetcher selectionRangeDataFetcher) {
            Intrinsics.checkNotNullParameter((Object)selectionRangeDataFetcher, (String)"selectionRangeDataFetcher");
            this.threads = new ArrayList();
            selectionRangeDataFetcher.addOnChangedListener((Function1<? super List<HttpData>, Unit>)((Function1)new Function1<List<? extends HttpData>, Unit>(){

                public final void invoke(@NotNull List<HttpData> httpDataList) {
                    Intrinsics.checkNotNullParameter(httpDataList, (String)"httpDataList");
                    this.httpDataChanged(httpDataList);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final void httpDataChanged(List<HttpData> dataList) {
            void $this$groupByTo$iv$iv;
            HttpData it;
            Iterable $this$filterTo$iv$iv;
            this.threads.clear();
            if (dataList.isEmpty()) {
                this.fireTableDataChanged();
                return;
            }
            Iterable $this$filter$iv = dataList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (HttpData)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it.getJavaThreads()).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (HttpData)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.getJavaThreads().get(0).getId();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object groupedThreads = destination$iv$iv;
            Function1[] function1Array = new Function1[]{httpDataChanged.1.INSTANCE, httpDataChanged.2.INSTANCE};
            this.threads.addAll(CollectionsKt.sortedWith((Iterable)groupedThreads.values(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.threads.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @NotNull
        public String getColumnName(int column2) {
            return Column.values()[column2].getDisplayName();
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == Column.NAME.ordinal() ? this.threads.get(rowIndex).get(0).getJavaThreads().get(0).getName() : this.threads.get(rowIndex);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0012R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$TimelineRenderer;", "Lcom/android/tools/adtui/stdui/TimelineTable$CellRenderer;", "Ljavax/swing/event/TableModelListener;", "table", "Ljavax/swing/JTable;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "(Ljavax/swing/JTable;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;)V", "connectionsInfo", "", "Ljavax/swing/JComponent;", "getTableCellRendererComponent", "Ljava/awt/Component;", "isSelected", "", "row", "", "tableChanged", "", "e", "Ljavax/swing/event/TableModelEvent;", "updateRows", "app-inspection.inspectors.network.view"})
    private static final class TimelineRenderer
    extends TimelineTable.CellRenderer
    implements TableModelListener {
        @NotNull
        private final JTable table;
        @NotNull
        private final NetworkInspectorModel model;
        @NotNull
        private final List<JComponent> connectionsInfo;

        public TimelineRenderer(@NotNull JTable table2, @NotNull NetworkInspectorModel model2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            super((Timeline)model2.getTimeline(), true);
            this.table = table2;
            this.model = model2;
            this.connectionsInfo = new ArrayList();
            this.table.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.table.getModel()));
        }

        @Override
        public void tableChanged(@NotNull TableModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.updateRows();
        }

        public final void updateRows() {
            this.connectionsInfo.clear();
            int n = this.table.getModel().getRowCount();
            for (int index2 = 0; index2 < n; ++index2) {
                Object object = this.table.getModel().getValueAt(index2, 1);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData>");
                List data2 = (List)object;
                Range range = this.getActiveRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"activeRange");
                this.connectionsInfo.add(new ConnectionsInfoComponent(this.table, data2, this.model, range));
            }
        }

        @NotNull
        protected Component getTableCellRendererComponent(boolean isSelected, int row2) {
            return this.connectionsInfo.get(this.table.convertRowIndexToModel(row2));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ConnectionsInfoComponent;", "Ljavax/swing/JComponent;", "table", "Ljavax/swing/JTable;", "dataList", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "range", "Lcom/android/tools/adtui/model/Range;", "(Ljavax/swing/JTable;Ljava/util/List;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;Lcom/android/tools/adtui/model/Range;)V", "drawConnectionName", "", "g2d", "Ljava/awt/Graphics2D;", "data", "endLimit", "", "drawSelection", "drawState", "paintComponent", "g", "Ljava/awt/Graphics;", "rangeToPosition", "r", "Companion", "app-inspection.inspectors.network.view"})
    private static final class ConnectionsInfoComponent
    extends JComponent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JTable table;
        @NotNull
        private final List<HttpData> dataList;
        @NotNull
        private final NetworkInspectorModel model;
        @NotNull
        private final Range range;
        private static final int NAME_PADDING = 6;

        public ConnectionsInfoComponent(@NotNull JTable table2, @NotNull List<HttpData> dataList, @NotNull NetworkInspectorModel model2, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.table = table2;
            this.dataList = dataList;
            this.model = model2;
            this.range = range;
            this.setFont(FontsKt.getSMALL_FONT());
            this.setForeground((Color)JBColor.BLACK);
            this.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int n = this.dataList.size();
            for (int i = 0; i < n; ++i) {
                HttpData data2 = this.dataList.get(i);
                double endLimit = i + 1 < this.dataList.size() ? this.rangeToPosition(this.dataList.get(i + 1).getRequestStartTimeUs()) : (double)this.getWidth();
                this.drawState(g2d, data2, endLimit);
                this.drawConnectionName(g2d, data2, endLimit);
            }
            if (this.model.getSelectedConnection() != null && CollectionsKt.contains((Iterable)this.dataList, (Object)this.model.getSelectedConnection())) {
                HttpData httpData = this.model.getSelectedConnection();
                Intrinsics.checkNotNull((Object)httpData);
                this.drawSelection(g2d, httpData, this.getWidth());
            }
            g2d.dispose();
        }

        private final void drawState(Graphics2D g2d, HttpData data2, double endLimit) {
            double prev = this.rangeToPosition(data2.getRequestStartTimeUs());
            g2d.setColor(ColorsKt.getNETWORK_SENDING_COLOR());
            if (data2.getResponseStartTimeUs() > 0L) {
                double download = this.rangeToPosition(data2.getResponseStartTimeUs());
                g2d.fill(new Rectangle2D.Double(prev, (double)(this.getHeight() - STATE_HEIGHT) / 2.0, download - prev, STATE_HEIGHT));
                g2d.setColor(ColorsKt.getNETWORK_RECEIVING_COLOR());
                prev = download;
            }
            double end = data2.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data2.getConnectionEndTimeUs()) : endLimit;
            g2d.fill(new Rectangle2D.Double(prev, (double)(this.getHeight() - STATE_HEIGHT) / 2.0, end - prev, STATE_HEIGHT));
        }

        private final void drawConnectionName(Graphics2D g2d, HttpData data2, double endLimit) {
            g2d.setFont(this.getFont());
            g2d.setColor(this.getForeground());
            double start2 = this.rangeToPosition(data2.getRequestStartTimeUs());
            double end = data2.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data2.getConnectionEndTimeUs()) : endLimit;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            String string = HttpData.Companion.getUrlName(data2.getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)metrics, (String)"metrics");
            String text2 = AdtUiUtils.shrinkToFit$default((String)string, (FontMetrics)metrics, (float)((float)(end - start2 - (double)12)), null, (int)8, null);
            double availableSpace = end - start2 - (double)metrics.stringWidth(text2);
            g2d.drawString(text2, (float)(start2 + availableSpace / 2.0), (float)((double)(this.getHeight() - metrics.getHeight()) * 0.5 + (double)metrics.getAscent()));
        }

        private final void drawSelection(Graphics2D g2d, HttpData data2, double endLimit) {
            double start2 = this.rangeToPosition(data2.getRequestStartTimeUs());
            double end = data2.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data2.getConnectionEndTimeUs()) : endLimit;
            g2d.setStroke(new BasicStroke(SELECTION_OUTLINE_BORDER));
            g2d.setColor(this.table.getSelectionBackground());
            Rectangle2D.Double rect = new Rectangle2D.Double(start2 - (double)SELECTION_OUTLINE_PADDING, (double)(this.getHeight() - STATE_HEIGHT) / 2.0 - (double)SELECTION_OUTLINE_PADDING, end - start2 + (double)(2 * SELECTION_OUTLINE_PADDING), (double)STATE_HEIGHT + (double)2 * (double)SELECTION_OUTLINE_PADDING);
            g2d.draw(rect);
        }

        private final double rangeToPosition(double r) {
            return (r - this.range.getMin()) / this.range.getLength() * (double)this.getWidth();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ConnectionsInfoComponent$Companion;", "", "()V", "NAME_PADDING", "", "app-inspection.inspectors.network.view"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$TooltipView;", "Ljava/awt/event/MouseAdapter;", "table", "Ljavax/swing/JTable;", "parentPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "range", "Lcom/android/tools/adtui/model/Range;", "(Ljavax/swing/JTable;Lcom/android/tools/adtui/stdui/TooltipLayeredPane;Lcom/android/tools/adtui/model/Range;)V", "content", "Ljavax/swing/JPanel;", "tooltipComponent", "Lcom/android/tools/adtui/TooltipComponent;", "Lorg/jetbrains/annotations/NotNull;", "addToContent", "", "component", "Ljavax/swing/JComponent;", "mouseMoved", "e", "Ljava/awt/event/MouseEvent;", "newTooltipLabel", "Ljavax/swing/JLabel;", "text", "", "showTooltip", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
    private static final class TooltipView
    extends MouseAdapter {
        @NotNull
        private final JTable table;
        @NotNull
        private final Range range;
        @NotNull
        private final JPanel content;
        @NotNull
        private final TooltipComponent tooltipComponent;

        /*
         * WARNING - void declaration
         */
        public TooltipView(@NotNull JTable table2, @NotNull TooltipLayeredPane parentPane, @NotNull Range range) {
            void $this$tooltipComponent_u24lambda_u2d1;
            void $this$content_u24lambda_u2d0;
            JPanel jPanel;
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parentPane, (String)"parentPane");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.table = table2;
            this.range = range;
            JPanel jPanel2 = jPanel = new JPanel((LayoutManager)new TabularLayout("*", "*"));
            TooltipView tooltipView = this;
            boolean $i$a$-apply-ThreadsView$TooltipView$content$22 = false;
            $this$content_u24lambda_u2d0.setBorder(LayoutKt.getTOOLTIP_BORDER());
            $this$content_u24lambda_u2d0.setBackground(ColorsKt.getTOOLTIP_BACKGROUND());
            $this$content_u24lambda_u2d0.setFont(com.android.tools.adtui.TooltipView.TOOLTIP_BODY_FONT);
            tooltipView.content = jPanel;
            JPanel $i$a$-apply-ThreadsView$TooltipView$content$22 = jPanel2 = new TooltipComponent.Builder((JComponent)this.content, (JComponent)this.table, (JLayeredPane)parentPane).build();
            tooltipView = this;
            boolean bl = false;
            $this$tooltipComponent_u24lambda_u2d1.registerListenersOn((Component)this.table);
            $this$tooltipComponent_u24lambda_u2d1.setVisible(false);
            JPanel jPanel3 = jPanel2;
            Intrinsics.checkNotNullExpressionValue((Object)jPanel3, (String)"Builder(content, table, \u2026  isVisible = false\n    }");
            tooltipView.tooltipComponent = jPanel3;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            block0: {
                HttpData data2;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.tooltipComponent.setVisible(false);
                HttpData httpData = data2 = Companion.findHttpDataUnderCursor(this.table, this.range, e);
                if (httpData == null) break block0;
                HttpData it = httpData;
                boolean bl = false;
                this.showTooltip(it);
            }
        }

        private final void showTooltip(HttpData data2) {
            this.tooltipComponent.setVisible(true);
            String urlName = HttpData.Companion.getUrlName(data2.getUrl());
            long duration2 = data2.getConnectionEndTimeUs() - data2.getRequestStartTimeUs();
            this.content.removeAll();
            this.addToContent(this.newTooltipLabel(urlName));
            String string = TimeFormatter.getSingleUnitDurationString((long)duration2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSingleUnitDurationString(duration)");
            JLabel durationLabel = this.newTooltipLabel(string);
            durationLabel.setForeground(ColorsKt.getTOOLTIP_TEXT());
            this.addToContent(durationLabel);
            if (data2.getJavaThreads().size() > 1) {
                JPanel divider = new JPanel();
                divider.setPreferredSize(new Dimension(0, 5));
                divider.setBorder(JBUI.Borders.customLineBottom((Color)ColorsKt.getNETWORK_THREADS_VIEW_TOOLTIP_DIVIDER()));
                divider.setBackground(this.content.getBackground());
                this.content.add((Component)divider, new TabularLayout.Constraint(this.content.getComponentCount(), 0, 0, 4, null));
                JLabel alsoAccessedByLabel = this.newTooltipLabel("Also accessed by:");
                alsoAccessedByLabel.setFont(alsoAccessedByLabel.getFont().deriveFont(MapsKt.mapOf((Pair)TuplesKt.to((Object)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD))));
                this.addToContent(alsoAccessedByLabel);
                int n = data2.getJavaThreads().size();
                for (int i = 1; i < n; ++i) {
                    JLabel label = this.newTooltipLabel(data2.getJavaThreads().get(i).getName());
                    this.addToContent(label);
                    if (i != data2.getJavaThreads().size() - 1) continue;
                    label.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
                }
            }
        }

        private final void addToContent(JComponent component2) {
            component2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            this.content.add((Component)component2, new TabularLayout.Constraint(this.content.getComponentCount(), 0, 0, 4, null));
        }

        private final JLabel newTooltipLabel(String text2) {
            JLabel label = new JLabel(text2);
            label.setForeground(ColorsKt.getTOOLTIP_TEXT());
            label.setFont(com.android.tools.adtui.TooltipView.TOOLTIP_BODY_FONT);
            return label;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$Companion;", "", "()V", "ROW_HEIGHT", "", "SELECTION_OUTLINE_BORDER", "SELECTION_OUTLINE_PADDING", "STATE_HEIGHT", "findHttpDataUnderCursor", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "table", "Ljavax/swing/JTable;", "range", "Lcom/android/tools/adtui/model/Range;", "e", "Ljava/awt/event/MouseEvent;", "positionToRange", "", "x", "width", "app-inspection.inspectors.network.view"})
    public static final class Companion {
        private Companion() {
        }

        private final HttpData findHttpDataUnderCursor(JTable table2, Range range, MouseEvent e) {
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), table2);
            int row2 = table2.rowAtPoint(p);
            int column2 = table2.columnAtPoint(p);
            if (row2 == -1 || column2 == -1) {
                return null;
            }
            if (column2 == Column.TIMELINE.ordinal()) {
                Rectangle cellBounds = table2.getCellRect(row2, column2, false);
                int modelIndex = table2.convertRowIndexToModel(row2);
                Object object = table2.getModel().getValueAt(modelIndex, 1);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData>");
                List dataList = (List)object;
                double at = this.positionToRange(p.x - cellBounds.x, cellBounds.getWidth(), range);
                for (HttpData data2 : dataList) {
                    if (!((double)data2.getRequestStartTimeUs() <= at) || !(at <= (double)data2.getConnectionEndTimeUs())) continue;
                    return data2;
                }
            }
            return null;
        }

        private final double positionToRange(double x, double width, Range range) {
            return x * range.getLength() / width + range.getMin();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

