/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.HyperlinkInstruction;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.adtui.stdui.StreamingScrollbar;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.idea.appinspection.inspectors.network.model.LegendsModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorServices;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkSpeedLineChartModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkTrafficTooltipModel;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.SelectionRangeDataListener;
import com.android.tools.idea.appinspection.inspectors.network.view.ConnectionsView;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkInspectorView;
import com.android.tools.idea.appinspection.inspectors.network.view.ThreadsView;
import com.android.tools.idea.appinspection.inspectors.network.view.TooltipMouseAdapter;
import com.android.tools.idea.appinspection.inspectors.network.view.UiComponentsProvider;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.FontsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.LayoutKt;
import com.android.tools.idea.appinspection.inspectors.network.view.details.NetworkInspectorDetailsPanel;
import com.android.tools.idea.appinspection.inspectors.network.view.rules.RulesTableView;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00100\u001a\u00020\u0016H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020+H\u0002J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u00020=H\u0002R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00100-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView;", "Lcom/android/tools/adtui/model/AspectObserver;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "componentsProvider", "Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;", "parentPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "inspectorServices", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorServices;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;Lcom/android/tools/adtui/stdui/TooltipLayeredPane;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorServices;Lkotlinx/coroutines/CoroutineScope;)V", "activeTooltipView", "Lcom/android/tools/adtui/TooltipView;", "getActiveTooltipView", "()Lcom/android/tools/adtui/TooltipView;", "setActiveTooltipView", "(Lcom/android/tools/adtui/TooltipView;)V", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "getComponentsProvider", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/UiComponentsProvider;", "connectionsView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView;", "getConnectionsView", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView;", "detailsPanel", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/NetworkInspectorDetailsPanel;", "getDetailsPanel", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/details/NetworkInspectorDetailsPanel;", "mainPanel", "getModel", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "rulesView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/rules/RulesTableView;", "getRulesView", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/rules/RulesTableView;", "selectionTimeLabel", "Ljavax/swing/JLabel;", "tooltipBinder", "Lcom/android/tools/adtui/model/ViewBinder;", "Lcom/android/tools/adtui/model/TooltipModel;", "tooltipPanel", "buildMonitorUi", "buildTimeAxis", "Ljavax/swing/JComponent;", "axis", "Lcom/android/tools/adtui/model/axis/ResizingAxisComponentModel;", "createSelectionTimeLabel", "hasTrafficUsage", "", "series", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "range", "Lcom/android/tools/adtui/model/Range;", "selectionChanged", "", "tooltipChanged", "app-inspection.inspectors.network.view"})
public final class NetworkInspectorView
extends AspectObserver {
    @NotNull
    private final NetworkInspectorModel model;
    @NotNull
    private final UiComponentsProvider componentsProvider;
    @NotNull
    private final TooltipLayeredPane parentPane;
    @NotNull
    private final NetworkInspectorServices inspectorServices;
    @NotNull
    private final JPanel component;
    @NotNull
    private final JPanel tooltipPanel;
    @Nullable
    private TooltipView activeTooltipView;
    @NotNull
    private final JLabel selectionTimeLabel;
    @VisibleForTesting
    @NotNull
    private final ConnectionsView connectionsView;
    @NotNull
    private final RulesTableView rulesView;
    @VisibleForTesting
    @NotNull
    private final NetworkInspectorDetailsPanel detailsPanel;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final ViewBinder<NetworkInspectorView, TooltipModel, TooltipView> tooltipBinder;

    /*
     * WARNING - void declaration
     */
    public NetworkInspectorView(@NotNull Project project, @NotNull NetworkInspectorModel model2, @NotNull UiComponentsProvider componentsProvider, @NotNull TooltipLayeredPane parentPane, @NotNull NetworkInspectorServices inspectorServices, @NotNull CoroutineScope scope2) {
        void $this$detailsPanel_u24lambda_u2d0;
        NetworkInspectorDetailsPanel networkInspectorDetailsPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        Intrinsics.checkNotNullParameter((Object)componentsProvider, (String)"componentsProvider");
        Intrinsics.checkNotNullParameter((Object)parentPane, (String)"parentPane");
        Intrinsics.checkNotNullParameter((Object)inspectorServices, (String)"inspectorServices");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.model = model2;
        this.componentsProvider = componentsProvider;
        this.parentPane = parentPane;
        this.inspectorServices = inspectorServices;
        this.component = new JPanel(new BorderLayout());
        this.tooltipPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.selectionTimeLabel = this.createSelectionTimeLabel();
        this.connectionsView = new ConnectionsView(this.model, this.parentPane);
        this.rulesView = new RulesTableView(project, this.inspectorServices.getClient(), scope2, this.model, this.inspectorServices.getUsageTracker());
        NetworkInspectorDetailsPanel networkInspectorDetailsPanel2 = networkInspectorDetailsPanel = new NetworkInspectorDetailsPanel(this, this.inspectorServices.getUsageTracker());
        NetworkInspectorView networkInspectorView = this;
        boolean bl = false;
        $this$detailsPanel_u24lambda_u2d0.setVisible(false);
        networkInspectorView.detailsPanel = networkInspectorDetailsPanel;
        this.mainPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit-", "Fit-,*"));
        this.tooltipBinder = new ViewBinder();
        this.tooltipPanel.setBackground(ColorsKt.getTOOLTIP_BACKGROUND());
        this.model.addDependency(this).onChange((Enum)NetworkInspectorAspect.TOOLTIP, new Runnable(){

            @Override
            public final void run() {
                this.tooltipChanged();
            }
        });
        this.model.getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, new Runnable(){

            @Override
            public final void run() {
                this.selectionChanged();
            }
        });
        this.selectionChanged();
        this.tooltipBinder.bind(NetworkTrafficTooltipModel.class, (BiFunction)3.INSTANCE);
        this.detailsPanel.setMinimumSize(new Dimension(JBUI.scale((int)550), (int)this.detailsPanel.getMinimumSize().getHeight()));
        ThreadsView threadsView = new ThreadsView(this.model, this.parentPane);
        JBSplitter leftSplitter = new JBSplitter(true, 0.25f);
        leftSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        leftSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        final JPanel connectionsPanel = new JPanel(new CardLayout());
        final CommonTabbedPane connectionsTab = new CommonTabbedPane();
        final JBScrollPane connectionScrollPane = new JBScrollPane((Component)this.connectionsView.getComponent());
        connectionScrollPane.setBorder((Border)JBUI.Borders.empty());
        final JBScrollPane threadsViewScrollPane = new JBScrollPane((Component)threadsView.getComponent());
        threadsViewScrollPane.setBorder((Border)JBUI.Borders.empty());
        connectionsTab.addTab("Connection View", (Component)connectionScrollPane);
        connectionsTab.addTab("Thread View", (Component)threadsViewScrollPane);
        Object t = StudioFlags.ENABLE_NETWORK_INTERCEPTION.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"ENABLE_NETWORK_INTERCEPTION.get()");
        if (((Boolean)t).booleanValue()) {
            connectionsTab.addTab("Rules", (Component)this.rulesView.getComponent());
            Ref.ObjectRef selectedComponent = new Ref.ObjectRef();
            connectionsTab.addChangeListener(new ChangeListener((Ref.ObjectRef<Component>)selectedComponent, this){
                final /* synthetic */ Ref.ObjectRef<Component> $selectedComponent;
                final /* synthetic */ NetworkInspectorView this$0;
                {
                    this.$selectedComponent = $selectedComponent;
                    this.this$0 = $receiver;
                }

                @Override
                public final void stateChanged(ChangeEvent it) {
                    Component component2 = connectionsTab.getSelectedComponent();
                    if (Intrinsics.areEqual((Object)component2, (Object)connectionScrollPane) ? true : Intrinsics.areEqual((Object)component2, (Object)threadsViewScrollPane)) {
                        if (Intrinsics.areEqual((Object)this.$selectedComponent.element, (Object)this.this$0.getRulesView().getComponent())) {
                            this.this$0.getModel().setDetailContent(this.this$0.getModel().getSelectedConnection() == null ? NetworkInspectorModel.DetailContent.EMPTY : NetworkInspectorModel.DetailContent.CONNECTION);
                        }
                    } else if (Intrinsics.areEqual((Object)component2, (Object)this.this$0.getRulesView().getComponent()) && (Intrinsics.areEqual((Object)this.$selectedComponent.element, (Object)connectionScrollPane) || Intrinsics.areEqual((Object)this.$selectedComponent.element, (Object)threadsViewScrollPane))) {
                        this.this$0.getModel().setDetailContent(this.this$0.getModel().getSelectedRule() == null ? NetworkInspectorModel.DetailContent.EMPTY : NetworkInspectorModel.DetailContent.RULE);
                    }
                    this.$selectedComponent.element = connectionsTab.getSelectedComponent();
                }
            });
        }
        connectionsTab.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                mainPanel.repaint();
            }
        });
        connectionsPanel.add((Component)connectionsTab, "Connections");
        JPanel infoPanel = new JPanel(new BorderLayout());
        RenderInstruction[] renderInstructionArray = new RenderInstruction[]{(RenderInstruction)new TextInstruction(UIUtilities.getFontMetrics((JComponent)infoPanel, (Font)FontsKt.getH3_FONT()), "Network inspector data unavailable"), (RenderInstruction)new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), (RenderInstruction)new TextInstruction(UIUtilities.getFontMetrics((JComponent)infoPanel, (Font)FontsKt.getSTANDARD_FONT()), "There is no information for the network traffic you've selected."), (RenderInstruction)new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), (RenderInstruction)new HyperlinkInstruction(FontsKt.getSTANDARD_FONT(), "Learn More", "https://developer.android.com/r/studio-ui/network-profiler-troubleshoot-connections.html")};
        InstructionsPanel instructionsPanel = new InstructionsPanel.Builder(renderInstructionArray).setColors(JBColor.foreground(), null).build();
        Intrinsics.checkNotNullExpressionValue((Object)instructionsPanel, (String)"Builder(\n      TextInstr\u2026d(), null)\n      .build()");
        InstructionsPanel infoMessage = instructionsPanel;
        infoPanel.add((Component)infoMessage, "Center");
        infoPanel.setName("Info");
        connectionsPanel.add((Component)infoPanel, "Info");
        JPanel toolbar2 = new JPanel(new GridBagLayout());
        this.selectionTimeLabel.setBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)8));
        toolbar2.add(this.selectionTimeLabel);
        this.mainPanel.add((Component)toolbar2, new TabularLayout.Constraint(0, 1, 0, 4, null));
        this.mainPanel.add((Component)connectionsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        leftSplitter.setSecondComponent((JComponent)this.mainPanel);
        this.model.getSelectionRangeDataFetcher().addListener(new SelectionRangeDataListener(){

            @Override
            public void onUpdate(@NotNull List<HttpData> data2) {
                CardLayout cardLayout;
                block2: {
                    block3: {
                        Intrinsics.checkNotNullParameter(data2, (String)"data");
                        LayoutManager layoutManager = connectionsPanel.getLayout();
                        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
                        cardLayout = (CardLayout)layoutManager;
                        if (!data2.isEmpty()) break block2;
                        NetworkSpeedLineChartModel detailedNetworkUsage = this.getModel().getNetworkUsage();
                        RangedContinuousSeries rangedContinuousSeries = detailedNetworkUsage.getRxSeries();
                        Range range = this.getModel().getTimeline().getSelectionRange();
                        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"model.timeline.selectionRange");
                        if (this.hasTrafficUsage(rangedContinuousSeries, range)) break block3;
                        RangedContinuousSeries rangedContinuousSeries2 = detailedNetworkUsage.getTxSeries();
                        Range range2 = this.getModel().getTimeline().getSelectionRange();
                        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"model.timeline.selectionRange");
                        if (!this.hasTrafficUsage(rangedContinuousSeries2, range2)) break block2;
                    }
                    cardLayout.show(connectionsPanel, "Info");
                    return;
                }
                cardLayout.show(connectionsPanel, "Connections");
            }
        });
        JBSplitter splitter = new JBSplitter(false, 0.6f);
        splitter.setFirstComponent((JComponent)leftSplitter);
        splitter.setSecondComponent((JComponent)this.detailsPanel);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.component.add((Component)splitter, "Center");
    }

    @NotNull
    public final NetworkInspectorModel getModel() {
        return this.model;
    }

    @NotNull
    public final UiComponentsProvider getComponentsProvider() {
        return this.componentsProvider;
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    @Nullable
    public final TooltipView getActiveTooltipView() {
        return this.activeTooltipView;
    }

    public final void setActiveTooltipView(@Nullable TooltipView tooltipView) {
        this.activeTooltipView = tooltipView;
    }

    @NotNull
    public final ConnectionsView getConnectionsView() {
        return this.connectionsView;
    }

    @NotNull
    public final RulesTableView getRulesView() {
        return this.rulesView;
    }

    @NotNull
    public final NetworkInspectorDetailsPanel getDetailsPanel() {
        return this.detailsPanel;
    }

    private final JComponent buildTimeAxis(ResizingAxisComponentModel axis) {
        JPanel axisPanel = new JPanel(new BorderLayout());
        axisPanel.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        AxisComponent timeAxis = new AxisComponent((AxisComponentModel)axis, AxisComponent.AxisOrientation.BOTTOM);
        timeAxis.setShowAxisLine(false);
        timeAxis.setMinimumSize(new Dimension(0, LayoutKt.getTIME_AXIS_HEIGHT()));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, LayoutKt.getTIME_AXIS_HEIGHT()));
        axisPanel.add((Component)timeAxis, "Center");
        return axisPanel;
    }

    private final void tooltipChanged() {
        if (this.activeTooltipView != null) {
            TooltipView tooltipView = this.activeTooltipView;
            Intrinsics.checkNotNull((Object)tooltipView);
            tooltipView.dispose();
            this.activeTooltipView = null;
        }
        this.tooltipPanel.removeAll();
        this.tooltipPanel.setVisible(false);
        if (this.model.getTooltip() != null) {
            TooltipView tooltipView = this.activeTooltipView = (TooltipView)this.tooltipBinder.build((Object)this, (Object)this.model.getTooltip());
            Intrinsics.checkNotNull((Object)tooltipView);
            this.tooltipPanel.add(tooltipView.createComponent());
            this.tooltipPanel.setVisible(true);
        }
        this.tooltipPanel.invalidate();
        this.tooltipPanel.repaint();
    }

    private final void selectionChanged() {
        StreamingTimeline timeline = this.model.getTimeline();
        Range range = timeline.getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"timeline.selectionRange");
        Range selectionRange = range;
        if (selectionRange.isEmpty()) {
            this.selectionTimeLabel.setIcon(null);
            this.selectionTimeLabel.setText("");
            return;
        }
        long selectionMinUs = timeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMin()));
        long selectionMaxUs = timeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMax()));
        this.selectionTimeLabel.setIcon(StudioIcons.Profiler.Toolbar.CLOCK);
        if (selectionRange.isPoint()) {
            this.selectionTimeLabel.setText(TimeFormatter.getSimplifiedClockString((long)selectionMinUs));
        } else {
            this.selectionTimeLabel.setText(TimeFormatter.getSimplifiedClockString((long)selectionMinUs) + " - " + TimeFormatter.getSimplifiedClockString((long)selectionMaxUs));
        }
    }

    private final JLabel createSelectionTimeLabel() {
        JLabel label = new JLabel("");
        label.setFont(FontsKt.getSTANDARD_FONT());
        label.setBorder((Border)JBUI.Borders.empty((int)3, (int)3, (int)3, (int)3));
        label.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ NetworkInspectorView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StreamingTimeline timeline = this.this$0.getModel().getTimeline();
                timeline.frameViewToRange(timeline.getSelectionRange());
            }
        });
        label.setToolTipText("Selected range");
        label.setCursor(Cursor.getPredefinedCursor(12));
        return label;
    }

    private final JPanel buildMonitorUi() {
        StreamingTimeline timeline = this.model.getTimeline();
        RangeSelectionComponent selection = new RangeSelectionComponent(this.model.getRangeSelectionModel());
        selection.setCursorSetter((BiFunction)buildMonitorUi.1.INSTANCE);
        RangeTooltipComponent tooltip2 = new RangeTooltipComponent((Timeline)timeline, (JComponent)this.tooltipPanel, (JLayeredPane)this.parentPane, new Supplier(selection){
            final /* synthetic */ RangeSelectionComponent $selection;
            {
                this.$selection = $selection;
            }

            public final Boolean get() {
                return this.$selection.shouldShowSeekComponent();
            }
        });
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel2 = new JBPanel((LayoutManager)layout);
        panel2.setBackground(ColorsKt.getDEFAULT_STAGE_BACKGROUND());
        panel2.add((Component)tooltip2, (Object)new TabularLayout.Constraint(0, 0, 2, 1));
        StreamingScrollbar sb = new StreamingScrollbar(timeline, (JComponent)panel2);
        panel2.add((Component)sb, (Object)new TabularLayout.Constraint(3, 0, 0, 4, null));
        ResizingAxisComponentModel resizingAxisComponentModel = new ResizingAxisComponentModel.Builder(timeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).setGlobalRange(timeline.getDataRange()).build();
        Intrinsics.checkNotNullExpressionValue((Object)resizingAxisComponentModel, (String)"Builder(timeline.viewRan\u2026meline.dataRange).build()");
        ResizingAxisComponentModel viewAxis = resizingAxisComponentModel;
        JComponent timeAxis = this.buildTimeAxis(viewAxis);
        panel2.add((Component)timeAxis, (Object)new TabularLayout.Constraint(2, 0, 0, 4, null));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(LayoutKt.getMONITOR_BORDER());
        JLabel label = new JLabel(this.model.getName());
        label.setBorder(LayoutKt.getMONITOR_LABEL_PADDING());
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder((Border)JBUI.Borders.empty((int)LayoutKt.getY_AXIS_TOP_MARGIN(), (int)0, (int)0, (int)0));
        NetworkSpeedLineChartModel usage = this.model.getNetworkUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig receivedConfig = new LineConfig(ColorsKt.getNETWORK_RECEIVING_COLOR()).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getRxSeries(), receivedConfig);
        LineConfig sentConfig = new LineConfig(ColorsKt.getNETWORK_SENDING_COLOR()).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getTxSeries(), sentConfig);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, (Object)"Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent((AxisComponentModel)this.model.getTrafficAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setOnlyShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(LayoutKt.getMARKER_LENGTH(), LayoutKt.getMARKER_LENGTH());
        leftAxis.setMargins(0, LayoutKt.getY_AXIS_TOP_MARGIN());
        axisPanel.add((Component)leftAxis, (Object)"West");
        LegendsModel legends = this.model.getLegends();
        LegendComponent legendComponent = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(LayoutKt.getLEGEND_RIGHT_PADDING()).build();
        Intrinsics.checkNotNullExpressionValue((Object)legendComponent, (String)"Builder(legends).setRigh\u2026ND_RIGHT_PADDING).build()");
        LegendComponent legend = legendComponent;
        legend.configure((Legend)legends.getRxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getRxSeries())));
        legend.configure((Legend)legends.getTxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getTxSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, (Object)"West");
        legendPanel.add((Component)legend, (Object)"East");
        this.model.getRangeSelectionModel().addListener(new RangeSelectionListener(this){
            final /* synthetic */ NetworkInspectorView this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionCleared() {
                this.this$0.getModel().setSelectedConnection(null);
            }
        });
        selection.addMouseListener((MouseListener)new TooltipMouseAdapter(this.model, new Supplier(this){
            final /* synthetic */ NetworkInspectorView this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final TooltipModel get() {
                return new NetworkTrafficTooltipModel(this.this$0.getModel());
            }
        }));
        tooltip2.registerListenersOn((JComponent)selection);
        monitorPanel.add((Component)legendPanel, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        monitorPanel.add((Component)selection, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        monitorPanel.add((Component)axisPanel, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        monitorPanel.add((Component)lineChartPanel, (Object)new TabularLayout.Constraint(0, 0, 0, 4, null));
        layout.setRowSizing(1, "*");
        panel2.add((Component)monitorPanel, (Object)new TabularLayout.Constraint(1, 0, 0, 4, null));
        return (JPanel)panel2;
    }

    private final boolean hasTrafficUsage(RangedContinuousSeries series, Range range) {
        int maxIndex;
        boolean bl;
        List list2;
        block4: {
            list2 = series.getSeriesForRange(range);
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SeriesData data2 = (SeriesData)element$iv;
                    boolean bl2 = false;
                    if (!((double)data2.x >= range.getMin() && (double)data2.x <= range.getMax() && ((Number)data2.value).longValue() > 0L)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        Function1 getInsertPoint2 = (Function1)new Function1<Long, Integer>((List<SeriesData<Long>>)list2){
            final /* synthetic */ List<SeriesData<Long>> $list;
            {
                this.$list = $list;
                super(1);
            }

            @NotNull
            public final Integer invoke(long time2) {
                int index2 = Collections.binarySearch(this.$list, new SeriesData(time2, (Object)0L), (Comparator)hasTrafficUsage.getInsertPoint.index.1.INSTANCE);
                return index2 < 0 ? -(index2 + 1) : index2;
            }
        };
        int minIndex = ((Number)getInsertPoint2.invoke((Object)((long)range.getMin()))).intValue();
        return minIndex == (maxIndex = ((Number)getInsertPoint2.invoke((Object)((long)range.getMax()))).intValue()) ? minIndex > 0 && ((Number)((SeriesData)list2.get((int)(minIndex - 1))).value).longValue() > 0L && minIndex < list2.size() && ((Number)((SeriesData)list2.get((int)minIndex)).value).longValue() > 0L : false;
    }
}

