/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.model.httpdata;

import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.JavaThread;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.RequestHeader;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.ResponseHeader;
import com.android.tools.idea.protobuf.ByteString;
import com.intellij.util.io.URLUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 I2\u00020\u0001:\u0002IJB{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\r\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0015J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\rH\u00c6\u0003J\t\u00106\u001a\u00020\rH\u00c6\u0003J\t\u00107\u001a\u00020\u0012H\u00c6\u0003J\t\u00108\u001a\u00020\rH\u00c6\u0003J\t\u00109\u001a\u00020\u0012H\u00c2\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\t\u0010<\u001a\u00020\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\t\u0010>\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010@\u001a\u00020\rH\u00c6\u0003J\t\u0010A\u001a\u00020\rH\u00c6\u0003J\u009b\u0001\u0010B\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u00c6\u0001J\u0013\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010F\u001a\u00020GH\u00d6\u0001J\t\u0010H\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0017R\u0011\u0010\u0013\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001dR\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b.\u0010%R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001dR\u000e\u00102\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001d\u00a8\u0006K"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "", "id", "", "requestStartTimeUs", "requestCompleteTimeUs", "responseStartTimeUs", "responseCompleteTimeUs", "connectionEndTimeUs", "threads", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/JavaThread;", "url", "", "method", "trace", "requestFields", "requestPayload", "Lcom/android/tools/idea/protobuf/ByteString;", "responseFields", "rawResponsePayload", "(JJJJJJLjava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/idea/protobuf/ByteString;Ljava/lang/String;Lcom/android/tools/idea/protobuf/ByteString;)V", "getConnectionEndTimeUs", "()J", "getId", "javaThreads", "getJavaThreads", "()Ljava/util/List;", "getMethod", "()Ljava/lang/String;", "getRequestCompleteTimeUs", "getRequestFields", "requestHeader", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/RequestHeader;", "getRequestHeader", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/RequestHeader;", "getRequestPayload", "()Lcom/android/tools/idea/protobuf/ByteString;", "getRequestStartTimeUs", "getResponseCompleteTimeUs", "getResponseFields", "responseHeader", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/ResponseHeader;", "getResponseHeader", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/ResponseHeader;", "responsePayload", "getResponsePayload", "getResponseStartTimeUs", "getThreads", "getTrace", "unzippedResponsePayload", "getUrl", "component1", "component10", "component11", "component12", "component13", "component14", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "ContentType", "app-inspection.inspectors.network.model"})
public final class HttpData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long id;
    private final long requestStartTimeUs;
    private final long requestCompleteTimeUs;
    private final long responseStartTimeUs;
    private final long responseCompleteTimeUs;
    private final long connectionEndTimeUs;
    @NotNull
    private final List<JavaThread> threads;
    @NotNull
    private final String url;
    @NotNull
    private final String method;
    @NotNull
    private final String trace;
    @NotNull
    private final String requestFields;
    @NotNull
    private final ByteString requestPayload;
    @NotNull
    private final String responseFields;
    @NotNull
    private final ByteString rawResponsePayload;
    @NotNull
    private final List<JavaThread> javaThreads;
    @NotNull
    private final RequestHeader requestHeader;
    @NotNull
    private final ResponseHeader responseHeader;
    private ByteString unzippedResponsePayload;

    public HttpData(long id2, long requestStartTimeUs, long requestCompleteTimeUs, long responseStartTimeUs, long responseCompleteTimeUs, long connectionEndTimeUs, @NotNull List<JavaThread> threads, @NotNull String url, @NotNull String method2, @NotNull String trace, @NotNull String requestFields, @NotNull ByteString requestPayload, @NotNull String responseFields, @NotNull ByteString rawResponsePayload) {
        Intrinsics.checkNotNullParameter(threads, (String)"threads");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)requestFields, (String)"requestFields");
        Intrinsics.checkNotNullParameter((Object)requestPayload, (String)"requestPayload");
        Intrinsics.checkNotNullParameter((Object)responseFields, (String)"responseFields");
        Intrinsics.checkNotNullParameter((Object)rawResponsePayload, (String)"rawResponsePayload");
        this.id = id2;
        this.requestStartTimeUs = requestStartTimeUs;
        this.requestCompleteTimeUs = requestCompleteTimeUs;
        this.responseStartTimeUs = responseStartTimeUs;
        this.responseCompleteTimeUs = responseCompleteTimeUs;
        this.connectionEndTimeUs = connectionEndTimeUs;
        this.threads = threads;
        this.url = url;
        this.method = method2;
        this.trace = trace;
        this.requestFields = requestFields;
        this.requestPayload = requestPayload;
        this.responseFields = responseFields;
        this.rawResponsePayload = rawResponsePayload;
        this.javaThreads = this.threads;
        this.requestHeader = new RequestHeader(this.requestFields);
        this.responseHeader = new ResponseHeader(this.responseFields);
    }

    public final long getId() {
        return this.id;
    }

    public final long getRequestStartTimeUs() {
        return this.requestStartTimeUs;
    }

    public final long getRequestCompleteTimeUs() {
        return this.requestCompleteTimeUs;
    }

    public final long getResponseStartTimeUs() {
        return this.responseStartTimeUs;
    }

    public final long getResponseCompleteTimeUs() {
        return this.responseCompleteTimeUs;
    }

    public final long getConnectionEndTimeUs() {
        return this.connectionEndTimeUs;
    }

    @NotNull
    public final List<JavaThread> getThreads() {
        return this.threads;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final String getTrace() {
        return this.trace;
    }

    @NotNull
    public final String getRequestFields() {
        return this.requestFields;
    }

    @NotNull
    public final ByteString getRequestPayload() {
        return this.requestPayload;
    }

    @NotNull
    public final String getResponseFields() {
        return this.responseFields;
    }

    @NotNull
    public final List<JavaThread> getJavaThreads() {
        return this.javaThreads;
    }

    @NotNull
    public final RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @NotNull
    public final ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ByteString getResponsePayload() {
        ByteString byteString;
        if (this.unzippedResponsePayload != null) {
            ByteString byteString2 = this.unzippedResponsePayload;
            if (byteString2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"unzippedResponsePayload");
                byteString2 = null;
            }
            return byteString2;
        }
        String string = this.responseHeader.getField("content-encoding").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"gzip", (boolean)false, (int)2, null)) {
            try {
                Closeable closeable = new GZIPInputStream(new ByteArrayInputStream(this.rawResponsePayload.toByteArray()));
                Throwable throwable = null;
                try {
                    GZIPInputStream inputStream = (GZIPInputStream)closeable;
                    boolean bl = false;
                    ByteString byteString3 = ByteString.copyFrom((byte[])ByteStreamsKt.readBytes((InputStream)inputStream));
                    Intrinsics.checkNotNullExpressionValue((Object)byteString3, (String)"copyFrom(inputStream.readBytes())");
                    this.unzippedResponsePayload = byteString3;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException ignored) {
                this.unzippedResponsePayload = this.rawResponsePayload;
            }
        } else {
            this.unzippedResponsePayload = this.rawResponsePayload;
        }
        if ((byteString = this.unzippedResponsePayload) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unzippedResponsePayload");
            byteString = null;
        }
        return byteString;
    }

    public final long component1() {
        return this.id;
    }

    public final long component2() {
        return this.requestStartTimeUs;
    }

    public final long component3() {
        return this.requestCompleteTimeUs;
    }

    public final long component4() {
        return this.responseStartTimeUs;
    }

    public final long component5() {
        return this.responseCompleteTimeUs;
    }

    public final long component6() {
        return this.connectionEndTimeUs;
    }

    @NotNull
    public final List<JavaThread> component7() {
        return this.threads;
    }

    @NotNull
    public final String component8() {
        return this.url;
    }

    @NotNull
    public final String component9() {
        return this.method;
    }

    @NotNull
    public final String component10() {
        return this.trace;
    }

    @NotNull
    public final String component11() {
        return this.requestFields;
    }

    @NotNull
    public final ByteString component12() {
        return this.requestPayload;
    }

    @NotNull
    public final String component13() {
        return this.responseFields;
    }

    private final ByteString component14() {
        return this.rawResponsePayload;
    }

    @NotNull
    public final HttpData copy(long id2, long requestStartTimeUs, long requestCompleteTimeUs, long responseStartTimeUs, long responseCompleteTimeUs, long connectionEndTimeUs, @NotNull List<JavaThread> threads, @NotNull String url, @NotNull String method2, @NotNull String trace, @NotNull String requestFields, @NotNull ByteString requestPayload, @NotNull String responseFields, @NotNull ByteString rawResponsePayload) {
        Intrinsics.checkNotNullParameter(threads, (String)"threads");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)requestFields, (String)"requestFields");
        Intrinsics.checkNotNullParameter((Object)requestPayload, (String)"requestPayload");
        Intrinsics.checkNotNullParameter((Object)responseFields, (String)"responseFields");
        Intrinsics.checkNotNullParameter((Object)rawResponsePayload, (String)"rawResponsePayload");
        return new HttpData(id2, requestStartTimeUs, requestCompleteTimeUs, responseStartTimeUs, responseCompleteTimeUs, connectionEndTimeUs, threads, url, method2, trace, requestFields, requestPayload, responseFields, rawResponsePayload);
    }

    public static /* synthetic */ HttpData copy$default(HttpData httpData, long l, long l2, long l3, long l4, long l5, long l6, List list2, String string, String string2, String string3, String string4, ByteString byteString, String string5, ByteString byteString2, int n, Object object) {
        if ((n & 1) != 0) {
            l = httpData.id;
        }
        if ((n & 2) != 0) {
            l2 = httpData.requestStartTimeUs;
        }
        if ((n & 4) != 0) {
            l3 = httpData.requestCompleteTimeUs;
        }
        if ((n & 8) != 0) {
            l4 = httpData.responseStartTimeUs;
        }
        if ((n & 0x10) != 0) {
            l5 = httpData.responseCompleteTimeUs;
        }
        if ((n & 0x20) != 0) {
            l6 = httpData.connectionEndTimeUs;
        }
        if ((n & 0x40) != 0) {
            list2 = httpData.threads;
        }
        if ((n & 0x80) != 0) {
            string = httpData.url;
        }
        if ((n & 0x100) != 0) {
            string2 = httpData.method;
        }
        if ((n & 0x200) != 0) {
            string3 = httpData.trace;
        }
        if ((n & 0x400) != 0) {
            string4 = httpData.requestFields;
        }
        if ((n & 0x800) != 0) {
            byteString = httpData.requestPayload;
        }
        if ((n & 0x1000) != 0) {
            string5 = httpData.responseFields;
        }
        if ((n & 0x2000) != 0) {
            byteString2 = httpData.rawResponsePayload;
        }
        return httpData.copy(l, l2, l3, l4, l5, l6, list2, string, string2, string3, string4, byteString, string5, byteString2);
    }

    @NotNull
    public String toString() {
        return "HttpData(id=" + this.id + ", requestStartTimeUs=" + this.requestStartTimeUs + ", requestCompleteTimeUs=" + this.requestCompleteTimeUs + ", responseStartTimeUs=" + this.responseStartTimeUs + ", responseCompleteTimeUs=" + this.responseCompleteTimeUs + ", connectionEndTimeUs=" + this.connectionEndTimeUs + ", threads=" + this.threads + ", url=" + this.url + ", method=" + this.method + ", trace=" + this.trace + ", requestFields=" + this.requestFields + ", requestPayload=" + this.requestPayload + ", responseFields=" + this.responseFields + ", rawResponsePayload=" + this.rawResponsePayload + ")";
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.id);
        result2 = result2 * 31 + Long.hashCode(this.requestStartTimeUs);
        result2 = result2 * 31 + Long.hashCode(this.requestCompleteTimeUs);
        result2 = result2 * 31 + Long.hashCode(this.responseStartTimeUs);
        result2 = result2 * 31 + Long.hashCode(this.responseCompleteTimeUs);
        result2 = result2 * 31 + Long.hashCode(this.connectionEndTimeUs);
        result2 = result2 * 31 + ((Object)this.threads).hashCode();
        result2 = result2 * 31 + this.url.hashCode();
        result2 = result2 * 31 + this.method.hashCode();
        result2 = result2 * 31 + this.trace.hashCode();
        result2 = result2 * 31 + this.requestFields.hashCode();
        result2 = result2 * 31 + this.requestPayload.hashCode();
        result2 = result2 * 31 + this.responseFields.hashCode();
        result2 = result2 * 31 + this.rawResponsePayload.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpData)) {
            return false;
        }
        HttpData httpData = (HttpData)other;
        if (this.id != httpData.id) {
            return false;
        }
        if (this.requestStartTimeUs != httpData.requestStartTimeUs) {
            return false;
        }
        if (this.requestCompleteTimeUs != httpData.requestCompleteTimeUs) {
            return false;
        }
        if (this.responseStartTimeUs != httpData.responseStartTimeUs) {
            return false;
        }
        if (this.responseCompleteTimeUs != httpData.responseCompleteTimeUs) {
            return false;
        }
        if (this.connectionEndTimeUs != httpData.connectionEndTimeUs) {
            return false;
        }
        if (!Intrinsics.areEqual(this.threads, httpData.threads)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)httpData.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)httpData.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.trace, (Object)httpData.trace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestFields, (Object)httpData.requestFields)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestPayload, (Object)httpData.requestPayload)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseFields, (Object)httpData.responseFields)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.rawResponsePayload, (Object)httpData.rawResponsePayload);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData$ContentType;", "", "contentType", "", "(Ljava/lang/String;)V", "isEmpty", "", "()Z", "isFormData", "mimeType", "getMimeType", "()Ljava/lang/String;", "toString", "app-inspection.inspectors.network.model"})
    public static final class ContentType {
        @NotNull
        private final String contentType;
        private final boolean isEmpty;
        @NotNull
        private final String mimeType;
        private final boolean isFormData;

        public ContentType(@NotNull String contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            this.contentType = contentType;
            this.isEmpty = ((CharSequence)this.contentType).length() == 0;
            char[] cArray = new char[]{';'};
            this.mimeType = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.contentType, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            this.isFormData = StringsKt.equals((String)this.mimeType, (String)"application/x-www-form-urlencoded", (boolean)true);
        }

        public final boolean isEmpty() {
            return this.isEmpty;
        }

        @NotNull
        public final String getMimeType() {
            return this.mimeType;
        }

        @NotNull
        public String toString() {
            return this.contentType;
        }

        public final boolean isFormData() {
            return this.isFormData;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u008a\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData$Companion;", "", "()V", "createHttpData", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "id", "", "requestStartTimeUs", "requestCompleteTimeUs", "responseStartTimeUs", "responseCompleteTimeUs", "connectionEndTimeUs", "threads", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/JavaThread;", "url", "", "method", "trace", "requestFields", "requestPayload", "Lcom/android/tools/idea/protobuf/ByteString;", "responseFields", "responsePayload", "decodeUrlName", "name", "getUrlName", "lastComponent", "app-inspection.inspectors.network.model"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HttpData createHttpData(long id2, long requestStartTimeUs, long requestCompleteTimeUs, long responseStartTimeUs, long responseCompleteTimeUs, long connectionEndTimeUs, @NotNull List<JavaThread> threads, @NotNull String url, @NotNull String method2, @NotNull String trace, @NotNull String requestFields, @NotNull ByteString requestPayload, @NotNull String responseFields, @NotNull ByteString responsePayload) {
            void $this$distinctBy$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter(threads, (String)"threads");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)requestFields, (String)"requestFields");
            Intrinsics.checkNotNullParameter((Object)requestPayload, (String)"requestPayload");
            Intrinsics.checkNotNullParameter((Object)responseFields, (String)"responseFields");
            Intrinsics.checkNotNullParameter((Object)responsePayload, (String)"responsePayload");
            boolean bl2 = bl = !((Collection)threads).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-HttpData$Companion$createHttpData$22 = false;
                String $i$a$-assert-HttpData$Companion$createHttpData$22 = "HttpData must be initialized with at least one thread";
                throw new AssertionError((Object)$i$a$-assert-HttpData$Companion$createHttpData$22);
            }
            Iterable iterable = threads;
            long l = connectionEndTimeUs;
            long l2 = responseCompleteTimeUs;
            long l3 = responseStartTimeUs;
            long l4 = requestCompleteTimeUs;
            long l5 = requestStartTimeUs;
            long l6 = id2;
            boolean $i$f$distinctBy = false;
            HashSet<Long> set$iv = new HashSet<Long>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                JavaThread it = (JavaThread)e$iv;
                boolean bl3 = false;
                Long key$iv = it.getId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List list2 = list$iv;
            ByteString byteString = responsePayload;
            String string = responseFields;
            ByteString byteString2 = requestPayload;
            String string2 = requestFields;
            String string3 = trace;
            String string4 = method2;
            String string5 = url;
            List list3 = list2;
            long l7 = l;
            long l8 = l2;
            long l9 = l3;
            long l10 = l4;
            long l11 = l5;
            long l12 = l6;
            return new HttpData(l12, l11, l10, l9, l8, l7, list3, string5, string4, string3, string2, byteString2, string, byteString);
        }

        public static /* synthetic */ HttpData createHttpData$default(Companion companion, long l, long l2, long l3, long l4, long l5, long l6, List list2, String string, String string2, String string3, String string4, ByteString byteString, String string5, ByteString byteString2, int n, Object object) {
            if ((n & 0x80) != 0) {
                string = "";
            }
            if ((n & 0x100) != 0) {
                string2 = "";
            }
            if ((n & 0x200) != 0) {
                string3 = "";
            }
            if ((n & 0x400) != 0) {
                string4 = "";
            }
            if ((n & 0x800) != 0) {
                ByteString byteString3 = ByteString.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)byteString3, (String)"EMPTY");
                byteString = byteString3;
            }
            if ((n & 0x1000) != 0) {
                string5 = "";
            }
            if ((n & 0x2000) != 0) {
                ByteString byteString4 = ByteString.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)byteString4, (String)"EMPTY");
                byteString2 = byteString4;
            }
            return companion.createHttpData(l, l2, l3, l4, l5, l6, list2, string, string2, string3, string4, byteString, string5, byteString2);
        }

        @NotNull
        public final String getUrlName(@NotNull String url) {
            String string;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            try {
                String string2;
                block8: {
                    URI uri;
                    block5: {
                        Object object;
                        block7: {
                            String lastComponent;
                            block6: {
                                uri = URI.create(URLEncoder.encode(url, "UTF-8"));
                                if (uri.getPath() == null) break block5;
                                String string3 = uri.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"uri.path");
                                lastComponent = this.lastComponent(string3);
                                object = uri.getQuery();
                                if (object == null) break block6;
                                String it = object;
                                boolean bl = false;
                                String string4 = lastComponent + "?" + uri.getQuery();
                                object = string4;
                                if (string4 != null) break block7;
                            }
                            object = lastComponent;
                        }
                        String fullname = object;
                        string2 = this.decodeUrlName(fullname);
                        break block8;
                    }
                    string2 = uri.getHost();
                }
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n        // Run encode \u2026ri.host\n        }\n      }");
            }
            catch (UnsupportedEncodingException ignored) {
                string = this.lastComponent(url);
            }
            catch (IllegalArgumentException ignored) {
                string = this.lastComponent(url);
            }
            return string;
        }

        private final String lastComponent(String url) {
            char[] cArray = new char[]{'/'};
            return StringsKt.substringAfterLast$default((String)StringsKt.trimEnd((String)url, (char[])cArray), (char)'/', null, (int)2, null);
        }

        private final String decodeUrlName(String name) {
            String currentName = name;
            String lastName = null;
            do {
                lastName = currentName;
                Intrinsics.checkNotNullExpressionValue((Object)URLUtil.decode((String)currentName), (String)"decode(currentName)");
            } while (!Intrinsics.areEqual((Object)currentName, (Object)lastName));
            return currentName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

