/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.model;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorDataSeries;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorDataSource;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkTrafficLabel;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import studio.network.inspection.NetworkInspectorProtocol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkSpeedLineChartModel;", "Lcom/android/tools/adtui/model/LineChartModel;", "timeline", "Lcom/android/tools/adtui/model/StreamingTimeline;", "dataSource", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorDataSource;", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/adtui/model/StreamingTimeline;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorDataSource;Ljava/util/concurrent/Executor;)V", "rxSeries", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "getRxSeries", "()Lcom/android/tools/adtui/model/RangedContinuousSeries;", "trafficRange", "Lcom/android/tools/adtui/model/Range;", "getTrafficRange", "()Lcom/android/tools/adtui/model/Range;", "txSeries", "getTxSeries", "createSeries", "Lcom/android/tools/adtui/model/DataSeries;", "", "trafficType", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkTrafficLabel;", "app-inspection.inspectors.network.model"})
public final class NetworkSpeedLineChartModel
extends LineChartModel {
    @NotNull
    private final NetworkInspectorDataSource dataSource;
    @NotNull
    private final Range trafficRange;
    @NotNull
    private final RangedContinuousSeries rxSeries;
    @NotNull
    private final RangedContinuousSeries txSeries;

    public NetworkSpeedLineChartModel(@NotNull StreamingTimeline timeline, @NotNull NetworkInspectorDataSource dataSource, @NotNull Executor backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        super(backgroundExecutor);
        this.dataSource = dataSource;
        this.trafficRange = new Range(0.0, 4.0);
        String string = NetworkTrafficLabel.BYTES_RECEIVED.getLabel(false);
        Range range = timeline.getViewRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"timeline.viewRange");
        DataSeries<Long> dataSeries = this.createSeries(NetworkTrafficLabel.BYTES_RECEIVED);
        Range range2 = timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"timeline.dataRange");
        this.rxSeries = new RangedContinuousSeries(string, range, this.trafficRange, dataSeries, range2);
        String string2 = NetworkTrafficLabel.BYTES_SENT.getLabel(false);
        Range range3 = timeline.getViewRange();
        Intrinsics.checkNotNullExpressionValue((Object)range3, (String)"timeline.viewRange");
        DataSeries<Long> dataSeries2 = this.createSeries(NetworkTrafficLabel.BYTES_SENT);
        Range range4 = timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"timeline.dataRange");
        this.txSeries = new RangedContinuousSeries(string2, range3, this.trafficRange, dataSeries2, range4);
        this.add(this.rxSeries);
        this.add(this.txSeries);
    }

    @NotNull
    public final Range getTrafficRange() {
        return this.trafficRange;
    }

    @NotNull
    public final RangedContinuousSeries getRxSeries() {
        return this.rxSeries;
    }

    @NotNull
    public final RangedContinuousSeries getTxSeries() {
        return this.txSeries;
    }

    private final DataSeries<Long> createSeries(NetworkTrafficLabel trafficType) {
        return new NetworkInspectorDataSeries(this.dataSource, (Function1)new Function1<NetworkInspectorProtocol.Event, Long>(trafficType){
            final /* synthetic */ NetworkTrafficLabel $trafficType;
            {
                this.$trafficType = $trafficType;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull NetworkInspectorProtocol.Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return this.$trafficType == NetworkTrafficLabel.BYTES_RECEIVED ? event.getSpeedEvent().getRxSpeed() : event.getSpeedEvent().getTxSpeed();
            }
        });
    }
}

