/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.view.table;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskInspectorClient;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskTreeModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntrySelectionModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.AlarmEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.JobEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WakeLockEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WorkEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskInspectorTab;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryFormatUtilKt;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.table.BackgroundTaskTreeTableViewKt;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/table/BackgroundTaskTreeTableView;", "", "tab", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;", "client", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;", "selectionModel", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "uiDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "expandedPaths", "", "Ljavax/swing/tree/TreePath;", "getExpandedPaths", "()Ljava/util/Set;", "treeModel", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskTreeModel;", "getTreeModel", "()Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskTreeModel;", "restoreExpandedPaths", "", "tree", "Ljavax/swing/JTree;", "app-inspection.inspectors.backgroundtask.view"})
public final class BackgroundTaskTreeTableView {
    @NotNull
    private final JComponent component;
    @NotNull
    private final BackgroundTaskTreeModel treeModel;
    @NotNull
    private final Set<TreePath> expandedPaths;

    public BackgroundTaskTreeTableView(final @NotNull BackgroundTaskInspectorTab tab, final @NotNull BackgroundTaskInspectorClient client2, final @NotNull EntrySelectionModel selectionModel, @NotNull CoroutineScope scope2, @NotNull CoroutineDispatcher uiDispatcher) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)uiDispatcher, (String)"uiDispatcher");
        this.treeModel = new BackgroundTaskTreeModel(client2, scope2, uiDispatcher);
        this.expandedPaths = new LinkedHashSet();
        final JTree tree2 = new JTree(this.treeModel);
        tree2.setRootVisible(false);
        tree2.setRowHeight(0);
        tree2.getSelectionModel().setSelectionMode(1);
        this.treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeStructureChanged(@NotNull TreeModelEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.treeStructureChanged(event);
                tree2.expandPath(event.getTreePath());
            }
        });
        tree2.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Set<TreePath> set = this.getExpandedPaths();
                TreePath treePath = event.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"event.path");
                set.add(treePath);
            }

            @Override
            public void treeCollapsed(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getExpandedPaths().remove(event.getPath());
            }
        });
        this.treeModel.addOnFilteredListener((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@Nullable String it) {
                this.restoreExpandedPaths(tree2);
            }
        }));
        tree2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JTree");
                JTree tree2 = (JTree)object;
                int row2 = tree2.getClosestRowForLocation(e.getX(), e.getY());
                Rectangle bounds = tree2.getRowBounds(row2);
                Rectangle tableBounds = new Rectangle(0, bounds.y, bounds.width + bounds.x, bounds.height);
                if (tableBounds.contains(e.getPoint())) {
                    TreePath path2 = tree2.getPathForRow(row2);
                    Object object2 = path2.getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode = object2 instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object2 : null;
                    if ((defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null) instanceof BackgroundTaskEntry) {
                        tab.setDetailsViewVisible(true);
                    }
                }
            }
        });
        tree2.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent event) {
                if (event.isAddedPath()) {
                    Object object = event.getPath().getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = defaultMutableTreeNode;
                    Object object2 = node.getUserObject();
                    BackgroundTaskEntry backgroundTaskEntry = object2 instanceof BackgroundTaskEntry ? (BackgroundTaskEntry)object2 : null;
                    if (backgroundTaskEntry == null) {
                        return;
                    }
                    BackgroundTaskEntry entry = backgroundTaskEntry;
                    selectionModel.setSelectedEntry(entry);
                    object = entry;
                    if (object instanceof AlarmEntry) {
                        client2.getTracker().trackAlarmSelected();
                    } else if (object instanceof JobEntry) {
                        if (((JobEntry)entry).getTargetWorkId() == null) {
                            client2.getTracker().trackJobSelected();
                        } else {
                            client2.getTracker().trackJobUnderWorkSelected();
                        }
                    } else if (object instanceof WorkEntry) {
                        client2.getTracker().trackWorkSelected(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TABLE_CONTEXT);
                    } else if (object instanceof WakeLockEntry) {
                        client2.getTracker().trackWakeLockSelected();
                    }
                } else {
                    BackgroundTaskEntry backgroundTaskEntry = selectionModel.getSelectedEntry();
                    if (backgroundTaskEntry == null) {
                        return;
                    }
                    BackgroundTaskEntry entry = backgroundTaskEntry;
                    DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeModel().getTreeNode(entry.getId());
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = defaultMutableTreeNode;
                    TreePath treePath = new TreePath(node.getPath());
                    if (tree2.isExpanded(treePath)) {
                        tree2.getSelectionModel().setSelectionPath(treePath);
                    }
                }
            }
        });
        selectionModel.registerEntrySelectionListener((Function1<? super BackgroundTaskEntry, Unit>)((Function1)new Function1<BackgroundTaskEntry, Unit>(){

            public final void invoke(@Nullable BackgroundTaskEntry entry) {
                if (entry == null) {
                    TreePath treePath = tree2.getSelectionPath();
                    JTree jTree = tree2;
                    TreePath $this$invoke_u24lambda_u2d0 = treePath;
                    boolean bl = false;
                    jTree.removeSelectionPath($this$invoke_u24lambda_u2d0);
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeModel().getTreeNode(entry.getId());
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = defaultMutableTreeNode;
                    tree2.getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
                    tree2.scrollPathToVisible(tree2.getSelectionModel().getSelectionPath());
                }
            }
        }));
        ColumnTreeBuilder builder2 = new ColumnTreeBuilder(tree2).setShowVerticalLines(true).setBorder(BorderFactory.createEmptyBorder()).setTreeSorter(new ColumnTreeBuilder.TreeSorter(this){
            final /* synthetic */ BackgroundTaskTreeTableView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void sort(Comparator<Object> comparator2, SortOrder sortOrder) {
                if (comparator2 != null) {
                    this.this$0.getTreeModel().sort(comparator2);
                }
            }
        });
        builder2.setHeaderRowCellRenderer((TreeCellRenderer)7.INSTANCE);
        builder2.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.getTABLE_COLUMN_HEADER_BORDER()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (data2 instanceof BackgroundTaskEntry) {
                    this.append(((BackgroundTaskEntry)data2).getClassName());
                } else if (data2 instanceof String) {
                    this.append((String)data2);
                }
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getCLASS_NAME_COMPARATOR()));
        builder2.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Status").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.getTABLE_COLUMN_HEADER_BORDER()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (data2 instanceof BackgroundTaskEntry) {
                    this.append(EntryFormatUtilKt.capitalizedName(((BackgroundTaskEntry)data2).getStatus()));
                    Icon stateIcon = EntryFormatUtilKt.icon((BackgroundTaskEntry)data2);
                    this.setIcon(selected && stateIcon != null ? ColoredIconGenerator.generateWhiteIcon((Icon)stateIcon) : stateIcon);
                }
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getSTATUS_COMPARATOR()));
        builder2.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Start").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.getTABLE_COLUMN_HEADER_BORDER()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (data2 instanceof BackgroundTaskEntry) {
                    this.append(EntryFormatUtilKt.toFormattedTimeString(((BackgroundTaskEntry)data2).getStartTimeMs()));
                }
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getSTART_TIME_COMPARATOR()));
        builder2.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Retries").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.getTABLE_COLUMN_HEADER_BORDER()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (data2 instanceof WorkEntry ? true : data2 instanceof JobEntry) {
                    Intrinsics.checkNotNull((Object)data2, (String)"null cannot be cast to non-null type com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry");
                    this.append(String.valueOf(((BackgroundTaskEntry)data2).getRetries()));
                } else {
                    this.append("-");
                }
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getSTART_TIME_COMPARATOR()));
        JComponent jComponent = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"builder.build()");
        this.component = jComponent;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final BackgroundTaskTreeModel getTreeModel() {
        return this.treeModel;
    }

    @NotNull
    public final Set<TreePath> getExpandedPaths() {
        return this.expandedPaths;
    }

    private final void restoreExpandedPaths(JTree tree2) {
        for (TreePath path2 : this.expandedPaths) {
            tree2.expandPath(path2);
        }
    }
}

