/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries;

import backgroundtask.inspection.BackgroundTaskInspectorProtocol;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskUtilKt;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EventWrapper;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskCallStack;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000f\"\u0004\b\u001f\u0010\u0011R\u0014\u0010 \u001a\u00020!X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0019R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0016\u00a8\u00060"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WakeLockEntry;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskEntry;", "id", "", "(Ljava/lang/String;)V", "_className", "_isValid", "", "_startTime", "", "_status", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WakeLockEntry$State;", "acquired", "Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$Event;", "getAcquired", "()Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$Event;", "setAcquired", "(Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$Event;)V", "callstacks", "", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskCallStack;", "getCallstacks", "()Ljava/util/List;", "className", "getClassName", "()Ljava/lang/String;", "getId", "isValid", "()Z", "released", "getReleased", "setReleased", "retries", "", "getRetries", "()I", "startTimeMs", "getStartTimeMs", "()J", "status", "getStatus", "tags", "getTags", "consume", "", "eventWrapper", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EventWrapper;", "State", "app-inspection.inspectors.backgroundtask.model"})
public final class WakeLockEntry
implements BackgroundTaskEntry {
    @NotNull
    private final String id;
    @NotNull
    private String _className;
    @NotNull
    private State _status;
    private long _startTime;
    private boolean _isValid;
    @NotNull
    private final List<String> tags;
    @NotNull
    private final List<BackgroundTaskCallStack> callstacks;
    private final int retries;
    @Nullable
    private BackgroundTaskInspectorProtocol.Event acquired;
    @Nullable
    private BackgroundTaskInspectorProtocol.Event released;

    public WakeLockEntry(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.id = id2;
        this._className = "";
        this._status = State.UNSPECIFIED;
        this._startTime = -1L;
        this.tags = new ArrayList();
        this.callstacks = new ArrayList();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this._isValid;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this._className;
    }

    @Override
    @NotNull
    public String getStatus() {
        return this._status.name();
    }

    @Override
    public long getStartTimeMs() {
        return this._startTime;
    }

    @Override
    @NotNull
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @NotNull
    public List<BackgroundTaskCallStack> getCallstacks() {
        return this.callstacks;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Nullable
    public final BackgroundTaskInspectorProtocol.Event getAcquired() {
        return this.acquired;
    }

    public final void setAcquired(@Nullable BackgroundTaskInspectorProtocol.Event event) {
        this.acquired = event;
    }

    @Nullable
    public final BackgroundTaskInspectorProtocol.Event getReleased() {
        return this.released;
    }

    public final void setReleased(@Nullable BackgroundTaskInspectorProtocol.Event event) {
        this.released = event;
    }

    @Override
    public void consume(@NotNull EventWrapper eventWrapper) {
        Intrinsics.checkNotNullParameter((Object)eventWrapper, (String)"eventWrapper");
        BackgroundTaskInspectorProtocol.Event backgroundTaskEvent = eventWrapper.getBackgroundTaskEvent();
        long timestamp = eventWrapper.getBackgroundTaskEvent().getTimestamp();
        BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase metadataCase = backgroundTaskEvent.getBackgroundTaskEvent().getMetadataCase();
        switch (metadataCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metadataCase.ordinal()]) {
            case 1: {
                this._isValid = true;
                this.acquired = backgroundTaskEvent;
                String string = backgroundTaskEvent.getBackgroundTaskEvent().getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backgroundTaskEvent.backgroundTaskEvent.stacktrace");
                Object object = BackgroundTaskUtilKt.getTopExternalClassSimpleName(string, "android.os.PowerManager$WakeLock");
                if (object == null) {
                    object = "WakeLock " + this.getId();
                }
                this._className = object;
                this._status = State.ACQUIRED;
                this._startTime = timestamp;
                List<String> list2 = this.getTags();
                BackgroundTaskInspectorProtocol.Event event = this.acquired;
                Intrinsics.checkNotNull((Object)event);
                String string2 = event.getBackgroundTaskEvent().getWakeLockAcquired().getTag();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"acquired!!.backgroundTas\u2026vent.wakeLockAcquired.tag");
                list2.add(string2);
                this.getCallstacks().clear();
                List<BackgroundTaskCallStack> list3 = this.getCallstacks();
                String string3 = backgroundTaskEvent.getBackgroundTaskEvent().getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"backgroundTaskEvent.backgroundTaskEvent.stacktrace");
                list3.add(new BackgroundTaskCallStack(timestamp, string3));
                break;
            }
            case 2: {
                this.released = backgroundTaskEvent;
                this._status = State.RELEASED;
                List<BackgroundTaskCallStack> list4 = this.getCallstacks();
                String string = backgroundTaskEvent.getBackgroundTaskEvent().getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backgroundTaskEvent.backgroundTaskEvent.stacktrace");
                list4.add(new BackgroundTaskCallStack(timestamp, string));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WakeLockEntry$State;", "", "(Ljava/lang/String;I)V", "ACQUIRED", "RELEASED", "UNSPECIFIED", "app-inspection.inspectors.backgroundtask.model"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State ACQUIRED = new State();
        public static final /* enum */ State RELEASED = new State();
        public static final /* enum */ State UNSPECIFIED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.ACQUIRED, State.RELEASED, State.UNSPECIFIED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.values().length];
            nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.WAKE_LOCK_ACQUIRED.ordinal()] = 1;
            nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.WAKE_LOCK_RELEASED.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

