/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries;

import backgroundtask.inspection.BackgroundTaskInspectorProtocol;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskUtilKt;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EventWrapper;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskCallStack;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001bR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0010\u00a8\u00063"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskEntry;", "id", "", "(Ljava/lang/String;)V", "_className", "_isValid", "", "_startTime", "", "_status", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry$State;", "_tags", "", "alarmFiredTimestamps", "getAlarmFiredTimestamps", "()Ljava/util/List;", "<set-?>", "Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$AlarmSet;", "alarmSet", "getAlarmSet", "()Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$AlarmSet;", "callstacks", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskCallStack;", "getCallstacks", "className", "getClassName", "()Ljava/lang/String;", "getId", "isValid", "()Z", "Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$Event;", "latestEvent", "getLatestEvent", "()Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$Event;", "retries", "", "getRetries", "()I", "startTimeMs", "getStartTimeMs", "()J", "status", "getStatus", "tags", "getTags", "consume", "", "eventWrapper", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EventWrapper;", "State", "app-inspection.inspectors.backgroundtask.model"})
public final class AlarmEntry
implements BackgroundTaskEntry {
    @NotNull
    private final String id;
    @NotNull
    private String _className;
    @NotNull
    private State _status;
    private long _startTime;
    private boolean _isValid;
    @NotNull
    private List<String> _tags;
    @NotNull
    private final List<BackgroundTaskCallStack> callstacks;
    private final int retries;
    @Nullable
    private BackgroundTaskInspectorProtocol.AlarmSet alarmSet;
    @NotNull
    private final List<Long> alarmFiredTimestamps;
    @Nullable
    private BackgroundTaskInspectorProtocol.Event latestEvent;

    public AlarmEntry(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.id = id2;
        this._className = "";
        this._status = State.UNSPECIFIED;
        this._startTime = -1L;
        this._tags = new ArrayList();
        this.callstacks = new ArrayList();
        this.alarmFiredTimestamps = new ArrayList();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this._isValid;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this._className;
    }

    @Override
    @NotNull
    public String getStatus() {
        return this._status.name();
    }

    @Override
    public long getStartTimeMs() {
        return this._startTime;
    }

    @Override
    @NotNull
    public List<String> getTags() {
        return this._tags;
    }

    @Override
    @NotNull
    public List<BackgroundTaskCallStack> getCallstacks() {
        return this.callstacks;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Nullable
    public final BackgroundTaskInspectorProtocol.AlarmSet getAlarmSet() {
        return this.alarmSet;
    }

    @NotNull
    public final List<Long> getAlarmFiredTimestamps() {
        return this.alarmFiredTimestamps;
    }

    @Nullable
    public final BackgroundTaskInspectorProtocol.Event getLatestEvent() {
        return this.latestEvent;
    }

    @Override
    public void consume(@NotNull EventWrapper eventWrapper) {
        Intrinsics.checkNotNullParameter((Object)eventWrapper, (String)"eventWrapper");
        this.latestEvent = eventWrapper.getBackgroundTaskEvent();
        long timestamp = eventWrapper.getBackgroundTaskEvent().getTimestamp();
        BackgroundTaskInspectorProtocol.Event event = this.latestEvent;
        Intrinsics.checkNotNull((Object)event);
        BackgroundTaskInspectorProtocol.BackgroundTaskEvent backgroundTaskEvent = event.getBackgroundTaskEvent();
        BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase metadataCase = backgroundTaskEvent.getMetadataCase();
        switch (metadataCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metadataCase.ordinal()]) {
            case 1: {
                this._isValid = true;
                this.alarmSet = backgroundTaskEvent.getAlarmSet();
                String string = backgroundTaskEvent.getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backgroundTaskEvent.stacktrace");
                Object object = BackgroundTaskUtilKt.getTopExternalClassSimpleName(string, "android.app.AlarmManager");
                if (object == null) {
                    object = "Alarm " + this.getId();
                }
                this._className = object;
                this._status = State.SET;
                BackgroundTaskInspectorProtocol.Event event2 = this.latestEvent;
                Intrinsics.checkNotNull((Object)event2);
                this._startTime = event2.getTimestamp();
                BackgroundTaskInspectorProtocol.AlarmSet alarmSet = this.alarmSet;
                Intrinsics.checkNotNull((Object)alarmSet);
                if (alarmSet.hasListener()) {
                    BackgroundTaskInspectorProtocol.AlarmSet alarmSet2 = this.alarmSet;
                    Intrinsics.checkNotNull((Object)alarmSet2);
                    String string2 = alarmSet2.getListener().getTag();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"alarmSet!!.listener.tag");
                    this._tags.add(string2);
                }
                this.getCallstacks().clear();
                List<BackgroundTaskCallStack> list2 = this.getCallstacks();
                String string3 = backgroundTaskEvent.getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"backgroundTaskEvent.stacktrace");
                list2.add(new BackgroundTaskCallStack(timestamp, string3));
                break;
            }
            case 2: {
                this._status = State.CANCELLED;
                List<BackgroundTaskCallStack> list3 = this.getCallstacks();
                String string = backgroundTaskEvent.getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backgroundTaskEvent.stacktrace");
                list3.add(new BackgroundTaskCallStack(timestamp, string));
                break;
            }
            case 3: {
                this._status = State.FIRED;
                BackgroundTaskInspectorProtocol.Event event3 = this.latestEvent;
                Intrinsics.checkNotNull((Object)event3);
                this.alarmFiredTimestamps.add(event3.getTimestamp());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry$State;", "", "(Ljava/lang/String;I)V", "SET", "CANCELLED", "FIRED", "UNSPECIFIED", "app-inspection.inspectors.backgroundtask.model"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State SET = new State();
        public static final /* enum */ State CANCELLED = new State();
        public static final /* enum */ State FIRED = new State();
        public static final /* enum */ State UNSPECIFIED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.SET, State.CANCELLED, State.FIRED, State.UNSPECIFIED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.values().length];
            nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.ALARM_SET.ordinal()] = 1;
            nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.ALARM_CANCELLED.ordinal()] = 2;
            nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.ALARM_FIRED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

