/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.ide;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskInspectorTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u0019\u001a\u00020\f*\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/ide/IdeBackgroundTaskInspectorTracker;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activeMode", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$BackgroundTaskInspectorEvent$Mode;", "track", "", "context", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$BackgroundTaskInspectorEvent$Context;", "inspectorEvent", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$BackgroundTaskInspectorEvent$Builder;", "trackAlarmSelected", "trackGraphModeSelected", "chainInfo", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$BackgroundTaskInspectorEvent$ChainInfo;", "trackJobSelected", "trackJobUnderWorkSelected", "trackJumpedToSource", "trackTableModeSelected", "trackWakeLockSelected", "trackWakeLockUnderJobSelected", "trackWorkCancelled", "trackWorkSelected", "toEvent", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$BackgroundTaskInspectorEvent$Type;", "app-inspection.inspectors.backgroundtask.ide"})
public final class IdeBackgroundTaskInspectorTracker
implements BackgroundTaskInspectorTracker {
    @NotNull
    private final Project project;
    @NotNull
    private AppInspectionEvent.BackgroundTaskInspectorEvent.Mode activeMode;

    public IdeBackgroundTaskInspectorTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.activeMode = AppInspectionEvent.BackgroundTaskInspectorEvent.Mode.TABLE_MODE;
    }

    @Override
    public void trackTableModeSelected() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TOOL_BUTTON_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.TABLE_MODE_SELECTED));
        this.activeMode = AppInspectionEvent.BackgroundTaskInspectorEvent.Mode.TABLE_MODE;
    }

    @Override
    public void trackGraphModeSelected(@NotNull AppInspectionEvent.BackgroundTaskInspectorEvent.Context context2, @NotNull AppInspectionEvent.BackgroundTaskInspectorEvent.ChainInfo chainInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)chainInfo, (String)"chainInfo");
        AppInspectionEvent.BackgroundTaskInspectorEvent.Builder event = this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.GRAPH_MODE_SELECTED).setChainInfo(chainInfo);
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
        this.track(context2, event);
        this.activeMode = AppInspectionEvent.BackgroundTaskInspectorEvent.Mode.GRAPH_MODE;
    }

    @Override
    public void trackJumpedToSource() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.DETAILS_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.JUMPED_TO_SOURCE));
    }

    @Override
    public void trackWorkCancelled() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TOOL_BUTTON_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.WORK_CANCELED));
    }

    private final AppInspectionEvent.BackgroundTaskInspectorEvent.Builder toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type $this$toEvent) {
        AppInspectionEvent.BackgroundTaskInspectorEvent.Builder builder2 = AppInspectionEvent.BackgroundTaskInspectorEvent.newBuilder().setType($this$toEvent);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder().setType(this)");
        return builder2;
    }

    @Override
    public void trackWorkSelected(@NotNull AppInspectionEvent.BackgroundTaskInspectorEvent.Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.track(context2, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.WORK_SELECTED));
    }

    @Override
    public void trackJobSelected() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TABLE_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.JOB_SELECTED));
    }

    @Override
    public void trackJobUnderWorkSelected() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TABLE_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.JOB_UNDER_WORK_SELECTED));
    }

    @Override
    public void trackAlarmSelected() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TABLE_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.ALARM_SELECTED));
    }

    @Override
    public void trackWakeLockSelected() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TABLE_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.WAKE_LOCK_SELECTED));
    }

    @Override
    public void trackWakeLockUnderJobSelected() {
        this.track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TABLE_CONTEXT, this.toEvent(AppInspectionEvent.BackgroundTaskInspectorEvent.Type.WAKE_LOCK_UNDER_JOB_SELECTED));
    }

    private final void track(AppInspectionEvent.BackgroundTaskInspectorEvent.Context context2, AppInspectionEvent.BackgroundTaskInspectorEvent.Builder inspectorEvent) {
        inspectorEvent.setContext(context2);
        inspectorEvent.setMode(this.activeMode);
        AppInspectionEvent.Builder inspectionEvent = AppInspectionEvent.newBuilder().setType(AppInspectionEvent.Type.INSPECTOR_EVENT).setBackgroundTaskInspectorEvent(inspectorEvent);
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APP_INSPECTION).setAppInspectionEvent(inspectionEvent);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n      .setK\u2026ionEvent(inspectionEvent)");
        AndroidStudioEvent.Builder studioEvent = builder2;
        String string = this.project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        studioEvent.setProjectId(AnonymizerUtil.anonymizeUtf8((String)string));
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }
}

