/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.appinspection.ide.analytics.AnalyticsProtoExtensionsKt;
import com.android.tools.idea.appinspection.ide.analytics.AppInspectionAnalyticsTrackerService;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.internal.AppInspectionAnalyticsTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService;", "Lcom/android/tools/idea/appinspection/internal/AppInspectionAnalyticsTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "toEnvironmentMetadata", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$EnvironmentMetadata;", "numDevices", "", "numProcesses", "track", "", "type", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Type;", "addMetadataTo", "Lkotlin/Function1;", "Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Events;", "trackErrorOccurred", "errorKind", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$ErrorKind;", "trackInspectionRestarted", "trackInspectionStopped", "trackProcessSelected", "device", "Lcom/android/tools/idea/appinspection/inspector/api/process/DeviceDescriptor;", "trackToolWindowHidden", "trackToolWindowOpened", "Companion", "Events", "app-inspection.ide"})
public final class AppInspectionAnalyticsTrackerService
implements AppInspectionAnalyticsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public AppInspectionAnalyticsTrackerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void trackErrorOccurred(@NotNull AppInspectionEvent.ErrorKind errorKind) {
        Intrinsics.checkNotNullParameter((Object)errorKind, (String)"errorKind");
        this.track(AppInspectionEvent.Type.ERROR_OCCURRED, (Function1<? super Events, Unit>)((Function1)new Function1<Events, Unit>(errorKind){
            final /* synthetic */ AppInspectionEvent.ErrorKind $errorKind;
            {
                this.$errorKind = $errorKind;
                super(1);
            }

            public final void invoke(@NotNull Events events) {
                Intrinsics.checkNotNullParameter((Object)events, (String)"events");
                events.getInspectionEvent().setErrorKind(this.$errorKind);
            }
        }));
    }

    @Override
    public void trackToolWindowOpened() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.TOOL_WINDOW_OPENED, null, 2, null);
    }

    @Override
    public void trackToolWindowHidden() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.TOOL_WINDOW_HIDDEN, null, 2, null);
    }

    @Override
    public void trackProcessSelected(@NotNull DeviceDescriptor device2, int numDevices, int numProcesses) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.track(AppInspectionEvent.Type.PROCESS_SELECTED, (Function1<? super Events, Unit>)((Function1)new Function1<Events, Unit>(device2, this, numDevices, numProcesses){
            final /* synthetic */ DeviceDescriptor $device;
            final /* synthetic */ AppInspectionAnalyticsTrackerService this$0;
            final /* synthetic */ int $numDevices;
            final /* synthetic */ int $numProcesses;
            {
                this.$device = $device;
                this.this$0 = $receiver;
                this.$numDevices = $numDevices;
                this.$numProcesses = $numProcesses;
                super(1);
            }

            public final void invoke(@NotNull Events events) {
                Intrinsics.checkNotNullParameter((Object)events, (String)"events");
                events.getStudioEvent().setDeviceInfo(AnalyticsProtoExtensionsKt.toDeviceInfo(this.$device));
                events.getInspectionEvent().setEnvironmentMetadata(AppInspectionAnalyticsTrackerService.access$toEnvironmentMetadata(this.this$0, this.$numDevices, this.$numProcesses));
            }
        }));
    }

    @Override
    public void trackInspectionStopped() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.INSPECTION_STOPPED, null, 2, null);
    }

    @Override
    public void trackInspectionRestarted() {
        AppInspectionAnalyticsTrackerService.track$default(this, AppInspectionEvent.Type.INSPECTION_RESTARTED, null, 2, null);
    }

    private final AppInspectionEvent.EnvironmentMetadata toEnvironmentMetadata(int numDevices, int numProcesses) {
        AppInspectionEvent.EnvironmentMetadata environmentMetadata = AppInspectionEvent.EnvironmentMetadata.newBuilder().setNumDevices(numDevices).setNumProcesses(numProcesses).build();
        Intrinsics.checkNotNullExpressionValue((Object)environmentMetadata, (String)"newBuilder()\n      .setN\u2026Processes)\n      .build()");
        return environmentMetadata;
    }

    private final void track(AppInspectionEvent.Type type, Function1<? super Events, Unit> addMetadataTo) {
        AppInspectionEvent.Builder appInspectionEvent = AppInspectionEvent.newBuilder().setType(type);
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APP_INSPECTION);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n      .setK\u2026EventKind.APP_INSPECTION)");
        AndroidStudioEvent.Builder studioEvent = UsageTrackerUtils.withProjectId(builder2, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)appInspectionEvent, (String)"appInspectionEvent");
        addMetadataTo.invoke((Object)new Events(studioEvent, appInspectionEvent));
        studioEvent.setAppInspectionEvent(appInspectionEvent);
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }

    static /* synthetic */ void track$default(AppInspectionAnalyticsTrackerService appInspectionAnalyticsTrackerService, AppInspectionEvent.Type type, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = track.1.INSTANCE;
        }
        appInspectionAnalyticsTrackerService.track(type, (Function1<? super Events, Unit>)function1);
    }

    public static final /* synthetic */ AppInspectionEvent.EnvironmentMetadata access$toEnvironmentMetadata(AppInspectionAnalyticsTrackerService $this, int numDevices, int numProcesses) {
        return $this.toEnvironmentMetadata(numDevices, numProcesses);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService;", "project", "Lcom/intellij/openapi/project/Project;", "app-inspection.ide"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AppInspectionAnalyticsTrackerService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            return (AppInspectionAnalyticsTrackerService)$this$service$iv.getService(AppInspectionAnalyticsTrackerService.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/appinspection/ide/analytics/AppInspectionAnalyticsTrackerService$Events;", "", "studioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "inspectionEvent", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Builder;", "(Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Builder;)V", "getInspectionEvent", "()Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$Builder;", "getStudioEvent", "()Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "app-inspection.ide"})
    private static final class Events {
        @NotNull
        private final AndroidStudioEvent.Builder studioEvent;
        @NotNull
        private final AppInspectionEvent.Builder inspectionEvent;

        public Events(@NotNull AndroidStudioEvent.Builder studioEvent, @NotNull AppInspectionEvent.Builder inspectionEvent) {
            Intrinsics.checkNotNullParameter((Object)studioEvent, (String)"studioEvent");
            Intrinsics.checkNotNullParameter((Object)inspectionEvent, (String)"inspectionEvent");
            this.studioEvent = studioEvent;
            this.inspectionEvent = inspectionEvent;
        }

        @NotNull
        public final AndroidStudioEvent.Builder getStudioEvent() {
            return this.studioEvent;
        }

        @NotNull
        public final AppInspectionEvent.Builder getInspectionEvent() {
            return this.inspectionEvent;
        }
    }
}

