/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.appinspection.api.AppInspectionApiServices;
import com.android.tools.idea.appinspection.api.AppInspectionJarCopier;
import com.android.tools.idea.appinspection.ide.model.AppInspectionBundle;
import com.android.tools.idea.appinspection.inspector.api.AppInspectorJar;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.transport.DeployableFile;
import com.android.tools.idea.transport.TransportClient;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.idea.transport.manager.TransportStreamManager;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0013H\u0002J\u0011\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\t*\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/appinspection/ide/AppInspectionDiscoveryService;", "Lcom/intellij/openapi/Disposable;", "()V", "apiServices", "Lcom/android/tools/idea/appinspection/api/AppInspectionApiServices;", "getApiServices", "()Lcom/android/tools/idea/appinspection/api/AppInspectionApiServices;", "applicationMessageBus", "Lcom/intellij/util/messages/MessageBusConnection;", "Lorg/jetbrains/annotations/NotNull;", "client", "Lcom/android/tools/idea/transport/TransportClient;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "streamManager", "Lcom/android/tools/idea/transport/manager/TransportStreamManager;", "dispose", "", "findDevice", "Lcom/android/ddmlib/IDevice;", "device", "Lcom/android/tools/idea/appinspection/inspector/api/process/DeviceDescriptor;", "createJarCopier", "Lcom/android/tools/idea/appinspection/api/AppInspectionJarCopier;", "toDeployableFile", "Lcom/android/tools/idea/transport/DeployableFile;", "Lcom/android/tools/idea/appinspection/inspector/api/AppInspectorJar;", "Companion", "app-inspection.ide"})
public final class AppInspectionDiscoveryService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransportClient client;
    @NotNull
    private final TransportStreamManager streamManager;
    @NotNull
    private final MessageBusConnection applicationMessageBus;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AppInspectionApiServices apiServices;
    @NotNull
    private static final Logger logger;

    public AppInspectionDiscoveryService() {
        TransportService.Companion.getInstance();
        this.client = new TransportClient(TransportService.Companion.getChannelName());
        TransportServiceGrpc.TransportServiceBlockingStub transportServiceBlockingStub = this.client.getTransportStub();
        Intrinsics.checkNotNullExpressionValue((Object)transportServiceBlockingStub, (String)"client.transportStub");
        this.streamManager = TransportStreamManager.Companion.createManager(transportServiceBlockingStub, AndroidDispatchers.INSTANCE.getWorkerThread());
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"getApplication().messageBus.connect(this)");
        this.applicationMessageBus = messageBusConnection;
        this.scope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        Executor executor2 = MoreExecutors.newSequentialExecutor((Executor)AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"newSequentialExecutor(An\u2026e().workerThreadExecutor)");
        this.apiServices = AppInspectionApiServices.Companion.createDefaultAppInspectionApiServices(this.client, this.streamManager, this.scope, ExecutorsKt.from((Executor)executor2), (Function1<? super DeviceDescriptor, ? extends AppInspectionJarCopier>)((Function1)new Function1<DeviceDescriptor, AppInspectionJarCopier>(this){
            final /* synthetic */ AppInspectionDiscoveryService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final AppInspectionJarCopier invoke(@NotNull DeviceDescriptor device2) {
                AppInspectionJarCopier jarCopier;
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                String[] stringArray = AppInspectionDiscoveryService.access$findDevice(this.this$0, device2);
                AppInspectionJarCopier appInspectionJarCopier = jarCopier = stringArray != null ? AppInspectionDiscoveryService.access$createJarCopier(this.this$0, (IDevice)stringArray) : null;
                if (jarCopier == null) {
                    stringArray = new String[]{device2.getManufacturer(), device2.getModel(), device2.getSerial()};
                    AppInspectionDiscoveryService.access$getLogger$cp().error(AppInspectionBundle.INSTANCE.message("device.not.found", stringArray));
                }
                return jarCopier;
            }
        }));
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.applicationMessageBus.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
                    int label;
                    final /* synthetic */ AppInspectionDiscoveryService this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                AppInspectionApiServices appInspectionApiServices = this.this$0.getApiServices();
                                String string = this.$project.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
                                this.label = 1;
                                Object object3 = appInspectionApiServices.disposeClients(string, (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    @NotNull
    public final AppInspectionApiServices getApiServices() {
        return this.apiServices;
    }

    private final AppInspectionJarCopier createJarCopier(IDevice $this$createJarCopier) {
        return new AppInspectionJarCopier($this$createJarCopier, this){
            @NotNull
            private final TransportFileManager delegate;
            final /* synthetic */ AppInspectionDiscoveryService this$0;
            {
                this.this$0 = $receiver2;
                this.delegate = new TransportFileManager($receiver, TransportService.Companion.getInstance().getMessageBus());
            }

            @NotNull
            public List<String> copyFileToDevice(@NotNull AppInspectorJar jar) {
                Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
                List<String> list2 = this.delegate.copyFileToDevice(AppInspectionDiscoveryService.access$toDeployableFile(this.this$0, jar));
                Intrinsics.checkNotNullExpressionValue(list2, (String)"delegate.copyFileToDevice(jar.toDeployableFile())");
                return list2;
            }
        };
    }

    public void dispose() {
        TransportStreamManager.Companion.unregisterManager(this.streamManager);
    }

    private final IDevice findDevice(DeviceDescriptor device2) {
        IDevice iDevice;
        block3: {
            IDevice[] iDeviceArray = AndroidDebugBridge.getBridge();
            if (iDeviceArray != null && (iDeviceArray = iDeviceArray.getDevices()) != null) {
                IDevice[] iDeviceArray2 = iDeviceArray;
                int n = iDeviceArray2.length;
                for (int i = 0; i < n; ++i) {
                    IDevice iDevice2;
                    IDevice it = iDevice2 = iDeviceArray2[i];
                    boolean bl = false;
                    String string = device2.getManufacturer();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    boolean bl2 = Intrinsics.areEqual((Object)string, (Object)TransportServiceProxy.Companion.getDeviceManufacturer(it)) && Intrinsics.areEqual((Object)device2.getModel(), (Object)TransportServiceProxy.Companion.getDeviceModel(it)) && Intrinsics.areEqual((Object)device2.getSerial(), (Object)it.getSerialNumber());
                    if (!bl2) continue;
                    iDevice = iDevice2;
                    break block3;
                }
                iDevice = null;
            } else {
                iDevice = null;
            }
        }
        return iDevice;
    }

    private final DeployableFile toDeployableFile(AppInspectorJar $this$toDeployableFile) {
        String it;
        DeployableFile.Builder builder2;
        DeployableFile.Builder $this$toDeployableFile_u24lambda_u2d3 = builder2 = new DeployableFile.Builder($this$toDeployableFile.getName());
        boolean bl = false;
        String string = $this$toDeployableFile.getReleaseDirectory();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$toDeployableFile_u24lambda_u2d3.setReleaseDir(it);
        }
        String string2 = $this$toDeployableFile.getDevelopmentDirectory();
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$toDeployableFile_u24lambda_u2d3.setDevDir(it);
        }
        DeployableFile deployableFile = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)deployableFile, (String)"Builder(name).apply {\n  \u2026tDevDir(it) }\n  }.build()");
        return deployableFile;
    }

    public static final /* synthetic */ DeployableFile access$toDeployableFile(AppInspectionDiscoveryService $this, AppInspectorJar $receiver) {
        return $this.toDeployableFile($receiver);
    }

    public static final /* synthetic */ IDevice access$findDevice(AppInspectionDiscoveryService $this, DeviceDescriptor device2) {
        return $this.findDevice(device2);
    }

    public static final /* synthetic */ AppInspectionJarCopier access$createJarCopier(AppInspectionDiscoveryService $this, IDevice $receiver) {
        return $this.createJarCopier($receiver);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger2 = Logger.getInstance(AppInspectionDiscoveryService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AppInspectio\u2026overyService::class.java)");
        logger = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/appinspection/ide/AppInspectionDiscoveryService$Companion;", "", "()V", "instance", "Lcom/android/tools/idea/appinspection/ide/AppInspectionDiscoveryService;", "getInstance", "()Lcom/android/tools/idea/appinspection/ide/AppInspectionDiscoveryService;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "app-inspection.ide"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AppInspectionDiscoveryService getInstance() {
            boolean $i$f$service = false;
            Class<AppInspectionDiscoveryService> serviceClass$iv = AppInspectionDiscoveryService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (AppInspectionDiscoveryService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

