/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.apk.analyzer.dex.DexDisassembler;
import com.android.tools.apk.analyzer.dex.DexFiles;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.idea.apk.viewer.dex.DexCodeViewer;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.reference.MethodReference;

public class ShowDisassemblyAction
extends AnAction
implements DumbAware {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final Supplier<ProguardMap> myProguardMapSupplier;

    public ShowDisassemblyAction(@NotNull Tree tree2, @NotNull Supplier<ProguardMap> proguardMapSupplier) {
        super("Show Bytecode", "Show Bytecode", AllIcons.Toolwindows.Documentation);
        this.myTree = tree2;
        this.myProguardMapSupplier = proguardMapSupplier;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DexElementNode node = this.getSelectedNode();
        if (!ShowDisassemblyAction.canDisassemble(node)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    @VisibleForTesting
    static boolean canDisassemble(@Nullable DexElementNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof DexClassNode) && !(node instanceof DexMethodNode)) {
            return false;
        }
        if (!node.isDefined()) {
            return false;
        }
        return node.getUserObject() instanceof Path;
    }

    @Nullable
    private DexElementNode getSelectedNode() {
        TreePath path2 = this.myTree.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        Object component2 = path2.getLastPathComponent();
        if (!(component2 instanceof DexElementNode)) {
            return null;
        }
        return (DexElementNode)component2;
    }

    public void actionPerformed(final @NotNull AnActionEvent e) {
        final DexElementNode node = this.getSelectedNode();
        assert (node != null);
        final Project project = ShowDisassemblyAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        Path dexPath = (Path)node.getUserObject();
        ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> DexFiles.getDexFile((Path)dexPath));
        Futures.addCallback((ListenableFuture)dexFileFuture, (FutureCallback)new FutureCallback<DexBackedDexFile>(){

            public void onSuccess(@Nullable DexBackedDexFile dexBackedDexFile) {
                String byteCode;
                assert (dexBackedDexFile != null);
                try {
                    byteCode = ShowDisassemblyAction.getByteCode(dexBackedDexFile, node, (ProguardMap)ShowDisassemblyAction.this.myProguardMapSupplier.get());
                }
                catch (Exception ex) {
                    Messages.showErrorDialog((Project)project, (String)("Unable to get byte code: " + ex.getMessage()), (String)"View Dex Bytecode");
                    return;
                }
                DexCodeViewer component2 = new DexCodeViewer(project, byteCode);
                JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component2, null).setProject(project).setDimensionServiceKey(project, ShowDisassemblyAction.class.getName(), false).setResizable(true).setMovable(true).setTitle("DEX Byte Code for " + node.getName()).setFocusable(true).setRequestFocus(true).createPopup();
                Disposer.register((Disposable)popup2, (Disposable)component2);
                popup2.showInBestPositionFor(e.getDataContext());
            }

            public void onFailure(@NotNull Throwable t) {
                Messages.showErrorDialog((String)("Error constructing dex file: " + t), (String)"View Dex Bytecode");
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @VisibleForTesting
    @NotNull
    static String getByteCode(@NotNull DexBackedDexFile dex, @NotNull DexElementNode node, @Nullable ProguardMap proguardMap) {
        if (node instanceof DexMethodNode) {
            return ShowDisassemblyAction.getByteCodeForMethod(dex, (DexMethodNode)node, proguardMap);
        }
        if (node instanceof DexClassNode) {
            return ShowDisassemblyAction.getByteCodeForClass(dex, (DexClassNode)node, proguardMap);
        }
        throw new RuntimeException("Disassembly only available for methods and classes defined in this dex file");
    }

    @NotNull
    private static String getByteCodeForMethod(@NotNull DexBackedDexFile dex, @NotNull DexMethodNode node, @Nullable ProguardMap map2) {
        MethodReference desc = node.getReference();
        if (desc == null) {
            throw new RuntimeException("Unable to identify method descriptor for " + node.getName());
        }
        try {
            DexClassNode parent2 = (DexClassNode)node.getParent();
            assert (parent2 != null) : "Method node must have a parent class";
            return new DexDisassembler(dex, map2).disassembleMethod(DebuggerUtilsEx.signatureToName((String)parent2.getReference().getType()), desc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String getByteCodeForClass(@NotNull DexBackedDexFile dex, @NotNull DexClassNode node, @Nullable ProguardMap map2) {
        String fqcn = DebuggerUtilsEx.signatureToName((String)node.getReference().getType());
        if (fqcn == null) {
            throw new RuntimeException("Unable to get the fully qualified class name for " + node);
        }
        try {
            return new DexDisassembler(dex, map2).disassembleClass(fqcn);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

