/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.apk.analyzer.FilteredTreeModel;
import com.android.tools.apk.analyzer.dex.DexFileStats;
import com.android.tools.apk.analyzer.dex.DexFiles;
import com.android.tools.apk.analyzer.dex.DexReferences;
import com.android.tools.apk.analyzer.dex.DexViewFilters;
import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.apk.analyzer.internal.ProguardMappingFiles;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.dex.DexNodeIcons;
import com.android.tools.idea.apk.viewer.dex.GenerateProguardKeepRuleAction;
import com.android.tools.idea.apk.viewer.dex.SelectProguardMapsDialog;
import com.android.tools.idea.apk.viewer.dex.ShowDisassemblyAction;
import com.android.tools.idea.apk.viewer.dex.ShowReferencesAction;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.android.tools.proguard.ProguardUsagesMap;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;

public class DexFileViewer
extends UserDataHolderBase
implements ApkFileEditorComponent,
FileEditor {
    private final Disposable myDisposable;
    private final JBLoadingPanel myLoadingPanel;
    private final Tree myTree;
    private final JPanel myTopPanel;
    @NotNull
    private final Path[] myDexFiles;
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myApkFolder;
    @NotNull
    private final DexViewFilters myDexFilters;
    private final DexTreeNodeRenderer myDexTreeRenderer;
    @Nullable
    private ProguardMappings myProguardMappings;
    private boolean myDeobfuscateNames;
    private ListenableFuture<DexReferences> myDexReferences;
    @NotNull
    public static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"APK Analyzer (Info)", (PluginId)PluginId.getId((String)"org.jetbrains.android"));
    @NotNull
    public static final NotificationGroup BALLOON_NOTIFICATION = NotificationGroup.balloonGroup((String)"APK Analyzer (Important)", (PluginId)PluginId.getId((String)"org.jetbrains.android"));

    public DexFileViewer(@NotNull Project project, @NotNull Path[] dexFiles, @Nullable VirtualFile apkFolder) {
        this.myDexFiles = dexFiles;
        this.myProject = project;
        this.myApkFolder = apkFolder;
        this.myDisposable = Disposer.newDisposable();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable);
        this.myLoadingPanel.startLoading();
        this.myTree = new Tree((TreeModel)new DefaultTreeModel((TreeNode)new LoadingNode()));
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        new TreeSpeedSearch(this.myTree, path2 -> {
            Object o = path2.getLastPathComponent();
            if (!(o instanceof DexElementNode)) {
                return "";
            }
            DexElementNode node = (DexElementNode)o;
            return node.getName();
        }, true);
        this.myDexTreeRenderer = new DexTreeNodeRenderer();
        ColumnTreeBuilder builder2 = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setPreferredWidth(500).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getName).reversed()).setRenderer((ColoredTreeCellRenderer)this.myDexTreeRenderer)).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Defined Methods").setPreferredWidth(100).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getMethodDefinitionsCount)).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Referenced Methods").setPreferredWidth(100).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getMethodReferencesCount)).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Size").setPreferredWidth(50).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getSize)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer()));
        builder2.setTreeSorter((comparator2, order) -> {
            if (comparator2 != null) {
                TreeModel model2 = this.myTree.getModel();
                TreePath selectionPath = this.myTree.getSelectionPath();
                Object root = model2.getRoot();
                if (root instanceof DexElementNode) {
                    ((DexElementNode)root).sort(comparator2.reversed());
                }
                if (model2 instanceof DefaultTreeModel) {
                    ((DefaultTreeModel)model2).reload();
                }
                this.myTree.setSelectionPath(selectionPath);
                this.myTree.scrollPathToVisible(selectionPath);
            }
        });
        JComponent columnTree = builder2.build();
        this.myLoadingPanel.add((Component)columnTree, (Object)"Center");
        this.myTopPanel = new JPanel(new BorderLayout());
        this.myLoadingPanel.add((Component)this.myTopPanel, (Object)"North");
        this.myDexFilters = new DexViewFilters();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new ShowFieldsAction(this.myTree, this.myDexFilters));
        actionGroup.add((AnAction)new ShowMethodsAction(this.myTree, this.myDexFilters));
        actionGroup.add((AnAction)new ShowReferencedAction(this.myTree, this.myDexFilters));
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new ShowRemovedNodesAction(this.myTree, this.myDexFilters));
        actionGroup.add((AnAction)new DeobfuscateNodesAction());
        actionGroup.add((AnAction)new LoadProguardAction());
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        this.myTopPanel.add((Component)toolbar2.getComponent(), "West");
        ActionGroup group2 = this.createPopupActionGroup(this.myTree);
        PopupHandler.installPopupMenu((JComponent)this.myTree, (ActionGroup)group2, (String)"unknown");
        this.initDex();
    }

    @NotNull
    private ActionGroup createPopupActionGroup(@NotNull Tree tree2) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new ShowDisassemblyAction(tree2, (Supplier<ProguardMap>)((Supplier)() -> {
            if (this.myDeobfuscateNames && this.myProguardMappings != null) {
                return this.myProguardMappings.map;
            }
            return null;
        })));
        group2.add((AnAction)new ShowReferencesAction(tree2, this));
        group2.add((AnAction)new GenerateProguardKeepRuleAction(tree2));
        return group2;
    }

    public void selectProguardMapping() {
        SelectProguardMapsDialog dialog2 = new SelectProguardMapsDialog(this.myProject, this.myApkFolder);
        try {
            if (!dialog2.showAndGet()) {
                return;
            }
            ProguardMappingFiles mappingFiles = dialog2.getMappingFiles();
            ArrayList<String> loaded = new ArrayList<String>(3);
            ArrayList<String> errors2 = new ArrayList<String>(3);
            Path mappingFile = mappingFiles.mappingFile;
            ProguardMap proguardMap = new ProguardMap();
            if (mappingFile != null) {
                try {
                    proguardMap.readFromReader((Reader)new InputStreamReader(Files.newInputStream(mappingFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(mappingFile.getFileName().toString());
                }
                catch (IOException | ParseException e) {
                    errors2.add(mappingFile.getFileName().toString());
                    proguardMap = null;
                }
            }
            Path seedsFile = mappingFiles.seedsFile;
            ProguardSeedsMap seeds = null;
            if (seedsFile != null) {
                try {
                    seeds = ProguardSeedsMap.parse((Reader)new InputStreamReader(Files.newInputStream(seedsFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(seedsFile.getFileName().toString());
                }
                catch (IOException e) {
                    errors2.add(seedsFile.getFileName().toString());
                }
            }
            if ((this.myProguardMappings == null || this.myProguardMappings.map == null) && proguardMap != null) {
                this.myDeobfuscateNames = true;
            }
            Path usageFile = mappingFiles.usageFile;
            ProguardUsagesMap usage = null;
            if (usageFile != null) {
                try {
                    usage = ProguardUsagesMap.parse((Reader)new InputStreamReader(Files.newInputStream(usageFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(usageFile.getFileName().toString());
                }
                catch (IOException e) {
                    errors2.add(usageFile.getFileName().toString());
                }
            }
            ProguardMappings proguardMappings = this.myProguardMappings = loaded.isEmpty() ? null : new ProguardMappings(proguardMap, seeds, usage);
            if (errors2.isEmpty() && loaded.isEmpty()) {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer couldn't find any ProGuard mapping files. The filenames must match one of: mapping.txt, seeds.txt, usage.txt", MessageType.ERROR).notify(this.myProject);
            } else if (errors2.isEmpty()) {
                LOGGING_NOTIFICATION.createNotification("APK Analyzer successfully loaded maps from: " + StringUtil.join(loaded, (String)", "), MessageType.INFO).notify(this.myProject);
            } else if (loaded.isEmpty()) {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer encountered problems loading: " + StringUtil.join(errors2, (String)", "), MessageType.WARNING).notify(this.myProject);
            } else {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer successfully loaded maps from: " + StringUtil.join(loaded, (String)",") + "\nThere were problems loading: " + StringUtil.join(errors2, (String)", "), MessageType.WARNING).notify(this.myProject);
            }
            this.myDexTreeRenderer.setMappings(this.myProguardMappings);
            this.initDex();
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Error Loading Mappings...");
        }
    }

    public void initDex() {
        ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> {
            HashMap dexFiles = Maps.newHashMapWithExpectedSize((int)this.myDexFiles.length);
            for (int i = 0; i < this.myDexFiles.length; ++i) {
                dexFiles.put(this.myDexFiles[i], DexFiles.getDexFile((Path)this.myDexFiles[i]));
            }
            return dexFiles;
        });
        ListenableFuture treeNodeFuture = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<Map<Path, DexBackedDexFile>, DexPackageNode>(){

            @NotNull
            public DexPackageNode apply(@Nullable Map<Path, DexBackedDexFile> input2) {
                assert (input2 != null);
                PackageTreeCreator treeCreator = new PackageTreeCreator(DexFileViewer.this.myProguardMappings, DexFileViewer.this.myDeobfuscateNames);
                return treeCreator.constructPackageTree(input2);
            }
        }, (Executor)pooledThreadExecutor);
        Futures.addCallback((ListenableFuture)treeNodeFuture, (FutureCallback)new FutureCallback<DexPackageNode>(){

            public void onSuccess(DexPackageNode result2) {
                DexFileViewer.this.myLoadingPanel.stopLoading();
                DexFileViewer.this.myTree.setRootVisible(false);
                FilteredTreeModel treeModel = new FilteredTreeModel((TreeNode)result2, (Predicate)DexFileViewer.this.myDexFilters);
                DexFileViewer.this.myTree.setModel((TreeModel)treeModel);
                treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                    protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                        Enumeration expanded = DexFileViewer.this.myTree.getExpandedDescendants(new TreePath(DexFileViewer.this.myTree.getModel().getRoot()));
                        if (expanded == null) {
                            return;
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            for (TreePath path2 : Collections.list(expanded)) {
                                DexFileViewer.this.myTree.expandPath(path2);
                            }
                        });
                    }
                });
            }

            public void onFailure(@NotNull Throwable t) {
                DexFileViewer.this.myLoadingPanel.stopLoading();
            }
        }, (Executor)EdtExecutorService.getInstance());
        ListenableFuture dexStatsFuture = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<Map<Path, DexBackedDexFile>, DexFileStats>(){

            @NotNull
            public DexFileStats apply(@Nullable Map<Path, DexBackedDexFile> input2) {
                assert (input2 != null);
                return DexFileStats.create(input2.values());
            }
        }, (Executor)pooledThreadExecutor);
        if (((BorderLayout)this.myTopPanel.getLayout()).getLayoutComponent("East") == null) {
            final SimpleColoredComponent titleComponent = new SimpleColoredComponent();
            titleComponent.setIcon(AllIcons.Actions.Refresh);
            titleComponent.append("Loading dex stats");
            this.myTopPanel.add((Component)titleComponent, "East");
            Futures.addCallback((ListenableFuture)dexStatsFuture, (FutureCallback)new FutureCallback<DexFileStats>(){

                public void onSuccess(DexFileStats result2) {
                    titleComponent.clear();
                    titleComponent.setIcon(AllIcons.General.Information);
                    titleComponent.append(DexFileViewer.this.myDexFiles.length == 1 ? "This dex file defines " : "These dex files define ");
                    titleComponent.append(Integer.toString(result2.classCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" classes with ");
                    titleComponent.append(Integer.toString(result2.definedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" methods, and references ");
                    titleComponent.append(Integer.toString(result2.referencedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" methods.");
                }

                public void onFailure(@NotNull Throwable t) {
                    titleComponent.clear();
                    titleComponent.setIcon(AllIcons.General.Error);
                    titleComponent.append("Error parsing dex file: " + t.getMessage());
                }
            }, (Executor)EdtExecutorService.getInstance());
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myLoadingPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLoadingPanel;
    }

    @NotNull
    public String getName() {
        return "Dex Viewer";
    }

    public void setState(@NotNull FileEditorState state2) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        for (Path file2 : this.myDexFiles) {
            if (Files.isRegularFile(file2, new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @Nullable
    public ProguardMappings getProguardMappings() {
        return this.myProguardMappings;
    }

    public boolean isDeobfuscateNames() {
        return this.myDeobfuscateNames;
    }

    @Nullable
    ListenableFuture<DexReferences> getDexReferences() {
        if (this.myDexReferences == null) {
            ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
            ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> {
                DexBackedDexFile[] files2 = new DexBackedDexFile[this.myDexFiles.length];
                for (int i = 0; i < files2.length; ++i) {
                    files2[i] = DexFiles.getDexFile((Path)this.myDexFiles[i]);
                }
                return files2;
            });
            this.myDexReferences = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<DexBackedDexFile[], DexReferences>(){

                public DexReferences apply(@Nullable DexBackedDexFile[] inputs) {
                    assert (inputs != null);
                    return new DexReferences(inputs);
                }
            }, (Executor)pooledThreadExecutor);
        }
        return this.myDexReferences;
    }

    private class LoadProguardAction
    extends AnAction
    implements DumbAware {
        public LoadProguardAction() {
            super("Load Proguard mappings...", null, EmptyIcon.ICON_0);
            this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DexFileViewer.this.selectProguardMapping();
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (DexFileViewer.this.myProguardMappings != null) {
                e.getPresentation().setText("Change Proguard mappings...");
            } else {
                e.getPresentation().setText("Load Proguard mappings...");
            }
        }
    }

    private class DeobfuscateNodesAction
    extends ToggleAction
    implements DumbAware {
        public DeobfuscateNodesAction() {
            super("Deobfuscate names", "Deobfuscate names using Proguard mapping", AllIcons.ObjectBrowser.AbbreviatePackageNames);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return DexFileViewer.this.myDeobfuscateNames;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            DexFileViewer.this.myDeobfuscateNames = state2;
            DexFileViewer.this.initDex();
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(DexFileViewer.this.myProguardMappings != null && DexFileViewer.this.myProguardMappings.map != null);
        }
    }

    private class ShowRemovedNodesAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        public ShowRemovedNodesAction(@NotNull Tree tree2, DexViewFilters options2) {
            super("Show removed nodes", "Toggle between show/hide nodes removed by Proguard", AllIcons.ObjectBrowser.CompactEmptyPackages);
            this.myTree = tree2;
            this.myDexViewFilters = options2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowRemovedNodes();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowRemovedNodes(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(DexFileViewer.this.myProguardMappings != null && DexFileViewer.this.myProguardMappings.usage != null);
        }
    }

    private static class ShowReferencedAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        public ShowReferencedAction(@NotNull Tree tree2, @NotNull DexViewFilters options2) {
            super("Show referenced-only nodes", "Toggle between show/hide referenced-only nodes", AllIcons.ObjectBrowser.ShowMembers);
            this.myTree = tree2;
            this.myDexViewFilters = options2;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            String text2 = this.myDexViewFilters.isShowReferencedNodes() ? "Show all referenced methods and fields" : "Show defined methods and fields";
            e.getPresentation().setText(text2);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowReferencedNodes();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowReferencedNodes(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
    }

    private static class ShowMethodsAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        public ShowMethodsAction(@NotNull Tree tree2, @NotNull DexViewFilters options2) {
            super("Show methods", "Toggle between show/hide methods", PlatformIcons.METHOD_ICON);
            this.myTree = tree2;
            this.myDexViewFilters = options2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowMethods();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowMethods(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
    }

    private static class ShowFieldsAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        public ShowFieldsAction(@NotNull Tree tree2, @NotNull DexViewFilters options2) {
            super("Show fields", "Toggle between show/hide fields", PlatformIcons.FIELD_ICON);
            this.myTree = tree2;
            this.myDexViewFilters = options2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowFields();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowFields(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private SizeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value2 instanceof DexElementNode) {
                DexElementNode node = (DexElementNode)value2;
                this.append(HumanReadableUtil.getHumanizedSize((long)node.getSize()));
            }
        }
    }

    private static class MethodCountRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myShowDefinedCount;

        public MethodCountRenderer(boolean showDefinedCount) {
            this.myShowDefinedCount = showDefinedCount;
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value2 instanceof DexElementNode) {
                int count2;
                DexElementNode node = (DexElementNode)value2;
                int n = count2 = this.myShowDefinedCount ? node.getMethodDefinitionsCount() : node.getMethodReferencesCount();
                if (count2 != 0) {
                    this.append(Integer.toString(count2));
                }
            }
        }
    }

    private static class DexTreeNodeRenderer
    extends ColoredTreeCellRenderer {
        @Nullable
        private ProguardMappings myMappings;

        private DexTreeNodeRenderer() {
        }

        public void setMappings(@Nullable ProguardMappings mappings) {
            this.myMappings = mappings;
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (!(value2 instanceof DexElementNode)) {
                return;
            }
            DexElementNode node = (DexElementNode)value2;
            if (this.myMappings != null && node.isSeed(this.myMappings.seeds, this.myMappings.map, true)) {
                this.append(node.getName(), new SimpleTextAttributes(1, null));
            } else if (node.isRemoved()) {
                this.append(node.getName(), new SimpleTextAttributes(6, null));
            } else if (!node.isDefined()) {
                this.append(node.getName(), new SimpleTextAttributes(2, null));
            } else {
                this.append(node.getName());
            }
            this.setIcon(DexNodeIcons.forNode(node));
        }
    }
}

