/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.aapt.Resources;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.tools.idea.apk.viewer.ProtoXmlPrettyPrinter;
import com.android.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ProtoXmlPrettyPrinterImpl
implements ProtoXmlPrettyPrinter {
    private static final String HTTP_WWW_W3_ORG_2000_XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XMLNS_PREFIX = "xmlns";

    @Override
    @NotNull
    public String prettyPrint(@NotNull byte[] content2) throws IOException {
        String string;
        ByteArrayInputStream stream = new ByteArrayInputStream(content2);
        try {
            Resources.XmlNode rootNode = Resources.XmlNode.parseFrom((InputStream)stream);
            Document document2 = ProtoXmlPrettyPrinterImpl.processDocument(rootNode);
            string = XmlPrettyPrinter.prettyPrint((Node)document2, (boolean)true);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException("Error decoding XML Resource proto buf", e);
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    @NotNull
    private static Document processDocument(@NotNull Resources.XmlNode parser2) {
        Document document2 = XmlUtils.createDocument((boolean)true);
        NamespaceScope rootScope = NamespaceScope.createRootScope();
        ProtoXmlPrettyPrinterImpl.processXmlNode(parser2, document2, rootScope);
        return document2;
    }

    private static void processXmlNode(@NotNull Resources.XmlNode resourceNode, @NotNull Node parentNode, @NotNull NamespaceScope parentScope) {
        switch (resourceNode.getNodeCase()) {
            case ELEMENT: {
                ProtoXmlPrettyPrinterImpl.processElement(resourceNode.getElement(), parentNode, parentScope);
                break;
            }
            case TEXT: {
                ProtoXmlPrettyPrinterImpl.processText(resourceNode, parentNode);
                break;
            }
        }
    }

    private static void processElement(@NotNull Resources.XmlElement resourceElement, @NotNull Node parentNode, @NotNull NamespaceScope parentScope) {
        Element newElement = ProtoXmlPrettyPrinterImpl.getDocument(parentNode).createElementNS(resourceElement.getNamespaceUri(), parentScope.getQualifiedName(resourceElement.getNamespaceUri(), resourceElement.getName()));
        NamespaceScope newScope = parentScope.createScope();
        parentNode.appendChild(newElement);
        for (Resources.XmlNamespace x : resourceElement.getNamespaceDeclarationList()) {
            newElement.setAttributeNS(HTTP_WWW_W3_ORG_2000_XMLNS_URI, "xmlns:" + x.getPrefix(), x.getUri());
            newScope.declareNamespace(x.getUri(), x.getPrefix());
        }
        for (Resources.XmlAttribute attr : resourceElement.getAttributeList()) {
            newElement.setAttributeNS(attr.getNamespaceUri(), newScope.getQualifiedName(attr.getNamespaceUri(), attr.getName()), attr.getValue());
        }
        for (Resources.XmlNode childNode : resourceElement.getChildList()) {
            ProtoXmlPrettyPrinterImpl.processXmlNode(childNode, newElement, newScope);
        }
    }

    @NotNull
    private static Document getDocument(@NotNull Node parentNode) {
        if (parentNode instanceof Document) {
            return (Document)parentNode;
        }
        return parentNode.getOwnerDocument();
    }

    private static void processText(@NotNull Resources.XmlNode resourceNode, @NotNull Node parentNode) {
        Text newElement = ProtoXmlPrettyPrinterImpl.getDocument(parentNode).createTextNode(resourceNode.getText());
        parentNode.appendChild(newElement);
    }

    private static abstract class NamespaceScope {
        private NamespaceScope() {
        }

        @NotNull
        public static NamespaceScope createRootScope() {
            return new RootScope();
        }

        @NotNull
        public abstract String getQualifiedName(@NotNull String var1, @NotNull String var2);

        public abstract void declareNamespace(@NotNull String var1, @NotNull String var2);

        @NotNull
        public NamespaceScope createScope() {
            return new NestedScoped(this);
        }

        private static class NestedScoped
        extends NamespaceScope {
            private final NamespaceScope myParentScope;
            private HashMap<String, String> myPrefixes;

            public NestedScoped(@NotNull NamespaceScope parentScope) {
                this.myParentScope = parentScope;
            }

            @Override
            @NotNull
            public String getQualifiedName(@NotNull String uri, @NotNull String name) {
                if (this.myPrefixes == null || !this.myPrefixes.containsKey(uri)) {
                    return this.myParentScope.getQualifiedName(uri, name);
                }
                return this.myPrefixes.get(uri) + ":" + name;
            }

            @Override
            public void declareNamespace(@NotNull String uri, @NotNull String prefix) {
                if (this.myPrefixes == null) {
                    this.myPrefixes = new HashMap();
                }
                this.myPrefixes.put(uri, prefix);
            }
        }

        private static class RootScope
        extends NamespaceScope {
            private RootScope() {
            }

            @Override
            @NotNull
            public String getQualifiedName(@NotNull String uri, @NotNull String name) {
                return name;
            }

            @Override
            public void declareNamespace(@NotNull String uri, @NotNull String prefix) {
                throw new IllegalStateException("Root namespace scope cannot contain namespace declarations");
            }
        }
    }
}

