/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkEditor;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ApkEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final String ID = "apk-viewer";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return false;
        }
        return ApkFileSystem.EXTENSIONS.contains(file2.getExtension()) && ApkFileSystem.getInstance().getRootByLocal(file2) != null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile root = ApkFileSystem.getInstance().getRootByLocal(file2);
        assert (root != null);
        return new ApkEditor(project, file2, root);
    }

    @NotNull
    public String getEditorTypeId() {
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }
}

