/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.PairingCodeInputPanel;
import com.android.tools.idea.adb.wireless.PairingCodePairingDialog;
import com.android.tools.idea.ui.JSingleDigitTextField;
import com.android.tools.idea.ui.OneTimeOverrideFocusTraversalPolicy;
import com.android.tools.idea.ui.SimpleDialog;
import com.android.tools.idea.ui.SimpleDialogOptions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ui.JBDimension;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010*\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020,J\u0006\u00100\u001a\u00020,J\u000e\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u0006J\u000e\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\"\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010\u0017\u00a8\u00066"}, d2={"Lcom/android/tools/idea/adb/wireless/PairingCodePairingDialog;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentPairingCode", "", "getCurrentPairingCode", "()Ljava/lang/String;", "dialog", "Lcom/android/tools/idea/ui/SimpleDialog;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "isPairingCodeValid", "", "()Z", "okButtonHandler", "Lkotlin/Function0;", "getOkButtonHandler", "()Lkotlin/jvm/functions/Function0;", "setOkButtonHandler", "(Lkotlin/jvm/functions/Function0;)V", "pairingCodeComponent", "Ljavax/swing/JComponent;", "getPairingCodeComponent", "()Ljavax/swing/JComponent;", "pairingPanel", "Lcom/android/tools/idea/adb/wireless/PairingCodeInputPanel;", "getPairingPanel", "()Lcom/android/tools/idea/adb/wireless/PairingCodeInputPanel;", "pairingPanel$delegate", "Lkotlin/Lazy;", "panelPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "getPanelPreferredSize", "()Lcom/intellij/util/ui/JBDimension;", "validationHandler", "Lcom/intellij/openapi/ui/ValidationInfo;", "getValidationHandler", "setValidationHandler", "createCenterPanel", "setDevice", "", "service", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "show", "showPairingError", "showPairingInProgress", "text", "showPairingSuccess", "device", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "intellij.android.adb"})
public final class PairingCodePairingDialog {
    @NotNull
    private final SimpleDialog dialog;
    @NotNull
    private final Lazy pairingPanel$delegate;
    @NotNull
    private Function0<ValidationInfo> validationHandler;
    @NotNull
    private Function0<Boolean> okButtonHandler;

    public PairingCodePairingDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.pairingPanel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PairingCodeInputPanel>(this){
            final /* synthetic */ PairingCodePairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PairingCodeInputPanel invoke() {
                return new PairingCodeInputPanel(this.this$0.getDisposable());
            }
        }));
        DialogWrapper.IdeModalityType ideModalityType = DialogWrapper.IdeModalityType.PROJECT;
        SimpleDialogOptions options2 = new SimpleDialogOptions(project, true, ideModalityType, "Enter pairing code", true, (Function0)new Function0<JComponent>(this){
            final /* synthetic */ PairingCodePairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JComponent invoke() {
                return this.this$0.createCenterPanel();
            }
        }, (Function0)new Function0<JComponent>(this){
            final /* synthetic */ PairingCodePairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final JComponent invoke() {
                return (JComponent)((Object)PairingCodePairingDialog.access$getPairingPanel(this.this$0).getFirstPairingCodeDigitComponent());
            }
        }, false, "Pair", (Function0)new Function0<Boolean>(this){
            final /* synthetic */ PairingCodePairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)this.this$0.getOkButtonHandler().invoke();
            }
        }, null, (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ PairingCodePairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ValidationInfo invoke() {
                return (ValidationInfo)this.this$0.getValidationHandler().invoke();
            }
        }, 1152, null);
        this.dialog = new SimpleDialog(options2);
        this.dialog.init();
        final OneTimeOverrideFocusTraversalPolicy focusPolicy = OneTimeOverrideFocusTraversalPolicy.Companion.install(this.dialog.getRootPane());
        this.getPairingPanel().getLastPairingCodeDigitComponent().addListener(new JSingleDigitTextField.Listener(){

            @Override
            public void onDigitEntered(@NotNull JSingleDigitTextField.Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                focusPolicy.getOneTimeComponentAfter().set(dialog.getOkButton());
                event.getComponent().transferFocus();
                event.setConsumed(true);
            }
        });
        this.validationHandler = validationHandler.1.INSTANCE;
        this.okButtonHandler = okButtonHandler.1.INSTANCE;
    }

    private final PairingCodeInputPanel getPairingPanel() {
        Lazy lazy = this.pairingPanel$delegate;
        return (PairingCodeInputPanel)lazy.getValue();
    }

    @NotNull
    public final Function0<ValidationInfo> getValidationHandler() {
        return this.validationHandler;
    }

    public final void setValidationHandler(@NotNull Function0<ValidationInfo> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.validationHandler = function0;
    }

    @NotNull
    public final Function0<Boolean> getOkButtonHandler() {
        return this.okButtonHandler;
    }

    public final void setOkButtonHandler(@NotNull Function0<Boolean> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.okButtonHandler = function0;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.dialog.getDisposable();
    }

    @NotNull
    public final JComponent getPairingCodeComponent() {
        JSingleDigitTextField jSingleDigitTextField = this.getPairingPanel().getFirstPairingCodeDigitComponent();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jSingleDigitTextField), (String)"pairingPanel.firstPairingCodeDigitComponent");
        return (JComponent)((Object)jSingleDigitTextField);
    }

    @NotNull
    public final String getCurrentPairingCode() {
        String string = this.getPairingPanel().getPairingCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pairingPanel.pairingCode");
        return string;
    }

    public final boolean isPairingCodeValid() {
        return this.getCurrentPairingCode().length() == 6;
    }

    @NotNull
    public final JComponent createCenterPanel() {
        this.getPairingPanel().getComponent().setPreferredSize((Dimension)this.getPanelPreferredSize());
        JComponent jComponent = this.getPairingPanel().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"pairingPanel.component");
        return jComponent;
    }

    public final void show() {
        this.dialog.show();
    }

    public final void setDevice(@NotNull MdnsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.getPairingPanel().setDevice(service);
    }

    public final void showPairingInProgress(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.getPairingPanel().showProgress(text2);
        this.getPairingPanel().setDigitsEnabled(false);
        this.dialog.setOkButtonEnabled(false);
        this.dialog.setCancelButtonEnabled(false);
    }

    public final void showPairingSuccess(@NotNull AdbOnlineDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.getPairingPanel().showSuccess(device2);
        this.dialog.setOkButtonEnabled(true);
        this.dialog.setCancelButtonEnabled(true);
        this.dialog.setOkButtonText("Done");
        this.dialog.setCancelButtonVisible(false);
    }

    public final void showPairingError() {
        this.getPairingPanel().showPairingError();
        this.getPairingPanel().setDigitsEnabled(true);
        this.dialog.setOkButtonEnabled(true);
        this.dialog.setCancelButtonEnabled(true);
    }

    private final JBDimension getPanelPreferredSize() {
        return new JBDimension(500, 200);
    }

    public static final /* synthetic */ PairingCodeInputPanel access$getPairingPanel(PairingCodePairingDialog $this) {
        return $this.getPairingPanel();
    }
}

