/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.processnamemonitor;

import com.android.adblib.AdbDeviceServices;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbAdapterImpl;
import com.android.tools.idea.adb.processnamemonitor.DeviceMonitorEvent;
import com.android.tools.idea.adb.processnamemonitor.ProcessNameClientMonitor;
import com.android.tools.idea.adb.processnamemonitor.ProcessNameMonitor;
import com.android.tools.idea.adb.processnamemonitor.ProcessNameMonitorFlows;
import com.android.tools.idea.adb.processnamemonitor.ProcessNameMonitorFlowsImpl;
import com.android.tools.idea.adb.processnamemonitor.ProcessNames;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B-\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0016H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorImpl;", "Lcom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "flows", "Lcom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorFlows;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "adbDeviceServicesFactory", "Lkotlin/Function0;", "Lcom/android/adblib/AdbDeviceServices;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorFlows;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function0;)V", "coroutineScope", "devices", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/tools/idea/adb/processnamemonitor/ProcessNameClientMonitor;", "isStarted", "", "addDevice", "", "device", "Lcom/android/ddmlib/IDevice;", "dispose", "getProcessNames", "Lcom/android/tools/idea/adb/processnamemonitor/ProcessNames;", "serialNumber", "pid", "", "removeDevice", "start", "intellij.android.adb"})
public final class ProcessNameMonitorImpl
implements ProcessNameMonitor,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ProcessNameMonitorFlows flows;
    @NotNull
    private final Function0<AdbDeviceServices> adbDeviceServicesFactory;
    @NotNull
    private final CoroutineScope coroutineScope;
    private volatile boolean isStarted;
    @NotNull
    private final ConcurrentHashMap<String, ProcessNameClientMonitor> devices;

    @NonInjectable
    @TestOnly
    public ProcessNameMonitorImpl(@NotNull Project project, @NotNull ProcessNameMonitorFlows flows, @NotNull CoroutineScope parentScope, @NotNull Function0<? extends AdbDeviceServices> adbDeviceServicesFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)flows, (String)"flows");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter(adbDeviceServicesFactory, (String)"adbDeviceServicesFactory");
        this.project = project;
        this.flows = flows;
        this.adbDeviceServicesFactory = adbDeviceServicesFactory;
        this.coroutineScope = CoroutinesUtilsKt.createChildScope$default((CoroutineScope)parentScope, (boolean)false, null, (Disposable)this, (int)3, null);
        this.devices = new ConcurrentHashMap();
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
    }

    public ProcessNameMonitorImpl(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, new ProcessNameMonitorFlowsImpl(new AdbAdapterImpl(project)), CoroutinesUtilsKt.getCoroutineScope((Project)project), (Function0<? extends AdbDeviceServices>)((Function0)new Function0<AdbDeviceServices>(){

            @NotNull
            public final AdbDeviceServices invoke() {
                return AdbLibService.Companion.getInstance(project).getSession().getDeviceServices();
            }
        }));
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStarted) {
            return;
        }
        ProcessNameMonitorImpl processNameMonitorImpl = this;
        synchronized (processNameMonitorImpl) {
            boolean bl = false;
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            Unit unit = Unit.INSTANCE;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProcessNameMonitorImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Flow<DeviceMonitorEvent> flow2 = ProcessNameMonitorImpl.access$getFlows$p(this.this$0).trackDevices();
                        ProcessNameMonitorImpl processNameMonitorImpl = this.this$0;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<DeviceMonitorEvent>(processNameMonitorImpl){
                            final /* synthetic */ ProcessNameMonitorImpl this$0;
                            {
                                this.this$0 = processNameMonitorImpl;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @Nullable
                            public Object emit(Object value2, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                DeviceMonitorEvent it = (DeviceMonitorEvent)value2;
                                boolean bl = false;
                                DeviceMonitorEvent deviceMonitorEvent = it;
                                if (deviceMonitorEvent instanceof DeviceMonitorEvent.Online) {
                                    ProcessNameMonitorImpl.access$addDevice(this.this$0, ((DeviceMonitorEvent.Online)it).getDevice());
                                } else if (deviceMonitorEvent instanceof DeviceMonitorEvent.Disconnected) {
                                    ProcessNameMonitorImpl.access$removeDevice(this.this$0, ((DeviceMonitorEvent.Disconnected)it).getDevice());
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @Nullable
    public ProcessNames getProcessNames(@NotNull String serialNumber, int pid) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        ProcessNameClientMonitor processNameClientMonitor = this.devices.get(serialNumber);
        return processNameClientMonitor != null ? processNameClientMonitor.getProcessNames(pid) : null;
    }

    private final void addDevice(IDevice device2) {
        ProcessNameClientMonitor processNameClientMonitor;
        ProcessNameMonitor.Companion.getLOGGER$intellij_android_adb().info("Adding " + device2.getSerialNumber());
        Map map2 = this.devices;
        String string = device2.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.serialNumber");
        String string2 = string;
        ProcessNameClientMonitor $this$addDevice_u24lambda_u2d1 = processNameClientMonitor = new ProcessNameClientMonitor((Disposable)this.project, this.coroutineScope, device2, this.flows, this.adbDeviceServicesFactory, 0, 32, null);
        boolean bl = false;
        $this$addDevice_u24lambda_u2d1.start();
        map2.put(string2, processNameClientMonitor);
    }

    private final void removeDevice(IDevice device2) {
        ProcessNameMonitor.Companion.getLOGGER$intellij_android_adb().info("Removing " + device2.getSerialNumber() + ": " + System.identityHashCode(device2));
        ProcessNameClientMonitor clientMonitor = this.devices.remove(device2.getSerialNumber());
        if (clientMonitor != null) {
            Disposer.dispose((Disposable)clientMonitor);
        }
    }

    public static final /* synthetic */ ProcessNameMonitorFlows access$getFlows$p(ProcessNameMonitorImpl $this) {
        return $this.flows;
    }

    public static final /* synthetic */ void access$addDevice(ProcessNameMonitorImpl $this, IDevice device2) {
        $this.addDevice(device2);
    }

    public static final /* synthetic */ void access$removeDevice(ProcessNameMonitorImpl $this, IDevice device2) {
        $this.removeDevice(device2);
    }
}

