/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.processnamemonitor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.processnamemonitor.DeviceMonitorEvent;
import com.android.tools.idea.adb.processnamemonitor.ProcessNameMonitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/adb/processnamemonitor/DevicesMonitorListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "producerScope", "Lkotlinx/coroutines/channels/ProducerScope;", "Lcom/android/tools/idea/adb/processnamemonitor/DeviceMonitorEvent;", "(Lkotlinx/coroutines/channels/ProducerScope;)V", "deviceChanged", "", "device", "Lcom/android/ddmlib/IDevice;", "changeMask", "", "deviceConnected", "deviceDisconnected", "send", "event", "intellij.android.adb"})
public final class DevicesMonitorListener
implements AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final ProducerScope<DeviceMonitorEvent> producerScope;

    public DevicesMonitorListener(@NotNull ProducerScope<? super DeviceMonitorEvent> producerScope) {
        Intrinsics.checkNotNullParameter(producerScope, (String)"producerScope");
        this.producerScope = producerScope;
    }

    public void deviceConnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        if (device2.getState() == IDevice.DeviceState.ONLINE) {
            this.send(new DeviceMonitorEvent.Online(device2));
        }
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.send(new DeviceMonitorEvent.Disconnected(device2));
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        if ((changeMask & 1) != 0 && device2.getState() == IDevice.DeviceState.ONLINE) {
            this.send(new DeviceMonitorEvent.Online(device2));
        }
    }

    private final void send(DeviceMonitorEvent event) {
        Object $this$onFailure$iv = ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.producerScope), (Object)event);
        boolean bl = false;
        if ($this$onFailure$iv instanceof ChannelResult.Failed) {
            Throwable it = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure$iv);
            boolean bl2 = false;
            ProcessNameMonitor.Companion.getLOGGER$intellij_android_adb().warn("Failed to send DeviceMonitorEvent", it);
        }
    }
}

