/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.tools.idea.adb.AdbShellCommandException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AdbShellCommandResult {
    @NotNull
    private String myCommand;
    @NotNull
    private final List<String> myOutput;
    private final boolean myError;

    public AdbShellCommandResult(@NotNull String command2, @NotNull List<String> output, boolean isError) {
        this.myCommand = command2;
        this.myOutput = output;
        this.myError = isError;
    }

    @NotNull
    public List<String> getOutput() {
        return this.myOutput;
    }

    public boolean isEmpty() {
        return this.myOutput.isEmpty() || this.myOutput.size() == 1 && this.myOutput.get(0).isEmpty();
    }

    public boolean isError() {
        return this.myError;
    }

    public void throwIfError() throws AdbShellCommandException {
        if (this.isError()) {
            if (this.myOutput.size() == 1) {
                throw AdbShellCommandException.create(this.myOutput.get(0), new Object[0]);
            }
            throw AdbShellCommandException.create("Error executing shell command %s", this.myCommand);
        }
    }
}

