/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.adblib.AdbSession;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.ddmlibcompatibility.debugging.AdbLibClientManagerFactory;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AdbVersion;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutRemainder;
import com.android.ddmlib.clientmanager.ClientManager;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.AdbLogOutput;
import com.android.tools.idea.adb.AdbOptionsService;
import com.android.tools.idea.adb.StudioDDMLibJdwpTracer;
import com.android.tools.idea.adblib.AdbLibApplicationService;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class AdbService
implements Disposable,
AdbOptionsService.AdbOptionsListener,
AndroidDebugBridge.IDebugBridgeChangeListener {
    private static final Logger LOG = Logger.getInstance(AdbService.class);
    public static final int ADB_DEFAULT_TIMEOUT_MILLIS = (int)TimeUnit.MINUTES.toMillis(50L);
    private static final long ADB_TERMINATE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ListeningExecutorService mySequentialExecutor = MoreExecutors.listeningDecorator((ExecutorService)SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"AdbService Executor"));
    @NotNull
    private final Implementation myImplementation = new Implementation();
    private boolean myAllowMdnsOpenscreen = true;
    private boolean myInitializationErrorShown = false;
    private static final String MDNS_OPENSCREEN_FIX_ADB_VERSION = "1.0.42";
    @NotNull
    private static final CoroutineScopeCache.Key<ClientManager> CLIENT_MANAGER_KEY = new CoroutineScopeCache.Key("client manager for ddmlib compatibility");

    public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
    }

    public void initializationError(@NotNull Exception exception) {
        if (!(SystemInfo.isWindows && AdbOptionsService.getInstance().shouldUseMdnsOpenScreen() && exception instanceof IOException && exception.getMessage().startsWith("An existing connection was forcibly closed by the remote host"))) {
            return;
        }
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null) {
            return;
        }
        AdbVersion version2 = bridge.getCurrentAdbVersion();
        if (version2 == null || version2.compareTo(AdbVersion.parseFrom((String)MDNS_OPENSCREEN_FIX_ADB_VERSION)) >= 0) {
            return;
        }
        Log.w((String)"Remote shutdown of adb host was detected, attempting to restart server without MDNS Openscreen.", (Throwable)exception);
        String helpMessage = String.format("Error initializing adb with MDNS Openscreen enabled.\nAttempting restart adb with option disabled.\nTry updating to a newer version of ADB (%s or later).", MDNS_OPENSCREEN_FIX_ADB_VERSION);
        Notification notification = NotificationGroup.balloonGroup((String)"Adb Service").createNotification(helpMessage, NotificationType.WARNING).setImportant(true);
        Arrays.stream(ProjectManager.getInstance().getOpenProjects()).forEach(arg_0 -> ((Notification)notification).notify(arg_0));
        this.myAllowMdnsOpenscreen = false;
        if (!this.myInitializationErrorShown) {
            PopupUtil.showBalloonForActiveComponent((String)helpMessage, (MessageType)MessageType.WARNING);
            this.myInitializationErrorShown = true;
        }
        try {
            this.terminateDdmlib();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static AdbService getInstance() {
        return (AdbService)ApplicationManager.getApplication().getService(AdbService.class);
    }

    @NotNull
    public static String getDebugBridgeDiagnosticErrorMessage(@NotNull Throwable t, @NotNull File adb) {
        String msg = t.getMessage() != null ? t.getMessage() : String.format("Unable to establish a connection to adb.\n\nCheck the Event Log for possible issues.\nThis can happen if you have an incompatible version of adb running already,\nor if localhost is pointing to the wrong address.\nTry re-opening %1$s after killing any existing adb daemons and verifying that your\nlocalhost entry is pointing to 127.0.0.1 or ::1 for IPv4 or IPv6, respectively.\n\nIf this happens repeatedly, please file a bug at http://b.android.com including the following:\n  1. Output of the command: '%2$s devices'\n  2. Your idea.log file (Help | Show Log in Explorer)\n", ApplicationNamesInfo.getInstance().getProductName(), adb.getAbsolutePath());
        return msg;
    }

    @NotNull
    public ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        return this.mySequentialExecutor.submit(() -> this.myImplementation.getAndroidDebugBridge(adb));
    }

    @NotNull
    public ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull Project project) {
        File adbFile = AdbFileProvider.fromProject(project).get();
        if (adbFile == null) {
            LOG.warn("The path to the ADB command is not available");
            return Futures.immediateFailedFuture((Throwable)new FileNotFoundException("The path to the ADB command is not available"));
        }
        return this.getDebugBridge(adbFile);
    }

    public void terminateDdmlib() throws TimeoutException {
        try {
            this.mySequentialExecutor.submit(this.myImplementation::terminate).get(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to terminate ADB", (Throwable)e);
        }
    }

    public void dispose() {
        LOG.info("Disposing AdbService");
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AdbOptionsService.getInstance().removeListener(this);
        try {
            this.mySequentialExecutor.submit(() -> {
                this.myImplementation.terminate();
                this.mySequentialExecutor.shutdownNow();
            }).get(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to dispose AdbService within specified timeout", (Throwable)e);
            return;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Error while disposing AdbService");
            return;
        }
        try {
            if (!this.mySequentialExecutor.awaitTermination(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)) {
                LOG.warn("Failed to shut down executor within specified timeout.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Executor shutdown interrupted.", (Throwable)e);
        }
    }

    @Override
    public void optionsChanged() {
        this.mySequentialExecutor.execute(() -> this.myImplementation.optionsChanged());
    }

    private AdbService() {
        String defaultLogLevel = AdbLogOutput.SystemLogRedirecter.getLogger().isTraceEnabled() ? Log.LogLevel.VERBOSE.getStringValue() : (AdbLogOutput.SystemLogRedirecter.getLogger().isDebugEnabled() ? Log.LogLevel.DEBUG.getStringValue() : Log.LogLevel.INFO.getStringValue());
        DdmPreferences.setLogLevel((String)defaultLogLevel);
        DdmPreferences.setTimeOut((int)ADB_DEFAULT_TIMEOUT_MILLIS);
        Log.addLogger((Log.ILogOutput)new AdbLogOutput.SystemLogRedirecter());
        AdbOptionsService.getInstance().addListener(this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.setJdwpTracerFactory(() -> new StudioDDMLibJdwpTracer((Boolean)StudioFlags.JDWP_TRACER.get()){});
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (ProjectManager.getInstance().getOpenProjects().length == 0) {
                    LOG.info("Ddmlib can be terminated as all projects have been closed");
                    ListenableFuture terminateAdb = AdbService.this.mySequentialExecutor.submit(AdbService.this.myImplementation::terminate);
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        try {
                            terminateAdb.get(30L, TimeUnit.SECONDS);
                        }
                        catch (Throwable e) {
                            LOG.warn("Failed to terminate ddmlib.", e);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        });
    }

    @NotNull
    private static AdbInitOptions getAdbInitOptions() {
        AdbInitOptions.Builder options2 = AdbInitOptions.builder();
        options2.setClientSupportEnabled(true);
        options2.useJdwpProxyService(((Boolean)StudioFlags.ENABLE_JDWP_PROXY_SERVICE.get()).booleanValue());
        options2.useDdmlibCommandService(((Boolean)StudioFlags.ENABLE_DDMLIB_COMMAND_SERVICE.get()).booleanValue());
        options2.withEnv("ADB_LIBUSB", AdbOptionsService.getInstance().shouldUseLibusb() ? "1" : "0");
        if (((Boolean)StudioFlags.ADB_WIRELESS_PAIRING_ENABLED.get()).booleanValue() && AdbService.getInstance().myAllowMdnsOpenscreen) {
            options2.withEnv("ADB_MDNS_OPENSCREEN", AdbOptionsService.getInstance().shouldUseMdnsOpenScreen() ? "1" : "0");
        }
        AdbService.getInstance().myAllowMdnsOpenscreen = true;
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode()) {
            options2.withEnv("HOME", Files.createTempDir().getAbsolutePath());
        }
        if (AdbOptionsService.getInstance().shouldUseUserManagedAdb()) {
            options2.enableUserManagedAdbMode(AdbOptionsService.getInstance().getUserManagedAdbPort());
        }
        options2.setClientManager((ClientManager)((Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER.get() != false ? AdbService.getClientManager() : null));
        return options2.build();
    }

    @NotNull
    private static ClientManager getClientManager() {
        AdbSession session = AdbLibApplicationService.getInstance().getSession();
        return (ClientManager)session.getCache().getOrPut(CLIENT_MANAGER_KEY, () -> AdbLibClientManagerFactory.createClientManager((AdbSession)session));
    }

    private static class Implementation {
        @Nullable
        private File myAdbExecutableFile = null;

        private Implementation() {
        }

        @WorkerThread
        @Nullable
        public AndroidDebugBridge getAndroidDebugBridge(@NotNull File adb) {
            AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
            if (bridge == null || !bridge.isConnected()) {
                try {
                    bridge = this.createBridge(adb);
                }
                catch (Exception e) {
                    LOG.warn("Error creating adb", (Throwable)e);
                }
            }
            return bridge;
        }

        @WorkerThread
        public void terminate() {
            try {
                LOG.info("Terminating ADB connection");
                if (!AndroidDebugBridge.disconnectBridge((long)ADB_TERMINATE_TIMEOUT_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS)) {
                    LOG.warn("ADB connection did not terminate within specified timeout");
                    throw new TimeoutException("ADB did not terminate within the specified timeout");
                }
                AndroidDebugBridge.terminate();
                LOG.info("ADB connection successfully terminated");
            }
            catch (TimeoutException e) {
                LOG.warn("Timed out waiting for adb to terminate");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        @NotNull
        private AndroidDebugBridge createBridge(@NotNull File adb) throws Exception {
            this.terminate();
            TimeoutRemainder rem = new TimeoutRemainder(20000L, TimeUnit.MILLISECONDS);
            LOG.info("Initializing adb using: " + adb.getAbsolutePath());
            AdbLogOutput.ToStringLogger toStringLogger = new AdbLogOutput.ToStringLogger();
            Log.addLogger((Log.ILogOutput)toStringLogger);
            try {
                AndroidDebugBridge.init((AdbInitOptions)AdbService.getAdbInitOptions());
                AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)adb.getPath(), (boolean)false, (long)rem.getRemainingNanos(), (TimeUnit)TimeUnit.MILLISECONDS);
                if (bridge == null) {
                    throw new Exception("Unable to start adb server: " + toStringLogger.getOutput());
                }
                while (!bridge.isConnected()) {
                    if (rem.getRemainingNanos() <= 0L) {
                        throw new Exception("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        throw new Exception("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                    }
                }
                this.myAdbExecutableFile = adb;
                LOG.info("Successfully connected to adb");
                AndroidDebugBridge androidDebugBridge = bridge;
                return androidDebugBridge;
            }
            finally {
                Log.removeLogger((Log.ILogOutput)toStringLogger);
            }
        }

        @WorkerThread
        private void optionsChanged() {
            if (this.myAdbExecutableFile == null) {
                return;
            }
            LOG.info("Options changed. Re-initing/restarting adb server if needed.");
            AndroidDebugBridge.optionsChanged((AdbInitOptions)AdbService.getAdbInitOptions(), (String)this.myAdbExecutableFile.getPath(), (boolean)false, (long)ADB_TERMINATE_TIMEOUT_MILLIS, (long)20000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }
}

