/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.annotations;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.actions.annotations.InferAnnotations;
import com.android.tools.idea.actions.annotations.InferAnnotationsAction;
import com.android.tools.idea.actions.annotations.InferAnnotationsSettings;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.ThrowableRunnable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u000bH\u0014J,\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010 \u001a\u00020\u000bH\u0002J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/actions/annotations/InferAnnotationsAction;", "Lcom/intellij/analysis/BaseAnalysisAction;", "()V", "includeTestsByDefault", "", "options", "Lcom/intellij/analysis/AnalysisUIOptions;", "settingsDialog", "Lcom/android/tools/idea/actions/annotations/InferAnnotationsSettings$SettingsPanel;", "Lcom/android/tools/idea/actions/annotations/InferAnnotationsSettings;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "analyze", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/analysis/AnalysisScope;", "canceled", "checkModules", "modules", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/PsiFile;", "getAdditionalActionSettings", "Ljavax/swing/JComponent;", "dialog", "Lcom/intellij/analysis/BaseAnalysisActionDialog;", "getAnnotationsMavenArtifact", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactId;", "restartAnalysis", "restoreTestSetting", "syncAndRestartAnalysis", "update", "event", "AnnotateTask", "Companion", "intellij.android.core"})
public final class InferAnnotationsAction
extends BaseAnalysisAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private InferAnnotationsSettings.SettingsPanel settingsDialog;
    private boolean includeTestsByDefault;
    @Nullable
    private AnalysisUIOptions options;
    @NotNull
    private static final InferAnnotationsSettings settings = new InferAnnotationsSettings();
    @NonNls
    @NotNull
    private static final String INFER_ANNOTATION_SETTINGS = "infer.annotations.settings";
    public static final int MAX_PASSES = 3;
    @NotNull
    private static final String INFER_SUPPORT_ANNOTATIONS = "Infer Support Annotations";
    private static final int MAX_ANNOTATIONS_WITHOUT_PREVIEW = 0;

    public InferAnnotationsAction() {
        super(INFER_SUPPORT_ANNOTATIONS, INFER_SUPPORT_ANNOTATIONS);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        AnalysisUIOptions analysisUIOptions;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        AnalysisUIOptions it = analysisUIOptions = AnalysisUIOptions.getInstance((Project)project2);
        boolean bl = false;
        this.options = it;
        AnalysisUIOptions options2 = analysisUIOptions;
        this.includeTestsByDefault = options2.ANALYZE_TEST_SOURCES;
        options2.ANALYZE_TEST_SOURCES = false;
        super.actionPerformed(e);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null || !((Boolean)StudioFlags.INFER_ANNOTATIONS_REFACTORING_ENABLED.get()).booleanValue() || !ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(event);
    }

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope2) {
        Map modules2;
        Unit unit;
        Unit unit2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        InferAnnotationsSettings.SettingsPanel settingsPanel = this.settingsDialog;
        if (settingsPanel != null) {
            settingsPanel.apply();
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        Object it = unit = unit2;
        boolean bl = false;
        this.settingsDialog = null;
        PropertiesComponent.getInstance().setValue(INFER_ANNOTATION_SETTINGS, settings.toString(), "");
        it = new int[1];
        it[0] = (Unit)false;
        Object fileCount2 = it;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        InferAnnotations inferrer = new InferAnnotations(settings, project);
        UsageInfo[] usageInfoArray = InferAnnotationsAction.Companion.findUsages(project, scope2, (int)fileCount2[0], inferrer);
        if (usageInfoArray == null) {
            return;
        }
        UsageInfo[] usageInfos = usageInfoArray;
        if (settings.getCheckDependencies() && !this.checkModules(project, scope2, modules2 = InferAnnotationsAction.Companion.findModulesFromUsage(usageInfos))) {
            return;
        }
        if (settings.getGenerateReport()) {
            InferAnnotationsAction.Companion.showReport(inferrer, scope2, project);
        }
        if (usageInfos.length < 0) {
            ApplicationManager.getApplication().invokeLater(InferAnnotationsAction.Companion.applyRunnable(project, (Computable<UsageInfo[]>)new Computable(usageInfos){
                final /* synthetic */ UsageInfo[] $usageInfos;
                {
                    this.$usageInfos = $usageInfos;
                }

                public final UsageInfo[] compute() {
                    return this.$usageInfos;
                }
            }));
        } else {
            InferAnnotationsAction.Companion.showUsageView(project, usageInfos, scope2);
        }
        this.restoreTestSetting();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkModules(Project project, AnalysisScope scope2, Map<Module, ? extends PsiFile> modules2) {
        Module module2;
        void $this$filterTo$iv$iv;
        GoogleMavenArtifactId artifact2 = this.getAnnotationsMavenArtifact(project);
        Iterable $this$filter$iv = modules2.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            module2 = (Module)element$iv$iv;
            boolean bl = false;
            if (!(!DependencyManagementUtil.dependsOn(module2, artifact2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set modulesWithoutAnnotations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String string = StringUtil.join((Collection)modulesWithoutAnnotations, (Function)checkModules.moduleNames.1.INSTANCE, (String)", ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(modulesWithoutAnnot\u2026dule -> obj.name }, \", \")");
        String moduleNames2 = string;
        int count2 = modulesWithoutAnnotations.size();
        String $i$f$filterTo22 = "The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android annotations.\n\nWould you like to add the %5$s now?";
        Object[] objectArray = new Object[]{StringUtil.pluralize((String)"module", (int)count2), moduleNames2, count2 > 1 ? "do" : "does", GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.getMavenArtifactId(), StringUtil.pluralize((String)"dependency", (int)count2)};
        String string2 = String.format($i$f$filterTo22, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String message2 = string2;
        if (Messages.showOkCancelDialog((Project)project, (String)message2, (String)"Infer Annotations", (String)"OK", (String)"Cancel", (Icon)Messages.getErrorIcon()) == 0) {
            RepositoryUrlManager manager = RepositoryUrlManager.Companion.get();
            String string3 = artifact2.getMavenGroupId();
            String string4 = artifact2.getMavenArtifactId();
            FileSystem fileSystem = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
            String revision = manager.getLibraryRevision(string3, string4, null, false, fileSystem);
            if (revision != null) {
                List<GradleCoordinate> added2;
                List coordinates = CollectionsKt.listOf((Object)artifact2.getCoordinate(revision));
                Iterator iterator2 = modulesWithoutAnnotations.iterator();
                while (iterator2.hasNext() && !(added2 = DependencyManagementUtil.addDependenciesWithUiConfirmation(module2 = (Module)iterator2.next(), coordinates, false, false)).isEmpty()) {
                }
                this.syncAndRestartAnalysis(project, scope2);
            }
        }
        return false;
    }

    private final GoogleMavenArtifactId getAnnotationsMavenArtifact(Project project) {
        return GoogleMavenArtifactId.ANDROIDX_SUPPORT_ANNOTATIONS;
    }

    private final void syncAndRestartAnalysis(Project project, AnalysisScope scope2) {
        boolean bl = ApplicationManager.getApplication().isDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        Futures.addCallback(syncResult, (FutureCallback)((FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(this, project, scope2){
            final /* synthetic */ InferAnnotationsAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ AnalysisScope $scope;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$scope = $scope;
            }

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                if (syncResult != null && syncResult.isSuccessful()) {
                    InferAnnotationsAction.access$restartAnalysis(this.this$0, this.$project, this.$scope);
                }
            }

            public void onFailure(@Nullable Throwable t) {
                throw new RuntimeException(t);
            }
        }), (Executor)MoreExecutors.directExecutor());
    }

    private final void restartAnalysis(Project project, AnalysisScope scope2) {
        AppUIExecutor.onUiThread().inSmartMode(project).execute(new Runnable(this, project, scope2){
            final /* synthetic */ InferAnnotationsAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ AnalysisScope $scope;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$scope = $scope;
            }

            public final void run() {
                this.this$0.analyze(this.$project, this.$scope);
            }
        });
    }

    @NotNull
    protected JComponent getAdditionalActionSettings(@Nullable Project project, @Nullable BaseAnalysisActionDialog dialog2) {
        InferAnnotationsSettings.SettingsPanel settingsPanel;
        String string = PropertiesComponent.getInstance().getValue(INFER_ANNOTATION_SETTINGS, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().getValue(I\u2026_ANNOTATION_SETTINGS, \"\")");
        settings.apply(string);
        InferAnnotationsSettings.SettingsPanel it = settingsPanel = new InferAnnotationsSettings.SettingsPanel(settings);
        boolean bl = false;
        this.settingsDialog = it;
        return settingsPanel;
    }

    protected void canceled() {
        super.canceled();
        this.restoreTestSetting();
        this.settingsDialog = null;
    }

    private final void restoreTestSetting() {
        if (this.options != null) {
            this.options.ANALYZE_TEST_SOURCES = this.includeTestsByDefault;
        }
        this.options = null;
    }

    public static final /* synthetic */ void access$restartAnalysis(InferAnnotationsAction $this, Project project, AnalysisScope scope2) {
        $this.restartAnalysis(project, scope2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/actions/annotations/InferAnnotationsAction$AnnotateTask;", "Lcom/intellij/util/SequentialTask;", "myProject", "Lcom/intellij/openapi/project/Project;", "myTask", "Lcom/intellij/util/SequentialModalProgressTask;", "myInfos", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/SequentialModalProgressTask;[Lcom/intellij/usageView/UsageInfo;)V", "myCount", "", "[Lcom/intellij/usageView/UsageInfo;", "myTotal", "isDone", "", "iteration", "intellij.android.core"})
    private static final class AnnotateTask
    implements SequentialTask {
        @NotNull
        private final Project myProject;
        @NotNull
        private final SequentialModalProgressTask myTask;
        @NotNull
        private final UsageInfo[] myInfos;
        private int myCount;
        private final int myTotal;

        public AnnotateTask(@NotNull Project myProject, @NotNull SequentialModalProgressTask myTask, @NotNull UsageInfo[] myInfos) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter((Object)myTask, (String)"myTask");
            Intrinsics.checkNotNullParameter((Object)myInfos, (String)"myInfos");
            this.myProject = myProject;
            this.myTask = myTask;
            this.myInfos = myInfos;
            this.myTotal = this.myInfos.length;
        }

        public boolean isDone() {
            return this.myCount > this.myTotal - 1;
        }

        public boolean iteration() {
            ProgressIndicator indicator = this.myTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)this.myCount / (double)this.myTotal);
            }
            int n = this.myCount;
            this.myCount = n + 1;
            InferAnnotations.Companion.apply(Companion.getSettings(), this.myProject, this.myInfos[n]);
            return this.isDone();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013H\u0002J'\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u001bJ7\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\b\b\u0002\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010\"J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J+\u0010(\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010*R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/actions/annotations/InferAnnotationsAction$Companion;", "", "()V", "INFER_ANNOTATION_SETTINGS", "", "INFER_SUPPORT_ANNOTATIONS", "Lorg/jetbrains/annotations/NonNls;", "MAX_ANNOTATIONS_WITHOUT_PREVIEW", "", "MAX_PASSES", "settings", "Lcom/android/tools/idea/actions/annotations/InferAnnotationsSettings;", "getSettings", "()Lcom/android/tools/idea/actions/annotations/InferAnnotationsSettings;", "applyRunnable", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "computable", "Lcom/intellij/openapi/util/Computable;", "", "Lcom/intellij/usageView/UsageInfo;", "findModulesFromUsage", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/PsiFile;", "infos", "([Lcom/intellij/usageView/UsageInfo;)Ljava/util/Map;", "findUsages", "scope", "Lcom/intellij/analysis/AnalysisScope;", "fileCount", "inferrer", "Lcom/android/tools/idea/actions/annotations/InferAnnotations;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/AnalysisScope;ILcom/android/tools/idea/actions/annotations/InferAnnotations;)[Lcom/intellij/usageView/UsageInfo;", "rerunFactory", "Lcom/intellij/openapi/util/Factory;", "Lcom/intellij/usages/UsageSearcher;", "showReport", "", "showUsageView", "usageInfos", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/analysis/AnalysisScope;)V", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InferAnnotationsSettings getSettings() {
            return settings;
        }

        private final void showReport(InferAnnotations inferrer, AnalysisScope scope2, Project project) {
            ArrayList usages = new ArrayList();
            InferAnnotations.collect$default(inferrer, usages, scope2, this.getSettings().getIncludeBinaries(), false, 8, null);
            String report2 = null;
            try {
                Collection $this$toTypedArray$iv = usages;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
                if (usageInfoArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                report2 = InferAnnotations.Companion.generateReport(usageInfoArray);
                String fileName = "InferenceReport.txt";
                ScratchFileService.Option option = ScratchFileService.Option.create_new_always;
                VirtualFile f = ScratchRootType.getInstance().createScratchFile(project, fileName, (Language)PlainTextLanguage.INSTANCE, report2, option);
                if (f != null) {
                    FileEditorManager.getInstance((Project)project).openFile(f, true);
                }
            }
            catch (Throwable t) {
                String string = report2;
                if (string != null) {
                    String p0 = string;
                    boolean bl = false;
                    System.out.println((Object)p0);
                }
                Logger.getInstance(InferAnnotationsAction.class).warn(t);
            }
        }

        private final Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
            Map modules2 = new HashMap();
            for (UsageInfo info2 : infos) {
                Module module2;
                PsiElement element2;
                if (info2.getElement() == null || ModuleUtilCore.findModuleForPsiElement((PsiElement)element2) == null) continue;
                PsiFile file2 = element2.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                modules2.put(module2, file2);
            }
            return modules2;
        }

        private final UsageInfo[] findUsages(Project project, AnalysisScope scope2, int fileCount2, InferAnnotations inferrer) {
            ProgressIndicator indicator;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
            PsiManager psiManager2 = psiManager;
            Runnable searchForUsages2 = new Runnable(scope2, psiManager2, project, fileCount2, inferrer){
                final /* synthetic */ AnalysisScope $scope;
                final /* synthetic */ PsiManager $psiManager;
                final /* synthetic */ Project $project;
                final /* synthetic */ int $fileCount;
                final /* synthetic */ InferAnnotations $inferrer;
                {
                    this.$scope = $scope;
                    this.$psiManager = $psiManager;
                    this.$project = $project;
                    this.$fileCount = $fileCount;
                    this.$inferrer = $inferrer;
                }

                public final void run() {
                    this.$scope.accept(new PsiElementVisitor(this.$psiManager, this.$project, this.$fileCount, this.$inferrer){
                        private int myFileCount;
                        final /* synthetic */ PsiManager $psiManager;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ int $fileCount;
                        final /* synthetic */ InferAnnotations $inferrer;
                        {
                            this.$psiManager = $psiManager;
                            this.$project = $project;
                            this.$fileCount = $fileCount;
                            this.$inferrer = $inferrer;
                        }

                        public final int getMyFileCount() {
                            return this.myFileCount;
                        }

                        public final void setMyFileCount(int n) {
                            this.myFileCount = n;
                        }

                        public void visitFile(@NotNull PsiFile file2) {
                            Document document2;
                            FileViewProvider viewProvider;
                            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                            int n = this.myFileCount;
                            this.myFileCount = n + 1;
                            if (file2 instanceof PsiCompiledElement) {
                                return;
                            }
                            VirtualFile virtualFile = file2.getVirtualFile();
                            FileViewProvider fileViewProvider = viewProvider = this.$psiManager.findViewProvider(virtualFile);
                            Object object = document2 = fileViewProvider != null ? fileViewProvider.getDocument() : null;
                            if (document2 == null || virtualFile.getFileType().isBinary()) {
                                return;
                            }
                            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                            if (progressIndicator != null && !progressIndicator.isIndeterminate()) {
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"virtualFile");
                                progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath$default((VirtualFile)virtualFile, (Project)this.$project, (boolean)false, (boolean)false, (boolean)false, (int)28, null));
                                progressIndicator.setFraction((double)this.myFileCount / (double)(3 * this.$fileCount));
                            }
                            if (file2 instanceof PsiJavaFile || file2 instanceof KtFile) {
                                try {
                                    this.$inferrer.collect(file2);
                                }
                                catch (Throwable t) {
                                    Logger.getInstance(InferAnnotationsAction.class).warn(t);
                                }
                            }
                        }
                    });
                }
            };
            Runnable multipass2 = new Runnable(searchForUsages2){
                final /* synthetic */ Runnable $searchForUsages;
                {
                    this.$searchForUsages = $searchForUsages;
                }

                public final void run() {
                    for (int i = 0; i < 3; ++i) {
                        this.$searchForUsages.run();
                    }
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(multipass2, InferAnnotationsAction.INFER_SUPPORT_ANNOTATIONS, true, project)) {
                    return null;
                }
            } else {
                multipass2.run();
            }
            if ((indicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) != null) {
                indicator.setIndeterminate(true);
                indicator.setText("Post-processing results...");
            }
            ArrayList usages = new ArrayList();
            InferAnnotations.collect$default(inferrer, usages, scope2, false, false, 12, null);
            Collection $this$toTypedArray$iv = usages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
            if (usageInfoArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return usageInfoArray;
        }

        static /* synthetic */ UsageInfo[] findUsages$default(Companion companion, Project project, AnalysisScope analysisScope, int n, InferAnnotations inferAnnotations, int n2, Object object) {
            if ((n2 & 8) != 0) {
                inferAnnotations = new InferAnnotations(companion.getSettings(), project);
            }
            return companion.findUsages(project, analysisScope, n, inferAnnotations);
        }

        private final Runnable applyRunnable(Project project, Computable<UsageInfo[]> computable) {
            return new Runnable(project, computable){
                final /* synthetic */ Project $project;
                final /* synthetic */ Computable<UsageInfo[]> $computable;
                {
                    this.$project = $project;
                    this.$computable = $computable;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    LocalHistoryAction action2 = LocalHistory.getInstance().startAction("Infer Support Annotations");
                    try {
                        WriteCommandAction.writeCommandAction((Project)this.$project).withName("Infer Support Annotations").run(new ThrowableRunnable(this.$computable, this.$project){
                            final /* synthetic */ Computable<UsageInfo[]> $computable;
                            final /* synthetic */ Project $project;
                            {
                                this.$computable = $computable;
                                this.$project = $project;
                            }

                            public final void run() {
                                UsageInfo[] infos = (UsageInfo[])this.$computable.compute();
                                Intrinsics.checkNotNullExpressionValue((Object)infos, (String)"infos");
                                if (!(infos.length == 0)) {
                                    Set elements = new LinkedHashSet<E>();
                                    for (UsageInfo info2 : infos) {
                                        PsiFile containingFile;
                                        VirtualFile virtualFile;
                                        PsiElement element2 = info2.getElement();
                                        if (element2 == null || element2.getContainingFile() == null || (virtualFile = containingFile.getVirtualFile()).getFileType().isBinary()) continue;
                                        elements.add(containingFile);
                                    }
                                    if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)elements)) {
                                        return;
                                    }
                                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(this.$project, "Infer Support Annotations", false);
                                    progressTask.setMinIterationTime(200L);
                                    progressTask.setTask((SequentialTask)new AnnotateTask(this.$project, progressTask, infos));
                                    ProgressManager.getInstance().run((Task)progressTask);
                                } else {
                                    InferAnnotations.Companion.nothingFoundMessage(this.$project);
                                }
                            }
                        });
                    }
                    finally {
                        action2.finish();
                    }
                }
            };
        }

        private final void showUsageView(Project project, UsageInfo[] usageInfos, AnalysisScope scope2) {
            UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
            Ref convertUsagesRef = new Ref();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable((Ref<UsageInfo2UsageAdapter[]>)convertUsagesRef, usageInfos){
                final /* synthetic */ Ref<UsageInfo2UsageAdapter[]> $convertUsagesRef;
                final /* synthetic */ UsageInfo[] $usageInfos;
                {
                    this.$convertUsagesRef = $convertUsagesRef;
                    this.$usageInfos = $usageInfos;
                }

                public final void run() {
                    ApplicationManager.getApplication().runReadAction(new Runnable(this.$convertUsagesRef, this.$usageInfos){
                        final /* synthetic */ Ref<UsageInfo2UsageAdapter[]> $convertUsagesRef;
                        final /* synthetic */ UsageInfo[] $usageInfos;
                        {
                            this.$convertUsagesRef = $convertUsagesRef;
                            this.$usageInfos = $usageInfos;
                        }

                        public final void run() {
                            this.$convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])this.$usageInfos));
                        }
                    });
                }
            }, "Preprocess usages", true, project)) {
                return;
            }
            if (convertUsagesRef.isNull()) {
                return;
            }
            UsageInfo2UsageAdapter[] usages = (UsageInfo2UsageAdapter[])convertUsagesRef.get();
            UsageViewPresentation presentation = new UsageViewPresentation();
            presentation.setTabText("Infer Annotations Preview");
            presentation.setShowReadOnlyStatusAsRed(true);
            presentation.setShowCancelButton(true);
            presentation.setSearchString(RefactoringBundle.message((String)"usageView.usagesText"));
            UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, (Usage[])usages, presentation, this.rerunFactory(project, scope2));
            Intrinsics.checkNotNullExpressionValue((Object)usageView, (String)"getInstance(project).sho\u2026nFactory(project, scope))");
            UsageView usageView2 = usageView;
            Runnable refactoringRunnable2 = this.applyRunnable(project, (Computable<UsageInfo[]>)new Computable(usageView2){
                final /* synthetic */ UsageView $usageView;
                {
                    this.$usageView = $usageView;
                }

                public final UsageInfo[] compute() {
                    Set set = UsageViewUtil.getNotExcludedUsageInfos((UsageView)this.$usageView);
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getNotExcludedUsageInfos(usageView)");
                    Set infos = set;
                    Collection $this$toTypedArray$iv = infos;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
                    if (usageInfoArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    return usageInfoArray;
                }
            });
            String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
            usageView2.addPerformOperationAction(refactoringRunnable2, InferAnnotationsAction.INFER_SUPPORT_ANNOTATIONS, canNotMakeString, "Apply Suggestions", false);
        }

        private final Factory<UsageSearcher> rerunFactory(Project project, AnalysisScope scope2) {
            return new Factory(project, scope2){
                final /* synthetic */ Project $project;
                final /* synthetic */ AnalysisScope $scope;
                {
                    this.$project = $project;
                    this.$scope = $scope;
                }

                public final UsageSearcher create() {
                    return (UsageSearcher)new UsageInfoSearcherAdapter(this.$project, this.$scope){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ AnalysisScope $scope;
                        {
                            this.$project = $project;
                            this.$scope = $scope;
                        }

                        @NotNull
                        protected UsageInfo[] findUsages() {
                            UsageInfo[] usageInfoArray = com.android.tools.idea.actions.annotations.InferAnnotationsAction$Companion.findUsages$default(InferAnnotationsAction.Companion, this.$project, this.$scope, this.$scope.getFileCount(), null, 8, null);
                            if (usageInfoArray == null) {
                                usageInfoArray = UsageInfo.EMPTY_ARRAY;
                                Intrinsics.checkNotNullExpressionValue((Object)UsageInfo.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                            }
                            return usageInfoArray;
                        }

                        public void generate(@NotNull Processor<? super Usage> processor) {
                            Intrinsics.checkNotNullParameter(processor, (String)"processor");
                            this.processUsages(processor, this.$project);
                        }
                    };
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

