/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.actions.SendFeedbackDescriptionProvider;
import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.SendFeedbackDialog;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendFeedbackAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SendFeedbackAction.class);
    private static final String UNKNOWN_VERSION = "Unknown";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (((Boolean)StudioFlags.ENABLE_NEW_SEND_FEEDBACK_DIALOG.get()).booleanValue()) {
            ArrayList<FileInfo> list2 = new ArrayList();
            try {
                list2 = DiagnosticsSummaryFileProvider.buildFileList(e.getProject());
            }
            catch (Exception ex) {
                String message2 = "Error creating diagnostic file list: " + ex.getMessage();
                Messages.showErrorDialog((Project)e.getProject(), (String)message2, (String)"Diagnostics Summary Files");
            }
            new SendFeedbackDialog(null, list2).show();
        } else {
            SendFeedbackAction.submit(e.getProject());
        }
    }

    public static void submit(@Nullable Project project) {
        SendFeedbackAction.submit(project, "");
    }

    public static void submit(final @Nullable Project project, final @Nullable String extraDescriptionDetails) {
        new Task.Modal(project, "Collecting Data", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Collecting feedback information");
                indicator.setIndeterminate(true);
                ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
                String feedbackUrl = applicationInfo.getFeedbackUrl();
                String version2 = SendFeedbackAction.getVersion(applicationInfo);
                feedbackUrl = feedbackUrl.replace("$STUDIO_VERSION", version2);
                String description2 = SendFeedbackAction.getDescription(project);
                com.intellij.ide.actions.SendFeedbackAction.submit((Project)project, (String)feedbackUrl, (String)(description2 + extraDescriptionDetails));
            }
        }.setCancelText("Cancel").queue();
    }

    private static String getVersion(ApplicationInfoEx applicationInfo) {
        String major = applicationInfo.getMajorVersion();
        if (major == null) {
            return UNKNOWN_VERSION;
        }
        String minor = applicationInfo.getMinorVersion();
        if (minor == null) {
            return UNKNOWN_VERSION;
        }
        String micro = applicationInfo.getMicroVersion();
        if (micro == null) {
            return UNKNOWN_VERSION;
        }
        String patch = applicationInfo.getPatchVersion();
        if (patch == null) {
            return UNKNOWN_VERSION;
        }
        return String.join((CharSequence)".", major, minor, micro, patch);
    }

    @Slow
    public static String getDescription(@Nullable Project project) {
        return SendFeedbackAction.safeCall(() -> {
            StringBuilder sb = new StringBuilder(com.intellij.ide.actions.SendFeedbackAction.getDescription(null));
            sb.append("\n\n");
            sb.append(String.format("AS: %1$s\n", ApplicationInfoEx.getInstanceEx().getFullVersion()));
            sb.append(String.format("Kotlin plugin: %1$s\n", SendFeedbackAction.safeCall(SendFeedbackAction::getKotlinPluginDetails)));
            for (SendFeedbackDescriptionProvider provider2 : SendFeedbackDescriptionProvider.getProviders()) {
                provider2.getDescription(project).forEach(str -> sb.append(str + "\n"));
            }
            return sb.toString();
        });
    }

    public static String safeCall(@NotNull Supplier<String> runnable2) {
        try {
            return runnable2.get();
        }
        catch (Throwable e) {
            LOG.info("Unable to prepopulate additional version information - proceeding with sending feedback anyway. ", e);
            return "(unable to retrieve additional version information)";
        }
    }

    private static String getKotlinPluginDetails() {
        PluginId kotlinPluginId = PluginId.findId((String)"org.jetbrains.kotlin");
        IdeaPluginDescriptor kotlinPlugin = PluginManagerCore.getPlugin((PluginId)kotlinPluginId);
        if (kotlinPlugin != null) {
            return kotlinPlugin.getVersion();
        }
        return "(kotlin plugin not found)";
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setEnabled(SystemInfo.isMac || SystemInfo.isLinux || SystemInfo.isWindows);
        }
    }
}

