/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.componenttree.treetable.TreeTableHeader;
import com.android.tools.componenttree.treetable.TreeTableHeaderTraversalPolicy;
import com.android.tools.componenttree.treetable.TreeTableHeaderUI;
import com.android.tools.componenttree.treetable.TreeTableImpl;
import com.intellij.ui.JBColor;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0006\u0010$\u001a\u00020 J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010&\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/componenttree/treetable/TreeTableHeader;", "Ljavax/swing/table/JTableHeader;", "treeTable", "Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "(Lcom/android/tools/componenttree/treetable/TreeTableImpl;)V", "columnCount", "", "getColumnCount", "()I", "<set-?>", "editingColumn", "getEditingColumn", "hoverCachedComponent", "Ljava/awt/Component;", "hoverColumn", "hoverComponent", "getHoverComponent", "()Ljava/awt/Component;", "isEditing", "", "()Z", "editCellAt", "columnIndex", "getPreferredSize", "Ljava/awt/Dimension;", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "hoverComponentAt", "Ljavax/swing/JComponent;", "paintBottomSeparator", "", "g", "Ljava/awt/Graphics;", "paintComponent", "removeEditor", "updateHoverColumn", "updateUI", "HoverMouseListener", "intellij.android.layout-ui"})
public final class TreeTableHeader
extends JTableHeader {
    @NotNull
    private final TreeTableImpl treeTable;
    private int hoverColumn;
    @Nullable
    private Component hoverCachedComponent;
    private int editingColumn;

    public TreeTableHeader(@NotNull TreeTableImpl treeTable) {
        Intrinsics.checkNotNullParameter((Object)treeTable, (String)"treeTable");
        super(treeTable.getColumnModel());
        this.treeTable = treeTable;
        this.hoverColumn = -1;
        this.editingColumn = -1;
        this.reorderingAllowed = false;
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new TreeTableHeaderTraversalPolicy(this));
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setOpaque(false);
        HoverMouseListener mouseListener2 = new HoverMouseListener();
        this.addMouseListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
    }

    public final int getEditingColumn() {
        return this.editingColumn;
    }

    public final boolean isEditing() {
        return this.editingColumn >= 0;
    }

    public final int getColumnCount() {
        return this.treeTable.getColumnCount();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean editCellAt(int columnIndex) {
        TableColumn column2 = this.columnModel.getColumn(columnIndex);
        Component component2 = column2.getHeaderRenderer().getTableCellRendererComponent((JTable)((Object)this.treeTable), null, false, false, 0, columnIndex);
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"columnModel.columns");
        Sequence sequence = SequencesKt.take((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (int)columnIndex);
        int n = 0;
        for (Object e : sequence) {
            void it;
            TableColumn tableColumn = (TableColumn)e;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getWidth();
            n = n2 + n3;
        }
        int x = n;
        component2.setBounds(x, 0, column2.getWidth(), this.getHeight() - 1);
        this.removeEditor();
        this.add(component2);
        component2.validate();
        component2.repaint();
        this.editingColumn = columnIndex;
        return true;
    }

    public final void removeEditor() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"components");
        Component editor = (Component)ArraysKt.firstOrNull((Object[])componentArray);
        if (editor != null && IJSwingUtilities.hasFocus((Component)editor)) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearFocusOwner();
        }
        this.removeAll();
        this.editingColumn = -1;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int n = size.height;
        size.height = n + 1;
        Intrinsics.checkNotNullExpressionValue((Object)size, (String)"size");
        return size;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        this.treeTable.paintColumnDividers(g);
        this.paintBottomSeparator(g);
    }

    @Override
    public void updateUI() {
        this.setUI(new TreeTableHeaderUI());
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"columnModel.columns");
        Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableColumn it = (TableColumn)element$iv;
            boolean bl = false;
            TableCellRenderer tableCellRenderer = it.getHeaderRenderer();
            Component component2 = tableCellRenderer != null ? tableCellRenderer.getTableCellRendererComponent(this.table, null, false, false, 0, it.getModelIndex()) : null;
            IJSwingUtilities.updateComponentTreeUI(component2);
        }
    }

    @Override
    @Nullable
    public String getToolTipText(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateHoverColumn(event);
        JComponent jComponent = this.hoverComponentAt(event);
        return jComponent != null ? jComponent.getToolTipText() : null;
    }

    private final void paintBottomSeparator(Graphics g) {
        Graphics g2 = g.create();
        g2.setColor(JBColor.border());
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g2.dispose();
    }

    private final void updateHoverColumn(MouseEvent event) {
        Serializable serializable;
        int column2 = this.table.columnAtPoint(event.getPoint());
        if (column2 != this.hoverColumn) {
            this.hoverColumn = column2;
            this.hoverCachedComponent = null;
        }
        if ((serializable = this.hoverComponentAt(event)) == null || (serializable = serializable.getCursor()) == null) {
            serializable = Cursor.getDefaultCursor();
        }
        this.setCursor((Cursor)serializable);
    }

    private final JComponent hoverComponentAt(MouseEvent event) {
        Serializable serializable;
        Component component2 = this.getHoverComponent();
        if (component2 == null) {
            return null;
        }
        Component columnComponent = component2;
        Rectangle cellRect = this.getHeaderRect(this.hoverColumn);
        columnComponent.setBounds(0, 0, cellRect.width, cellRect.height);
        columnComponent.doLayout();
        Point it = serializable = event.getPoint();
        boolean bl = false;
        it.translate(-cellRect.x, -cellRect.y);
        Point point = serializable;
        serializable = SwingUtilities.getDeepestComponentAt(columnComponent, point.x, point.y);
        return serializable instanceof JComponent ? (JComponent)serializable : null;
    }

    private final Component getHoverComponent() {
        if (this.hoverCachedComponent == null && this.hoverColumn != -1) {
            TableColumn aColumn = this.columnModel.getColumn(this.hoverColumn);
            TableCellRenderer tableCellRenderer = aColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getDefaultRenderer();
            }
            TableCellRenderer renderer2 = tableCellRenderer;
            this.hoverCachedComponent = renderer2.getTableCellRendererComponent(this.table, aColumn.getHeaderValue(), false, false, -1, this.hoverColumn);
        }
        return this.hoverCachedComponent;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/componenttree/treetable/TreeTableHeader$HoverMouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/android/tools/componenttree/treetable/TreeTableHeader;)V", "mouseClicked", "", "event", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "redispatchMouseEvent", "intellij.android.layout-ui"})
    private final class HoverMouseListener
    extends MouseAdapter {
        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.updateHoverColumn(event);
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.updateHoverColumn(event);
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.updateHoverColumn(event);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.hoverColumn = -1;
            TreeTableHeader.this.hoverCachedComponent = null;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.redispatchMouseEvent(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.redispatchMouseEvent(event);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.redispatchMouseEvent(event);
        }

        private final void redispatchMouseEvent(MouseEvent event) {
            Point point;
            TreeTableHeader.this.updateHoverColumn(event);
            JComponent jComponent = TreeTableHeader.this.hoverComponentAt(event);
            if (jComponent == null) {
                return;
            }
            JComponent component2 = jComponent;
            Rectangle cellRect = TreeTableHeader.this.getHeaderRect(TreeTableHeader.this.hoverColumn);
            Point it = point = event.getPoint();
            boolean bl = false;
            it.translate(-cellRect.x, -cellRect.y);
            Point point2 = point;
            Sequence $this$forEach$iv = SequencesKt.generateSequence((Object)component2, (Function1)redispatchMouseEvent.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JComponent it2 = (JComponent)element$iv;
                boolean bl2 = false;
                point2.translate(-it2.getX(), -it2.getY());
            }
            MouseEvent newEvent = new MouseEvent(component2, event.getID(), event.getWhen(), event.getModifiers() | event.getModifiersEx(), point2.x, point2.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
            component2.dispatchEvent(newEvent);
        }
    }
}

