/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.componenttree.treetable.TreeTableImpl;
import com.android.tools.componenttree.treetable.TreeTableModelImpl;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\fH\u0002J\u0018\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0006H\u0002J \u0010+\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020&2\u0006\u0010-\u001a\u000200J\u0010\u00101\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00102\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u00103\u001a\u00020&J\u0010\u00104\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001fH\u0016J\u0010\u00105\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001fH\u0016J\u0006\u00106\u001a\u00020&R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00020\u0010*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\u0010*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00067"}, d2={"Lcom/android/tools/componenttree/treetable/TreeTableDropTargetHandler;", "Lcom/intellij/ide/dnd/DnDDropHandler$WithResult;", "Lcom/intellij/ide/dnd/DnDTargetChecker;", "table", "Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "deleteOriginOfInternalMove", "", "draggedItems", "", "", "(Lcom/android/tools/componenttree/treetable/TreeTableImpl;ZLjava/util/List;)V", "dashedStroke", "Ljava/awt/Stroke;", "insertionBounds", "Ljava/awt/Rectangle;", "insertionDepth", "", "insertionRow", "lastDropWasPossible", "lineColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "receiverBounds", "receiverRow", "bottom", "getBottom", "(Ljava/awt/Rectangle;)I", "right", "getRight", "transferable", "Ljava/awt/datatransfer/Transferable;", "Lcom/intellij/ide/dnd/DnDEvent;", "getTransferable", "(Lcom/intellij/ide/dnd/DnDEvent;)Ljava/awt/datatransfer/Transferable;", "canDropInto", "receiver", "data", "clearInsertionPoint", "", "createDashStroke", "dropPossible", "event", "possible", "findReceiver", "paintColumnLine", "g", "Ljava/awt/Graphics2D;", "paintDropTargetPosition", "Ljava/awt/Graphics;", "paintInsertionLine", "paintReceiverRectangle", "reset", "tryDrop", "update", "updateUI", "intellij.android.layout-ui"})
public final class TreeTableDropTargetHandler
implements DnDDropHandler.WithResult,
DnDTargetChecker {
    @NotNull
    private final TreeTableImpl table;
    private final boolean deleteOriginOfInternalMove;
    @NotNull
    private final List<Object> draggedItems;
    @NotNull
    private Color lineColor;
    @NotNull
    private Stroke dashedStroke;
    private int insertionRow;
    private int insertionDepth;
    @Nullable
    private Rectangle insertionBounds;
    private int receiverRow;
    @Nullable
    private Rectangle receiverBounds;
    private boolean lastDropWasPossible;

    public TreeTableDropTargetHandler(@NotNull TreeTableImpl table2, boolean deleteOriginOfInternalMove, @NotNull List<Object> draggedItems) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter(draggedItems, (String)"draggedItems");
        this.table = table2;
        this.deleteOriginOfInternalMove = deleteOriginOfInternalMove;
        this.draggedItems = draggedItems;
        Color color = ColorUtil.brighter((Color)UIUtil.getTreeSelectionBackground((boolean)true), (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(UIUtil.getTreeS\u2026tionBackground(true), 10)");
        this.lineColor = color;
        this.dashedStroke = this.createDashStroke();
        this.insertionRow = -1;
        this.insertionDepth = -1;
        this.receiverRow = -1;
    }

    public boolean tryDrop(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object receiver2 = this.table.getValueAt(this.receiverRow, 0);
        boolean isMove = event.getAction() == DnDAction.MOVE;
        int beforeIndex = this.insertionRow;
        Object before = null;
        while (true) {
            boolean bl;
            block6: {
                Object item2 = this.table.getValueAt(beforeIndex, 0);
                TreeTableModelImpl treeTableModelImpl = this.table.getTableModel();
                Intrinsics.checkNotNullExpressionValue((Object)receiver2, (String)"receiver");
                boolean insertAfterLastItemInReceiver = beforeIndex - this.receiverRow > treeTableModelImpl.children(receiver2).size();
                Object object = before = !insertAfterLastItemInReceiver ? item2 : null;
                if (!isMove || before == null) break;
                Iterable $this$none$iv = this.draggedItems;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$none$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(it == before)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) break;
            ++beforeIndex;
        }
        if (!this.table.getTableModel().insert(receiver2, this.getTransferable(event), before, isMove, this.draggedItems)) {
            this.clearInsertionPoint();
            return false;
        }
        if (isMove && !this.deleteOriginOfInternalMove) {
            this.draggedItems.clear();
        }
        this.clearInsertionPoint();
        return true;
    }

    public final void updateUI() {
        Color color = ColorUtil.brighter((Color)UIUtil.getTreeSelectionBackground((boolean)true), (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(UIUtil.getTreeS\u2026tionBackground(true), 10)");
        this.lineColor = color;
        this.dashedStroke = this.createDashStroke();
    }

    public final void reset() {
        this.clearInsertionPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintDropTargetPosition(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.insertionRow >= 0) {
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2 = (Graphics2D)graphics;
            try {
                g2.setColor(this.lineColor);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.paintReceiverRectangle(g2);
                this.paintInsertionLine(g2);
                this.paintColumnLine(g2);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private final Stroke createDashStroke() {
        float[] fArray = new float[]{JBUIScale.scale((float)4.0f), JBUIScale.scale((float)4.0f)};
        return new BasicStroke(JBUIScale.scale((float)1.0f), 2, 0, JBUIScale.scale((float)10.0f), fArray, 0.0f);
    }

    private final void paintReceiverRectangle(Graphics2D g) {
        block0: {
            Rectangle rectangle = this.receiverBounds;
            if (rectangle == null) break block0;
            Rectangle it = rectangle;
            boolean bl = false;
            int x = Math.max(0, it.x - JBUIScale.scale((int)2));
            int maxWidth = this.table.getColumnModel().getColumn(0).getWidth();
            int width = Math.min(maxWidth - x, it.width + JBUIScale.scale((int)2));
            g.drawRect(x, it.y, width, it.height);
        }
    }

    private final void paintColumnLine(Graphics2D g) {
        Rectangle rectangle = this.receiverBounds;
        int x = (rectangle != null ? rectangle.x : 0) + JBUIScale.scale((int)7);
        Rectangle rectangle2 = this.receiverBounds;
        int y = rectangle2 != null ? this.getBottom(rectangle2) : 0;
        g.setStroke(this.dashedStroke);
        Rectangle rectangle3 = this.insertionBounds;
        g.drawLine(x, y, x, rectangle3 != null ? this.getBottom(rectangle3) : y);
    }

    private final int getBottom(Rectangle $this$bottom) {
        return $this$bottom.y + $this$bottom.height;
    }

    private final int getRight(Rectangle $this$right) {
        return $this$right.x + $this$right.width;
    }

    private final void paintInsertionLine(Graphics2D g) {
        Polygon triangle = new Polygon();
        int indicatorSize = JBUIScale.scale((int)6);
        Rectangle rectangle = this.receiverBounds;
        int x = (rectangle != null ? rectangle.x : 0) + JBUIScale.scale((int)6);
        Rectangle rectangle2 = this.insertionBounds;
        int y = rectangle2 != null ? this.getBottom(rectangle2) : 0;
        triangle.addPoint(x + indicatorSize, y);
        triangle.addPoint(x, y + indicatorSize / 2);
        triangle.addPoint(x, y - indicatorSize / 2);
        Rectangle rectangle3 = this.insertionBounds;
        g.drawLine(x, y, rectangle3 != null ? this.getRight(rectangle3) : x, y);
        g.drawPolygon(triangle);
        g.fillPolygon(triangle);
    }

    public boolean update(@NotNull DnDEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Point point = new Point(event.getPoint().x, event.getPoint().y + this.table.getRowHeight() / 2);
        int column2 = this.table.columnAtPoint(point);
        if (column2 != 0) {
            return this.dropPossible(event, false);
        }
        int newInsertionDepth = this.table.findDepthFromOffset(point.x);
        Integer n = this.table.rowAtPoint(point);
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = it >= 0 ? n : null;
        int newInsertionRow = n2 != null ? n2.intValue() : this.table.getRowCount();
        if (this.insertionRow == newInsertionRow && this.insertionDepth == newInsertionDepth) {
            bl = this.dropPossible(event, this.lastDropWasPossible);
        } else if (!this.findReceiver(this.getTransferable(event), newInsertionRow, newInsertionDepth)) {
            bl = this.dropPossible(event, false);
        } else {
            this.insertionRow = newInsertionRow;
            this.insertionDepth = newInsertionDepth;
            this.insertionBounds = !this.table.isEmpty() ? this.table.getTree().getRowBounds(Math.max(0, this.insertionRow - 1)) : new Rectangle(0, 0, this.table.getColumnModel().getColumn(0).getWidth(), 0);
            this.table.repaint();
            bl = this.dropPossible(event, true);
        }
        return bl;
    }

    private final boolean dropPossible(DnDEvent event, boolean possible) {
        if (this.lastDropWasPossible && !possible) {
            this.clearInsertionPoint();
        }
        this.lastDropWasPossible = possible;
        event.setDropPossible(possible);
        return !possible;
    }

    private final boolean findReceiver(Transferable data2, int insertionRow, int insertionDepth) {
        Object object;
        this.receiverRow = -1;
        this.receiverBounds = null;
        Object item2 = null;
        Object object2 = this.table.getModel().getValueAt(insertionRow - 1, 0);
        if (object2 == null) {
            return false;
        }
        Object it = object = (item2 = object2);
        boolean bl = false;
        Object receiver2 = this.canDropInto(item2, data2) ? object : null;
        int index2 = 0;
        while (index2 + 1 >= this.table.getTableModel().getChildCount(item2) && (receiver2 == null || insertionDepth < this.table.getTableModel().computeDepth(item2)) && this.table.getTableModel().parent(item2) != null) {
            Object object3;
            Object parent2;
            index2 = this.table.getTableModel().getIndexOfChild(parent2, item2);
            Object it2 = object3 = (item2 = parent2);
            boolean bl2 = false;
            Object object4 = this.canDropInto(item2, data2) ? object3 : null;
            if (object4 == null) {
                object4 = receiver2;
            }
            receiver2 = object4;
        }
        if (receiver2 == null) {
            return false;
        }
        Collection $this$toTypedArray$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)item2, (Function1)((Function1)new Function1<Object, Object>(this){
            final /* synthetic */ TreeTableDropTargetHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TreeTableDropTargetHandler.access$getTable$p(this.this$0).getTableModel().parent(it);
            }
        }))));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        TreePath path2 = new TreePath(objectArray);
        this.receiverRow = this.table.getTree().getRowForPath(path2);
        this.receiverBounds = this.table.getTree().getPathBounds(path2);
        return true;
    }

    private final boolean canDropInto(Object receiver2, Transferable data2) {
        boolean bl;
        block5: {
            Sequence $this$none$iv = SequencesKt.generateSequence((Object)receiver2, (Function1)((Function1)new Function1<Object, Object>(this){
                final /* synthetic */ TreeTableDropTargetHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Object invoke(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return TreeTableDropTargetHandler.access$getTable$p(this.this$0).getTableModel().parent(it);
                }
            }));
            boolean $i$f$none = false;
            Iterator iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                block4: {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Iterable $this$any$iv = this.draggedItems;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator iterator3 = $this$any$iv.iterator();
                        while (iterator3.hasNext()) {
                            Object element$iv2;
                            Object dragged = element$iv2 = iterator3.next();
                            boolean bl4 = false;
                            if (!(dragged == it)) continue;
                            bl2 = true;
                            break block4;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        return bl && this.table.getTableModel().canInsert(receiver2, data2);
    }

    private final Transferable getTransferable(DnDEvent $this$transferable) {
        Object object = $this$transferable.getAttachedObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ide.dnd.DnDNativeTarget.EventInfo");
        Transferable transferable2 = ((DnDNativeTarget.EventInfo)object).getTransferable();
        Intrinsics.checkNotNullExpressionValue((Object)transferable2, (String)"attachedObject as DnDNat\u2026t.EventInfo).transferable");
        return transferable2;
    }

    private final void clearInsertionPoint() {
        this.lastDropWasPossible = false;
        boolean repaint = this.insertionRow >= 0;
        this.insertionRow = -1;
        this.insertionDepth = -1;
        this.insertionBounds = null;
        this.receiverRow = -1;
        this.receiverBounds = null;
        if (repaint) {
            this.table.repaint();
        }
    }

    public static final /* synthetic */ TreeTableImpl access$getTable$p(TreeTableDropTargetHandler $this) {
        return $this.table;
    }
}

